/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.goods;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HoldGoodsSaveValidator
extends AbstractValidator {
    public void validate() {
        QFilter qFilter;
        DynamicObjectCollection queryDo;
        HashSet<String> objectNoSet = new HashSet<String>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject holdGood = dataEntity.getDataEntity();
            DynamicObjectCollection objectDetails = holdGood.getDynamicObjectCollection("objectdetail");
            if (objectDetails == null || objectDetails.size() <= 0) continue;
            for (DynamicObject objectDetail : objectDetails) {
                DynamicObjectCollection entryEntities;
                String objNo = objectDetail.getString("objectno");
                if (EmptyUtil.isNoEmpty((String)objNo)) {
                    objectNoSet.add(objNo);
                }
                if ((entryEntities = objectDetail.getDynamicObjectCollection("entryentity")) == null || entryEntities.size() <= 0) continue;
                List properTypeList = entryEntities.stream().map(y -> y.getString("billinfo")).collect(Collectors.toList());
                HashSet properTypeSet = new HashSet(properTypeList);
                if (properTypeList.size() == properTypeSet.size()) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u7f16\u53f7\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"HoldGoods_1", (String)"tmc-am-business", (Object[])new Object[0]));
            }
        }
        if (EmptyUtil.isNoEmpty(objectNoSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(queryDo = QueryServiceHelper.query((String)"am_inventorygoodmanager", (String)"number", (QFilter[])(qFilter = new QFilter("number", "in", objectNoSet)).toArray())))) {
            Set existNumbers = queryDo.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject holdGood = dataEntity.getDataEntity();
                DynamicObjectCollection objectDetails = holdGood.getDynamicObjectCollection("objectdetail");
                if (objectDetails == null || objectDetails.size() <= 0) continue;
                for (DynamicObject objectDetail : objectDetails) {
                    String objNo = objectDetail.getString("objectno");
                    if (!existNumbers.contains(objNo)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u7f16\u53f7\u3010%s\u3011\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"HoldGoods_2", (String)"tmc-am-business", (Object[])new Object[0]), objNo));
                }
            }
        }
    }
}

