/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.holdgoodsmainfest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class HoldGoodsMainFestAuditValidator
extends AbstractValidator {
    public void validate() {
        List<Object> targetPkList = new ArrayList();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            targetPkList.clear();
            DynamicObject manifestDo = dataEntity.getDataEntity();
            String businessType = manifestDo.getString("businesstype");
            DynamicObjectCollection entryEntity = manifestDo.getDynamicObjectCollection("entryentity");
            targetPkList = entryEntity.stream().map(y -> {
                DynamicObject inventGood = y.getDynamicObject("inventorygood");
                return Long.parseLong(inventGood.getPkValue().toString());
            }).collect(Collectors.toList());
            DynamicObject[] inventGoodsDos = BusinessDataServiceHelper.load((Object[])targetPkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_inventorygoodmanager"));
            boolean flag = this.isCheck(inventGoodsDos, businessType);
            if (flag) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5b58\u5728\u5b9e\u7269\u72b6\u6001\u5df2\u7ecf\u88ab\u6539\u53d8\u3002", (String)"HoldGoodsManifest_13", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }

    private boolean isCheck(DynamicObject[] inventGoodsDos, String businessType) {
        boolean result = true;
        block15: for (DynamicObject invGoodDy : inventGoodsDos) {
            String goodStatus = invGoodDy.getString("goodstatus");
            boolean adoptionStatus = invGoodDy.getBoolean("adoptionstatus");
            switch (businessType) {
                case "adoption": {
                    if (!adoptionStatus) continue block15;
                    result = false;
                    continue block15;
                }
                case "logout": {
                    if (!goodStatus.equalsIgnoreCase("E")) continue block15;
                    result = false;
                    continue block15;
                }
                case "invalid": {
                    if (!goodStatus.equalsIgnoreCase("C")) continue block15;
                    result = false;
                    continue block15;
                }
                case "transfer": 
                case "return": {
                    if (adoptionStatus) continue block15;
                    result = false;
                    continue block15;
                }
                case "loss": {
                    if (!goodStatus.equalsIgnoreCase("D")) continue block15;
                    result = false;
                }
            }
        }
        return result;
    }
}

