/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.holdgoodsmainfest;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class HoldGoodsMainFestSaveValidator
extends AbstractValidator {
    public void validate() {
        List<Object> targetPkList = new ArrayList();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            targetPkList.clear();
            DynamicObject manifestDo = dataEntity.getDataEntity();
            String businessType = manifestDo.getString("businesstype");
            DynamicObjectCollection entryEntity = manifestDo.getDynamicObjectCollection("entryentity");
            targetPkList = entryEntity.stream().map(y -> {
                DynamicObject inventGood = y.getDynamicObject("inventorygood");
                return Long.parseLong(inventGood.getPkValue().toString());
            }).collect(Collectors.toList());
            DynamicObject[] inventGoodsDo = BusinessDataServiceHelper.load((Object[])targetPkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_inventorygoodmanager"));
            ArrayList<String> statusLs = new ArrayList<String>();
            statusLs.add("A");
            statusLs.add("B");
            QFilter[] filters = new QFilter[]{new QFilter("entryentity.inventorygood.id", "in", targetPkList), new QFilter("status", "in", statusLs), new QFilter("id", "not in", manifestDo.getPkValue())};
            DynamicObject manifestBill = BusinessDataServiceHelper.loadSingleFromCache((String)"am_holdgoods_use", (QFilter[])filters);
            if (null != manifestBill) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u5b9e\u7269\u6b63\u5728\u88ab\u7f16\u8f91\u3002", (String)"HoldGoodsManifest_8", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (entryEntity == null || entryEntity.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5b9e\u7269\u3002", (String)"HoldGoodsManifest_11", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            boolean flag = this.isCheck(inventGoodsDo, businessType);
            if (!flag) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u5b9e\u7269\u72b6\u6001\u5df2\u7ecf\u88ab\u6539\u53d8\u3002", (String)"HoldGoodsManifest_12", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (!businessType.equalsIgnoreCase("change")) continue;
            DynamicObjectCollection changeDc = manifestDo.getDynamicObjectCollection("changeentryentity");
            if (changeDc == null || changeDc.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u4e1a\u52a1\u53d8\u66f4\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsManifest_4", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            Date startDate = null;
            Date endDate = null;
            List properTypeList = changeDc.stream().map(y -> y.getString("propertytype")).collect(Collectors.toList());
            HashSet properTypeSet = new HashSet(properTypeList);
            if (properTypeList.size() != properTypeSet.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5217\u8868\u9700\u8981\u4fee\u6539\u7684\u53d8\u66f4\u5c5e\u6027\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"HoldGoodsManifest_1", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            int i = 0;
            for (DynamicObject changeDy : changeDc) {
                String afterChangeValue;
                ++i;
                String propertyType = changeDy.getString("propertytype");
                if (propertyType.equalsIgnoreCase("startdate")) {
                    startDate = (Date)changeDy.get("c" + propertyType);
                } else if (propertyType.equalsIgnoreCase("enddate")) {
                    endDate = (Date)changeDy.get("c" + propertyType);
                }
                if (!(afterChangeValue = changeDy.getString("afterchange")).isEmpty() || !propertyType.equalsIgnoreCase("goodsname") && !propertyType.equalsIgnoreCase("startdate")) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u4fe1\u606f\u4e2d\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u5c5e\u6027\u503c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5220\u9664\u8be5\u884c\u53d8\u66f4\u8bb0\u5f55\u540e\u518d\u4fdd\u5b58\u3002", (String)"HoldGoodsManifest_7", (String)"tmc-am-business", (Object[])new Object[0]), i));
            }
            flag = false;
            if (startDate != null && endDate != null) {
                flag = endDate.before(startDate);
                if (!flag) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5217\u8868\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"HoldGoodsManifest_2", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (startDate != null) {
                for (DynamicObject holdGood : inventGoodsDo) {
                    Date srcEndDate = holdGood.getDate("enddate");
                    if (srcEndDate == null || !(flag = srcEndDate.before(startDate))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5217\u8868\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5e93\u5b58\u5b9e\u7269\u7684\u5931\u6548\u65e5\u671f\u3002", (String)"HoldGoodsManifest_5", (String)"tmc-am-business", (Object[])new Object[0]));
                }
                continue;
            }
            if (endDate == null) continue;
            for (DynamicObject holdGood : inventGoodsDo) {
                Date srcStartDate = holdGood.getDate("startdate");
                flag = endDate.before(srcStartDate);
                if (!flag) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5217\u8868\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5e93\u5b58\u5b9e\u7269\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"HoldGoodsManifest_6", (String)"tmc-am-business", (Object[])new Object[0]));
            }
        }
    }

    private boolean isCheck(DynamicObject[] inventGoodsDos, String businessType) {
        boolean result = true;
        block15: for (DynamicObject invGoodDy : inventGoodsDos) {
            String goodStatus = invGoodDy.getString("goodstatus");
            boolean adoptionStatus = invGoodDy.getBoolean("adoptionstatus");
            if (goodStatus.equalsIgnoreCase("B")) continue;
            switch (businessType) {
                case "change": {
                    if (goodStatus.equalsIgnoreCase("A")) continue block15;
                    result = false;
                    continue block15;
                }
                case "adoption": 
                case "logout": 
                case "invalid": {
                    if (goodStatus.equalsIgnoreCase("A") && !adoptionStatus) continue block15;
                    result = false;
                    continue block15;
                }
                case "transfer": 
                case "return": {
                    if (goodStatus.equalsIgnoreCase("A") && adoptionStatus) continue block15;
                    result = false;
                    continue block15;
                }
                case "loss": {
                    if (goodStatus.equalsIgnoreCase("A")) continue block15;
                    result = false;
                }
            }
        }
        return result;
    }
}

