/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.holdgoodsmainfest;

import java.util.ArrayList;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject manifestDo = dataEntity.getDataEntity();
            DynamicObjectCollection holdGoods = manifestDo.getDynamicObjectCollection("entryentity");
            String businessType = manifestDo.getString("businesstype");
            String targetBillType = "am_holdgoods_use";
            switch (businessType.toLowerCase(Locale.ROOT)) {
                case "change": 
                case "logout": 
                case "loss": 
                case "invalid": {
                    targetBillType = "am_holdgoods_update";
                    break;
                }
            }
            ArrayList<Long> goodIdLst = new ArrayList<Long>();
            for (DynamicObject goods : holdGoods) {
                goodIdLst.add(Long.parseLong(goods.getPkValue().toString()));
            }
            if (goodIdLst.size() <= 0) continue;
            String selectField = "id,entryentity.inventorygood.id goodId,entryentity.inventorygood.name goodName";
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and("entryentity.inventorygood.id", "in", goodIdLst);
            qFilter.and("entryentity.inventorygood.goodstatus", "=", (Object)"A");
            qFilter.and("id", ">", manifestDo.getPkValue());
            DynamicObjectCollection resultDt = QueryServiceHelper.query((String)targetBillType, (String)selectField, (QFilter[])qFilter.toArray(), null);
            if (resultDt.size() <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5b9e\u7269\u72b6\u6001\u4e0d\u662f\u5df2\u751f\u6548\u7684\u6216\u8005\u8be5\u8bb0\u5f55\u4e0d\u662f\u6700\u540e\u4e00\u6b21\u4f7f\u7528\u8bb0\u5f55\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"HoldGoodsManifest_0", (String)"tmc-am-opplugin", (Object[])new Object[0]));
        }
    }
}

