/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.linkpay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LinkPayRelationValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("currency");
        selector.add("entryentity.e_account");
        selector.add("entryentity.e_parentacct");
        selector.add("entryentity.e_applcondition");
        selector.add("acctpaymodel");
        selector.add("entryentity.e_default");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        HashMap map = new HashMap(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u652f\u4ed8\u5173\u7cfb\u4fe1\u606f", (String)"LinkPayRelationValidator_0", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            ArrayList<Long> accountIdList = new ArrayList<Long>(entrys.size());
            for (DynamicObject entry : entrys) {
                Long parentacctId;
                DynamicObject parentAcct;
                List<DynamicObject> list;
                Long accountId = entry.getDynamicObject("e_account").getLong("id");
                accountIdList.add(accountId);
                if (map.containsKey(accountId)) {
                    list = (List)map.get(accountId);
                    list.add(entry);
                } else {
                    list = new ArrayList();
                    list.add(entry);
                    map.put(accountId, list);
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)(parentAcct = entry.getDynamicObject("e_parentacct"))) || !Objects.equals(accountId, parentacctId = Long.valueOf(parentAcct.getLong("id")))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u6237\u4e0e\u6bcd\u8d26\u6237\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539", (String)"LinkPayRelationValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            for (List entryList : map.values()) {
                Object ent2;
                if (entryList.size() == 1) continue;
                for (Object ent2 : entryList) {
                    String applcondition = ent2.getString("e_applcondition");
                    if (!EmptyUtil.isEmpty((String)applcondition)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ef4\u62a4\u9002\u7528\u6761\u4ef6\u4e3a\u7a7a\u7684\u591a\u4e2a\u76f8\u540c\u8d26\u6237\u5bf9", (String)"LinkPayRelationValidator_2", (String)"tmc-am-business", (Object[])new Object[0]));
                }
                boolean isDefault = true;
                ent2 = entryList.iterator();
                while (ent2.hasNext()) {
                    DynamicObject ent3 = (DynamicObject)ent2.next();
                    boolean def = ent3.getBoolean("e_default");
                    if (!def) continue;
                    isDefault = false;
                }
                if (!isDefault) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u591a\u4e2a\u76f8\u540c\u8d26\u6237\u5bf9\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u9ed8\u8ba4\u6bcd\u8d26\u6237", (String)"LinkPayRelationValidator_3", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            String number = info.getString("number");
            QFilter qFilter = new QFilter("entryentity.e_account", "in", accountIdList);
            qFilter.and("acctpaymodel", "=", (Object)info.getString("acctpaymodel"));
            qFilter.and("enable", "=", (Object)true);
            qFilter.and("number", "<>", (Object)number);
            qFilter.and("currency", "=", (Object)info.getDynamicObject("currency").getLong("id"));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"am_linkpayrelation", (String)"am_linkpayrelation", (String)"entryentity.e_account.number", (QFilter[])new QFilter[]{qFilter}, null);
            StringBuilder accountNumber = new StringBuilder();
            dataSet = dataSet.distinct();
            for (Row r : dataSet) {
                accountNumber.append(r.getString("entryentity.e_account.number"));
                accountNumber.append(";");
            }
            if (accountNumber.length() <= 0) continue;
            accountNumber.deleteCharAt(accountNumber.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\u652f\u4ed8\u5173\u7cfb\u7684\u8bb0\u5f55\uff0c\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4\u3002", (String)"LinkPayRelationValidator_4", (String)"tmc-am-business", (Object[])new Object[0]), accountNumber));
        }
    }
}

