/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.openacct;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.enums.OpenAcctBillStatusEnum;
import kd.tmc.am.common.helper.AmHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.helper.CountryHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BankAcctOpenSaveValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(BankAcctOpenSaveValidator.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bank");
        selector.add("issetbankinterface");
        selector.add("bankaccountnumber");
        selector.add("acctname");
        selector.add("opendate");
        selector.add("manager");
        selector.add("managecurrency");
        selector.add("company");
        selector.add("isdefaultpay");
        selector.add("isdefaultrec");
        selector.add("acctstyle");
        selector.add("finorgtype");
        selector.add("closedatef");
        selector.add("isvirtual");
        selector.add("defaultcurrency");
        selector.add("muiticurrency");
        selector.add("bebankfunc");
        selector.add("proxycurrency");
        selector.add("proxyinquiryaccount");
        selector.add("bebankfunc");
        selector.add("bankinterface");
        selector.add("ismoneypool");
        selector.add("level");
        selector.add("masteraccount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        AmBizResource amBizResource = new AmBizResource();
        BankAcctBizResource resource = new BankAcctBizResource();
        Date currentDate = new Date();
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean isCheck;
            DynamicObject bank;
            boolean isMoneyPool;
            String isOpenByProcess;
            DynamicObject bankAcctOpenBill = data.getDataEntity();
            DynamicObject company = bankAcctOpenBill.getDynamicObject("company");
            Date openDate = bankAcctOpenBill.getDate("opendate");
            Date closeDatef = bankAcctOpenBill.getDate("closedatef");
            if (openDate != null && closeDatef != null && closeDatef.compareTo(openDate) <= 0) {
                this.addErrorMessage(data, amBizResource.getCloseDatefVal());
            }
            if ("0".equals(isOpenByProcess = AmParameterHelper.getAppStringParameter((long)company.getLong("id"), (String)TmcParamEnum.AM001.getValue())) && !Objects.equals(bankAcctOpenBill.get("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
                this.addErrorMessage(data, new AmBizResource().getErrorDirecTopen());
            }
            if (isMoneyPool = bankAcctOpenBill.getBoolean("ismoneypool")) {
                String bankAcctLevel = bankAcctOpenBill.getString("level");
                DynamicObject masterAccount = bankAcctOpenBill.getDynamicObject("masteraccount");
                if (EmptyUtil.isEmpty((String)bankAcctLevel)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u662f\u5426\u8d44\u91d1\u6c60\u8d26\u6237\u201d\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u8d26\u6237\u5c42\u7ea7\u5fc5\u586b\u3002", (String)"BankAccountSaveValidator_11", (String)"tmc-am-business", (Object[])new Object[0]));
                } else if ("s".equals(bankAcctLevel) && masterAccount == null) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u8d26\u6237\u5c42\u7ea7\u201d=\u201c\u5b50\u6237\u201d\u65f6\uff0c\u5f52\u96c6\u6bcd\u8d26\u6237\u5fc5\u586b\u3002", (String)"BankAccountSaveValidator_12", (String)"tmc-am-business", (Object[])new Object[0]));
                }
            }
            logger.info("BankAcctOpenSaveValidator AccountBankProp.HEAD_STATUS:{} ", bankAcctOpenBill.get("billstatus"));
            if (bankAcctOpenBill.get("billstatus").equals(BillStatusEnum.HANDLE.getValue())) {
                Object manageCurrency;
                Object bankaccount = bankAcctOpenBill.get("bankaccountnumber");
                if (EmptyUtil.isEmpty((Object)bankaccount)) {
                    this.addErrorMessage(data, amBizResource.getOpenacctAcctnumless());
                } else {
                    QFilter exceptFilter;
                    QFilter openAcctStatusFilter;
                    DynamicObject[] openApplys;
                    QFilter qFilter = new QFilter("bankaccountnumber", "=", bankaccount);
                    DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])qFilter.toArray());
                    if (null != bankAcct) {
                        this.addErrorMessage(data, amBizResource.getOpenacctRepeatacct());
                    }
                    if ((openApplys = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{openAcctStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{OpenAcctBillStatusEnum.A.getValue(), OpenAcctBillStatusEnum.B.getValue(), OpenAcctBillStatusEnum.H.getValue(), OpenAcctBillStatusEnum.R.getValue()}), qFilter, exceptFilter = new QFilter("id", "!=", bankAcctOpenBill.getPkValue())})).length > 0) {
                        String billNo = openApplys[0].getString("billno");
                        this.addErrorMessage(data, amBizResource.getExistRepeatNumber(billNo));
                    }
                }
                boolean isSetBankInterface = bankAcctOpenBill.getBoolean("issetbankinterface");
                if (isSetBankInterface) {
                    String beBankFunc = bankAcctOpenBill.getString("bebankfunc");
                    String bankInterface = bankAcctOpenBill.getString("bankinterface");
                    if (EmptyUtil.isEmpty((String)beBankFunc)) {
                        this.addErrorMessage(data, amBizResource.getErrorBankFunc());
                    }
                    if (EmptyUtil.isEmpty((String)bankInterface)) {
                        this.addErrorMessage(data, amBizResource.getErrorBankInterface());
                    }
                }
                String name = bankAcctOpenBill.getString("acctname");
                logger.info("BankAcctOpenSaveValidator AccountBankProp.ACCTNAME:{} ", (Object)name);
                if (EmptyUtil.isEmpty((String)name)) {
                    this.addErrorMessage(data, amBizResource.getOpenacctNameless());
                }
                currentDate = DateUtils.getDataFormat((Date)currentDate, (boolean)true);
                if (null == openDate) {
                    this.addErrorMessage(data, amBizResource.getOpenacctOpendateless());
                } else if (currentDate.before(openDate)) {
                    this.addErrorMessage(data, amBizResource.getOpendateError());
                }
                Object manager = bankAcctOpenBill.get("manager");
                if (null == manager) {
                    this.addErrorMessage(data, amBizResource.getOpenacctManagerless());
                }
                if (null == (manageCurrency = bankAcctOpenBill.get("managecurrency"))) {
                    this.addErrorMessage(data, amBizResource.getOpenacctManagecurrless());
                }
                QFilter statusFilter = new QFilter("acctstatus", "!=", (Object)"closed");
                DynamicObject capitalOrg = bankAcctOpenBill.getDynamicObject("company");
                if (null != capitalOrg) {
                    boolean isdefaultreck;
                    Iterator orgFilter = new QFilter("company", "=", bankAcctOpenBill.getDynamicObject("company").getPkValue());
                    boolean isdefaultpayment = bankAcctOpenBill.getBoolean("isdefaultpay");
                    if (isdefaultpayment) {
                        QFilter exceptFilter;
                        QFilter openAcctStatusFilter;
                        DynamicObject[] openApplys;
                        QFilter payFilter = new QFilter("isdefaultpay", "=", (Object)"1");
                        DynamicObject payAcct = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{orgFilter, statusFilter, payFilter});
                        if (payAcct != null) {
                            this.addErrorMessage(data, String.format(amBizResource.getMultioutacctError(), payAcct.get("bankaccountnumber")));
                        }
                        if ((openApplys = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, openAcctStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{OpenAcctBillStatusEnum.A.getValue(), OpenAcctBillStatusEnum.B.getValue(), OpenAcctBillStatusEnum.H.getValue(), OpenAcctBillStatusEnum.R.getValue()}), payFilter, exceptFilter = new QFilter("id", "!=", bankAcctOpenBill.getPkValue())})).length > 0) {
                            String billNo = openApplys[0].getString("billno");
                            this.addErrorMessage(data, amBizResource.getExistDefaultPay(billNo));
                        }
                    }
                    if (isdefaultreck = bankAcctOpenBill.getBoolean("isdefaultrec")) {
                        QFilter exceptFilter;
                        QFilter openAcctStatusFilter;
                        DynamicObject[] openApplies;
                        QFilter treckFilter = new QFilter("isdefaultrec", "=", (Object)"1");
                        DynamicObject treckAcct = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{orgFilter, statusFilter, treckFilter});
                        if (treckAcct != null) {
                            this.addErrorMessage(data, String.format(amBizResource.getMultiinacctError(), treckAcct.get("bankaccountnumber")));
                        }
                        if ((openApplies = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, openAcctStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{OpenAcctBillStatusEnum.A.getValue(), OpenAcctBillStatusEnum.B.getValue(), OpenAcctBillStatusEnum.H.getValue(), OpenAcctBillStatusEnum.R.getValue()}), treckFilter, exceptFilter = new QFilter("id", "!=", bankAcctOpenBill.getPkValue())})).length > 0) {
                            String billNo = openApplies[0].getString("billno");
                            this.addErrorMessage(data, amBizResource.getExistDefaultRec(billNo));
                        }
                    }
                }
            }
            if ((bank = TmcDataServiceHelper.loadSingle((Object)bankAcctOpenBill.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo")) != null) {
                DynamicObject bankCate = bank.getDynamicObject("bank_cate");
                if (AmHelper.isNotEmpty((Object)bankCate)) {
                    Long id = (Long)bankCate.getPkValue();
                    boolean isVirtual = bankAcctOpenBill.getBoolean("isvirtual");
                    if (AmHelper.isNotEmpty((Object)id) && Boolean.TRUE.equals(VisibleVirtualAcctHelper.checkVirtualAcct((Long)id)) && !isVirtual) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f00\u6237\u884c\u4e3a\u865a\u62df\u94f6\u884c\uff0c\u662f\u5426\u4e3a\u865a\u62df\u8d26\u6237\u5fc5\u987b\u6253\u5f00\u3002", (String)"BankAccountSaveValidator_9", (String)"tmc-am-business", (Object[])new Object[0]));
                    }
                }
                if (bankAcctOpenBill.getBoolean("issetbankinterface")) {
                    boolean isNullOrNotChina;
                    DynamicObject beBank = bank.getDynamicObject("bebank");
                    DynamicObject country = bank.getDynamicObject("country");
                    String type = bankAcctOpenBill.getString("finorgtype");
                    boolean bl = isNullOrNotChina = country == null || country != null && !CountryHelper.isChina((DynamicObject)country);
                    if ("0".equalsIgnoreCase(type) && EmptyUtil.isEmpty((DynamicObject)beBank) && !isNullOrNotChina) {
                        this.addErrorMessage(data, amBizResource.getErrorBebankLose());
                    }
                }
            }
            String acctStyle = bankAcctOpenBill.getString("acctstyle");
            boolean isExistBasicAccount = BankAcctHelper.isExistBasicAccount((Object)company.getLong("id"), (Object)bankAcctOpenBill.getLong("id"));
            boolean isCheckOneBasic = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"ischeckonebasic");
            if (isCheckOneBasic && "basic".equals(acctStyle) && isExistBasicAccount) {
                this.addErrorMessage(data, resource.getExistBasicAccount());
            }
            DynamicObjectCollection currencys = bankAcctOpenBill.getDynamicObjectCollection("muiticurrency");
            DynamicObject defCurrency = bankAcctOpenBill.getDynamicObject("defaultcurrency");
            if (null == currencys) {
                this.addErrorMessage(data, resource.getCurrencyError());
            }
            if (null == defCurrency) {
                this.addErrorMessage(data, resource.getDefCurrError());
            }
            HashSet<Long> currencyIDs = new HashSet<Long>();
            for (DynamicObject prop : currencys) {
                currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
            }
            if (defCurrency != null && !currencyIDs.contains(defCurrency.getLong("id"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5e01\u79cd\u201d\u4e0d\u5728\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"BankAccountSaveValidator_4", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (!(isCheck = this.checkProxyAccount(bankAcctOpenBill))) {
                this.addErrorMessage(data, resource.getProxyAccountValidator());
                continue;
            }
            DynamicObject proxyCurrency = bankAcctOpenBill.getDynamicObject("proxycurrency");
            if (proxyCurrency == null || currencyIDs.contains(proxyCurrency.getLong("id"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u4ee3\u7406\u67e5\u8be2\u5e01\u79cd\u201d\u4e0d\u5728\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"BankAccountSaveValidator_8", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }

    private boolean checkProxyAccount(DynamicObject bankAccount) {
        String beBankFunc;
        boolean isSetBankInterface;
        if (bankAccount != null && (isSetBankInterface = bankAccount.getBoolean("issetbankinterface")) && (beBankFunc = bankAccount.getString("bebankfunc")) != null && beBankFunc.contains("proxyinquiry")) {
            DynamicObject proxyCurrency = bankAccount.getDynamicObject("proxycurrency");
            String proxyInquiryAccount = bankAccount.getString("proxyinquiryaccount");
            if (EmptyUtil.isEmpty((DynamicObject)proxyCurrency) && EmptyUtil.isNoEmpty((String)proxyInquiryAccount) || EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency) && EmptyUtil.isEmpty((String)proxyInquiryAccount)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private Pair<Boolean, String> verifyFinOrg(DynamicObject bank) {
        DynamicObject country;
        Pair pair = Pair.of((Object)Boolean.TRUE, (Object)"");
        if (bank != null && ((country = bank.getDynamicObject("country")) == null || country != null && CountryHelper.isChina((DynamicObject)country))) {
            DynamicObject province = bank.getDynamicObject("province");
            DynamicObject city = bank.getDynamicObject("city");
            if (null == province || null == city) {
                String msg = String.format(new AmBizResource().getFinOrgError(), bank.getString("name"));
                pair = Pair.of((Object)Boolean.FALSE, (Object)msg);
            }
        }
        return pair;
    }
}

