/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.openacct;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class OpenAcctSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("billstatus");
        selector.add("acctstyle");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject openDetail = data.getDataEntity();
            String acctStyle = openDetail.getString("acctstyle");
            DynamicObject company = openDetail.getDynamicObject("company");
            if (!"basic".equalsIgnoreCase(acctStyle)) continue;
            long companyId = company.getLong("id");
            ArrayList<String> billStatusList = new ArrayList<String>();
            billStatusList.add("E");
            billStatusList.add("C");
            QFilter qFilterOpen = new QFilter("billstatus", "not in", (Object)billStatusList.toArray());
            qFilterOpen.and("company", "=", (Object)companyId);
            qFilterOpen.and("acctstyle", "=", (Object)"basic");
            qFilterOpen.and("id", "!=", openDetail.getPkValue());
            DynamicObjectCollection resultDt = QueryServiceHelper.query((String)"am_accopenbill", (String)"id", (QFilter[])qFilterOpen.toArray(), (String)null);
            if (resultDt.size() <= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7533\u8bf7\u5931\u8d25\uff0c\u8be5\u7533\u8bf7\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u7533\u8bf7\u3010\u57fa\u672c\u5b58\u6b3e\u8d26\u6237\u3011\u7684\u5f00\u6237\u7533\u8bf7\u3002", (String)"BankAccOpenBillValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

