/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.restrictedfunds;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class RestrictedFundsManagerSaveValidator
extends AbstractValidator {
    public void validate() {
        boolean exists = Boolean.FALSE;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyObj = dataEntity.getDataEntity();
            String srcBillNo = dyObj.getString("srcbillno");
            String businessType = dyObj.getString("businesstype");
            QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)srcBillNo), new QFilter("billstatus", "<>", (Object)"C"), new QFilter("businesstype", "=", (Object)"1")};
            exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0a\u6e38\u8d44\u91d1\u53d7\u9650\u5355\u636e\u6b63\u5728\u88ab\u7f16\u8f91\u3002", (String)"RestrictedFundsManager_5", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            filters = new QFilter[]{new QFilter("srcbillno", "=", (Object)srcBillNo), new QFilter("billstatus", "<>", (Object)"C"), new QFilter("businesstype", "=", (Object)"2"), new QFilter("id", "not in", dyObj.getPkValue())};
            exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u4e0b\u6e38\u89e3\u9664\u53d7\u9650\u5355\u636e\u6b63\u5728\u88ab\u7f16\u8f91\u3002", (String)"RestrictedFundsManager_2", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (!businessType.equalsIgnoreCase("1")) continue;
            DynamicObject bankAcctDo = dyObj.getDynamicObject("bankacct");
            Date restrictedDate = dyObj.getDate("restricteddate");
            restrictedDate = DateUtils.getDataFormat((Date)restrictedDate, (boolean)false);
            Long bankAcctId = Long.parseLong(bankAcctDo.getPkValue().toString());
            QFilter dateFilter = new QFilter("actualliftdate", "is null", null);
            dateFilter.or("actualliftdate", ">", (Object)restrictedDate);
            filters = new QFilter[]{new QFilter("businesstype", "=", (Object)"1"), new QFilter("isallrestricted", "=", (Object)"1"), new QFilter("bankacct", "=", (Object)bankAcctId), dateFilter, new QFilter("id", "not in", dyObj.getPkValue())};
            exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u94f6\u884c\u8d26\u6237\u5df2\u7ecf\u5b58\u5728\u3010\u662f\u5426\u5168\u90e8\u53d7\u9650 = \u662f\u3011\u7684\u589e\u52a0\u53d7\u9650\u5355\u636e\u3002", (String)"RestrictedFundsManager_6", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            boolean thisIsAllRestricted = dyObj.getBoolean("isallrestricted");
            if (!thisIsAllRestricted || !(exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])(filters = new QFilter[]{dateFilter, new QFilter("businesstype", "=", (Object)"1"), new QFilter("bankacct", "=", (Object)bankAcctId), new QFilter("id", "not in", dyObj.getPkValue())})))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u94f6\u884c\u8d26\u6237\u5df2\u7ecf\u5b58\u5728\u589e\u52a0\u53d7\u9650\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u5168\u90e8\u53d7\u9650\u5355\u636e\u3002", (String)"RestrictedFundsManager_7", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

