/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.restrictedfunds;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class RestrictedFundsManagerUnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection resultDt;
            QFilter qFilter;
            DynamicObject dyObj = dataEntity.getDataEntity();
            String billNo = dyObj.getString("billno");
            String srcBillNo = dyObj.getString("srcbillno");
            String businessType = dyObj.getString("businesstype");
            if (!billNo.isEmpty() && businessType.equalsIgnoreCase("1")) {
                qFilter = new QFilter("srcbillno", "=", (Object)billNo);
                qFilter.and("businesstype", "=", (Object)"2");
                resultDt = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id", (QFilter[])qFilter.toArray(), null);
                if (resultDt.size() <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u53d7\u9650\u8d44\u91d1\u5df2\u7ecf\u53d1\u751f\u89e3\u9664\u53d7\u9650\u4e1a\u52a1\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"RestrictedFundsManager_0", (String)"tmc-am-business", (Object[])new Object[0]));
                continue;
            }
            if (!businessType.equalsIgnoreCase("2")) continue;
            qFilter = new QFilter("srcbillno", "=", (Object)srcBillNo);
            qFilter.and("businesstype", "=", (Object)"2");
            qFilter.and("auditdate", ">", (Object)dyObj.getDate("auditdate"));
            resultDt = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id", (QFilter[])qFilter.toArray(), null);
            if (resultDt.size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6700\u540e\u89e3\u9664\u53d7\u9650\u7684\u5355\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"RestrictedFundsManager_1", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            DynamicObject bankAcctDo = dyObj.getDynamicObject("bankacct");
            Long bankAcctId = Long.parseLong(bankAcctDo.getPkValue().toString());
            Date restrictedDate = dyObj.getDate("restricteddate");
            restrictedDate = DateUtils.getDataFormat((Date)restrictedDate, (boolean)false);
            QFilter dateFilter = new QFilter("actualliftdate", "is null", null);
            dateFilter.or("actualliftdate", ">", (Object)restrictedDate);
            QFilter[] filters = new QFilter[]{new QFilter("businesstype", "=", (Object)"1"), new QFilter("isallrestricted", "=", (Object)"1"), new QFilter("bankacct", "=", (Object)bankAcctId), dateFilter, new QFilter("billno", "not in", (Object)srcBillNo)};
            boolean exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8d26\u6237\u5df2\u7ecf\u5b58\u5728\u53d7\u9650\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"RestrictedFundsManager_8", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            boolean thisIsAllRestricted = dyObj.getBoolean("isallrestricted");
            if (!thisIsAllRestricted || !(exists = QueryServiceHelper.exists((String)"am_restrictedfundsmanager", (QFilter[])(filters = new QFilter[]{dateFilter, new QFilter("businesstype", "=", (Object)"1"), new QFilter("bankacct", "=", (Object)bankAcctId), new QFilter("billno", "not in", (Object)srcBillNo)})))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8d26\u6237\u5df2\u7ecf\u5b58\u5728\u53d7\u9650\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"RestrictedFundsManager_8", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

