/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.strategy;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.common.enums.LimitWayEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctStrategySaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        boolean isPayLimit;
        ExtendedDataEntity dataEntity = extendedDataEntities[0];
        DynamicObject entities = dataEntity.getDataEntity();
        String name = entities.getString("name");
        boolean isNnerSta = entities.getBoolean("isinnerstrategy");
        Long pkValue = entities.getLong("id");
        Object[] datas = TmcDataServiceHelper.load((String)"am_strategy", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name), new QFilter("isinnerstrategy", "=", (Object)isNnerSta)});
        if (EmptyUtil.isEmpty((Long)pkValue) && EmptyUtil.isNoEmpty((Object[])datas) || EmptyUtil.isNoEmpty((Long)pkValue) && datas.length > 0 && datas[0].getLong("id") != pkValue.longValue()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\"\u540d\u79f0\"\uff0c\u5df2\u5b58\u5728\u3002", (String)"BankAcctStrategySaveValidator_0", (String)"tmc-am-business", (Object[])new Object[]{entities.getString("number")}));
        }
        if (isPayLimit = ((Boolean)entities.get("ispaylimit")).booleanValue()) {
            DynamicObjectCollection limitWayEntry = entities.getDynamicObjectCollection("limitwayentry");
            if (limitWayEntry.size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u542f\u8d26\u6237\u652f\u4ed8\u9650\u989d\u540e\u9700\u7ef4\u62a4\u8be6\u7ec6\u7684\u9650\u5b9a\u65b9\u5f0f\u3002", (String)"BankAcctStrategySaveValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
            } else {
                for (DynamicObject entry : limitWayEntry) {
                    String limitWay = entry.getString("limitway");
                    BigDecimal limitAmount = entry.getBigDecimal("limitamount");
                    if (LimitWayEnum.SINGLE.getValue().equals(limitWay)) {
                        if (BigDecimal.ZERO.compareTo(limitAmount) != 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9650\u5b9a\u65b9\u5f0f\u4e3a\u5355\u7b14\u9650\u989d\u65f6\uff0c\u9650\u5b9a\u91d1\u989d\u5fc5\u5f55\u3002", (String)"BankAcctStrategySaveValidator_6", (String)"tmc-am-business", (Object[])new Object[0]));
                        continue;
                    }
                    int limitCount = entry.getInt("limitcount");
                    if (BigDecimal.ZERO.compareTo(limitAmount) != 0 || limitCount != 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9650\u5b9a\u65b9\u5f0f\u975e\u5355\u7b14\u9650\u989d\u65f6\uff0c\u9650\u5b9a\u91d1\u989d\u6216\u9650\u5b9a\u7b14\u6570\u81f3\u5c11\u7ef4\u62a4\u4e00\u9879\u3002", (String)"BankAcctStrategySaveValidator_7", (String)"tmc-am-business", (Object[])new Object[0]));
                }
            }
        }
        if (((Boolean)entities.get("islimitstrgy")).booleanValue() && !((Boolean)entities.get("ispaylimit")).booleanValue() && !((Boolean)entities.get("isballimit")).booleanValue()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u672a\u8bbe\u7f6e\u9650\u989d\u7b56\u7565\u3002", (String)"BankAcctStrategySaveValidator_2", (String)"tmc-am-business", (Object[])new Object[0]));
        }
        if (((Boolean)entities.get("isballimit")).booleanValue() && BigDecimal.ZERO.compareTo((BigDecimal)entities.get("miniacctlimit")) == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\"\u6700\u4f4e\u7559\u5b58\u91d1\u989d\"\u5fc5\u5f55\u3002", (String)"BankAcctStrategySaveValidator_3", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

