/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.innerstrategyset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcOpBizRuleSetServiceHelper;

public class InnerStrategySetRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizbill");
        selector.add("checkop");
        selector.add("enable");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            if (!BaseEnableEnum.ENABLE.getValue().equals(info.getString("enable"))) continue;
            String checkops = info.getString("checkop");
            String entityNumber = info.getDynamicObject("bizbill").getString("number");
            try (TXHandle tx = TX.requiresNew();){
                try {
                    Set opSet = Arrays.stream(checkops.replaceFirst(",", "").split(",")).collect(Collectors.toSet());
                    TmcOpBizRuleSetServiceHelper.addOpBizRuleSet((String)entityNumber, (String)"innerstrategy", new ArrayList(opSet));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

