/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.innerstrategyset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerStrategySetUnRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizbill");
        selector.add("checkop");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map<String, List<DynamicObject>> collect = Arrays.stream(dataEntities).collect(Collectors.groupingBy(s -> s.getDynamicObject("bizbill").getString("number")));
        for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
            String entityNumber = entry.getKey();
            List ids = entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter filter = new QFilter("bizbill.number", "=", (Object)entityNumber);
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "not in", ids);
            DynamicObjectCollection strategySets = QueryServiceHelper.query((String)"ifm_strategysetting", (String)"id,checkop", (QFilter[])new QFilter[]{filter});
            HashSet otherOpSet = new HashSet(16);
            for (DynamicObject strategySet : strategySets) {
                otherOpSet.addAll(Arrays.stream(strategySet.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"innerstrategy");
                    if (!EmptyUtil.isNoEmpty(otherOpSet)) continue;
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)"innerstrategy", new ArrayList(otherOpSet));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }
}

