/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.service.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class InnerStrategySetUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InnerStrategySetUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        logger.info("start upgrade strategysetting");
        try {
            this.metaDataRemoveUpgrade();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.info("end upgrade strategysetting");
        return result;
    }

    private void metaDataRemoveUpgrade() {
        String querySql = "select fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fdisablerid,fenablerid,fenabledate,fdisabledate,fbizbillid,fcheckfieldname,fcheckfieldval,fcheckop,finneracctpropval,finneracctpropname,fcheckopname from t_ifm_strategysetting";
        DataSet strategyData = DB.queryDataSet((String)"InnerStrategySetUpgradeService", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (strategyData.isEmpty()) {
            return;
        }
        String insertSql = "insert into t_am_inacctstrasetting(fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fdisablerid,fenablerid,fenabledate,fdisabledate,fbizbillid,fcheckfieldname,fcheckfieldval,fcheckop,finneracctpropval,finneracctpropname,fcheckopname) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        ArrayList<String> upgradeIds = new ArrayList<String>();
        ArrayList<Object[]> upgradeDatas = new ArrayList<Object[]>();
        for (Row ifmStrategySet : strategyData.copy()) {
            Object[] params = new Object[]{ifmStrategySet.getLong("fid"), ifmStrategySet.getString("fnumber"), ifmStrategySet.getString("fname"), ifmStrategySet.getString("fstatus"), ifmStrategySet.getLong("fcreatorid"), ifmStrategySet.getLong("fmodifierid"), ifmStrategySet.getString("fenable"), ifmStrategySet.getDate("fcreatetime"), ifmStrategySet.getDate("fmodifytime"), ifmStrategySet.getLong("fmasterid"), ifmStrategySet.getLong("fdisablerid"), ifmStrategySet.getLong("fenablerid"), ifmStrategySet.getDate("fenabledate"), ifmStrategySet.getDate("fdisabledate"), ifmStrategySet.getString("fbizbillid"), ifmStrategySet.getString("fcheckfieldname"), ifmStrategySet.getString("fcheckfieldval"), ifmStrategySet.getString("fcheckop"), ifmStrategySet.getString("finneracctpropval"), ifmStrategySet.getString("finneracctpropname"), ifmStrategySet.getString("fcheckopname")};
            upgradeDatas.add(params);
            if (upgradeDatas.size() % 5000 == 0) {
                DB.executeBatch((DBRoute)DBRouteConst.BASE, (String)insertSql, upgradeDatas);
                upgradeDatas.clear();
            }
            upgradeIds.add(ifmStrategySet.getString("fid"));
        }
        this.deleteData(upgradeIds);
        DB.executeBatch((DBRoute)DBRouteConst.BASE, (String)insertSql, upgradeDatas);
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
    }

    private void deleteData(List<String> upgradeIds) {
        if (upgradeIds.size() == 0) {
            return;
        }
        ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
        String sql = "delete from t_am_inacctstrasetting where fid = ?";
        for (String bankCheckDto : upgradeIds) {
            batchParam.add(new Object[]{Long.valueOf(bankCheckDto)});
        }
        DB.executeBatch((DBRoute)DBRouteConst.BASE, (String)sql, batchParam);
    }
}

