/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.service.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import org.apache.commons.lang3.tuple.Pair;

public class StrategyOpUpService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(StrategyOpUpService.class);
    private static final Map<Long, Pair<String, String>> limitAllMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> keepAllMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> limitSubmitMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> keepSubmitMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> limitPayMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> keepPayMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> overSubmitMap = new HashMap<Long, Pair<String, String>>(16);
    private static final Map<Long, Pair<String, String>> overPayMap = new HashMap<Long, Pair<String, String>>(16);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        logger.info("start StrategyOpUpService");
        try {
            String amQuerySql;
            DataSet amStrategyData;
            String ifmQuerySql = "select fbillstrategyid from t_am_strategy_e where fbillstrategyid != 0 and fid in (select fid from t_am_strategy where fisinnerstrategy = '1')";
            DataSet ifmStrategyData = DB.queryDataSet((String)"ifmQuerySql", (DBRoute)DBRouteConst.BASE, (String)ifmQuerySql);
            if (!ifmStrategyData.copy().isEmpty()) {
                this.executeIfmUpOpData(ifmStrategyData.copy());
            }
            if (!(amStrategyData = DB.queryDataSet((String)"amQuerySql", (DBRoute)DBRouteConst.BASE, (String)(amQuerySql = "select fid,fissubmit,fispay,fispaylimit,fisballimit,fisoverstrgy,fislimitstrgy from t_am_strategy where fisinnerstrategy = '0'"))).copy().isEmpty()) {
                this.executeUpEntryData(amStrategyData.copy());
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            logger.info(e.getMessage());
        }
        logger.info("end StrategyOpUpService");
        return result;
    }

    public void executeIfmUpOpData(DataSet strategyData) {
        HashSet<Long> strategyIds = new HashSet<Long>(10);
        for (Row set : strategyData) {
            strategyIds.add(set.getLong("fbillstrategyid"));
        }
        String querySetting = "select fcheckop,fcheckopname,fid from t_am_inacctstrasetting where fid in (" + TmcBusinessBaseHelper.idListToString(new ArrayList(strategyIds)) + ") ";
        DataSet settingData = DB.queryDataSet((String)"querySetting", (DBRoute)DBRouteConst.BASE, (String)querySetting);
        String updateSql = "update t_am_strategy_e set fcheckopprop = ?, fcheckopname = ? where fbillstrategyid = ? ";
        for (Row data : settingData) {
            Object[] params = new Object[]{data.getString("fcheckop"), data.getString("fcheckopname"), data.getLong("fid")};
            DB.execute((DBRoute)DBRouteConst.BASE, (String)updateSql, (Object[])params);
        }
    }

    private void executeUpEntryData(DataSet strategyData) {
        ArrayList<Object[]> overList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> limitList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> keepList = new ArrayList<Object[]>(10);
        for (Row set : strategyData) {
            String isOverStrgy = set.getString("fisoverstrgy");
            String isLimitStrgy = set.getString("fislimitstrgy");
            String isSubmit = set.getString("fissubmit");
            String isPay = set.getString("fispay");
            String isPayLimit = set.getString("fispaylimit");
            String isBalLimit = set.getString("fisballimit");
            Long fid = set.getLong("fid");
            if ("1".equals(isSubmit) && "1".equals(isPay)) {
                this.genInsertSqlInfo(overList, limitList, keepList, fid, isOverStrgy, isLimitStrgy, isPayLimit, isBalLimit, limitAllMap, keepAllMap, isSubmit, isPay);
                continue;
            }
            if ("1".equals(isSubmit)) {
                this.genInsertSqlInfo(overList, limitList, keepList, fid, isOverStrgy, isLimitStrgy, isPayLimit, isBalLimit, limitSubmitMap, keepSubmitMap, isSubmit, isPay);
            }
            if (!"1".equals(isPay)) continue;
            this.genInsertSqlInfo(overList, limitList, keepList, fid, isOverStrgy, isLimitStrgy, isPayLimit, isBalLimit, limitPayMap, keepPayMap, isSubmit, isPay);
        }
        if (overList.size() > 0) {
            String insertOverSql = "insert into t_am_strategy_e(fid, fentryid, fseq, fbillstrategyid, fcheckopname, fcheckopprop) values (?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRouteConst.SYS, (String)insertOverSql, overList);
        }
        if (limitList.size() > 0) {
            String insertLimitSql = "insert into t_am_strategy_limitentry(fid, fentryid, fseq, fbillstrategyid, fcheckopname, fcheckopprop) values (?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRouteConst.SYS, (String)insertLimitSql, limitList);
        }
        if (keepList.size() > 0) {
            String insertKeepSql = "insert into t_am_strategy_keepentry(fid, fentryid, fseq, fbillstrategyid, fcheckopname, fcheckopprop) values (?, ?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRouteConst.SYS, (String)insertKeepSql, keepList);
        }
    }

    private void genInsertSqlInfo(List<Object[]> overList, List<Object[]> limitList, List<Object[]> keepList, Long fid, String isOverStrgy, String isLimitStrgy, String isPayLimit, String isBalLimit, Map<Long, Pair<String, String>> limitMap, Map<Long, Pair<String, String>> keepMap, String isSubmit, String isPay) {
        Pair<String, String> pair;
        String existSql;
        DataSet existData;
        if ("1".equals(isOverStrgy)) {
            ArrayList<Long> strategIdsList = new ArrayList<Long>(16);
            strategIdsList.addAll(new ArrayList<Long>(overSubmitMap.keySet()));
            strategIdsList.addAll(new ArrayList<Long>(overPayMap.keySet()));
            String existSql2 = "select fid from t_am_strategy_e where fid = " + fid + " and fbillstrategyid in (" + TmcBusinessBaseHelper.idListToString(strategIdsList) + ") ";
            DataSet existData2 = DB.queryDataSet((String)"existSql", (DBRoute)DBRouteConst.BASE, (String)existSql2);
            if (existData2.isEmpty()) {
                Object[] overObject;
                Pair<String, String> pair2;
                long overEntryid;
                int seq = 0;
                if ("1".equals(isSubmit)) {
                    for (Map.Entry<Long, Pair<String, String>> entry : overSubmitMap.entrySet()) {
                        overEntryid = DB.genLongId((String)"t_am_strategy_e");
                        pair2 = entry.getValue();
                        overObject = new Object[]{fid, overEntryid, ++seq, entry.getKey(), pair2.getLeft(), pair2.getRight()};
                        overList.add(overObject);
                    }
                }
                if ("1".equals(isPay)) {
                    for (Map.Entry<Long, Pair<String, String>> entry : overPayMap.entrySet()) {
                        overEntryid = DB.genLongId((String)"t_am_strategy_e");
                        pair2 = entry.getValue();
                        overObject = new Object[]{fid, overEntryid, ++seq, entry.getKey(), pair2.getLeft(), pair2.getRight()};
                        overList.add(overObject);
                    }
                }
            }
        }
        if ("1".equals(isLimitStrgy) && "1".equals(isPayLimit) && (existData = DB.queryDataSet((String)"existSql", (DBRoute)DBRouteConst.BASE, (String)(existSql = "select fid from t_am_strategy_limitentry where fid = " + fid + " and fbillstrategyid in (" + TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(limitMap.keySet())) + ") "))).isEmpty()) {
            int seq = 0;
            for (Map.Entry<Long, Pair<String, String>> entry : limitMap.entrySet()) {
                long limitEntryid = DB.genLongId((String)"t_am_strategy_limitentry");
                pair = entry.getValue();
                Object[] limitObject = new Object[]{fid, limitEntryid, ++seq, entry.getKey(), pair.getLeft(), pair.getRight()};
                limitList.add(limitObject);
            }
        }
        if ("1".equals(isLimitStrgy) && "1".equals(isBalLimit) && (existData = DB.queryDataSet((String)"existSql", (DBRoute)DBRouteConst.BASE, (String)(existSql = "select fid from t_am_strategy_keepentry where fid = " + fid + " and fbillstrategyid in (" + TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(keepMap.keySet())) + ") "))).isEmpty()) {
            int seq = 0;
            for (Map.Entry<Long, Pair<String, String>> entry : keepMap.entrySet()) {
                long keepEntryid = DB.genLongId((String)"t_am_strategy_keepentry");
                pair = entry.getValue();
                Object[] keepObject = new Object[]{fid, keepEntryid, ++seq, entry.getKey(), pair.getLeft(), pair.getRight()};
                keepList.add(keepObject);
            }
        }
    }

    static {
        Pair limitAllCas = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_0", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,pay,commitbe,");
        limitAllMap.put(1950685696847097856L, (Pair<String, String>)limitAllCas);
        limitAllMap.put(1950717992719478784L, (Pair<String, String>)limitAllCas);
        limitAllMap.put(1950721199248109568L, (Pair<String, String>)limitAllCas);
        limitAllMap.put(1964465494220430336L, (Pair<String, String>)limitAllCas);
        limitAllMap.put(1964467687313067008L, (Pair<String, String>)limitAllCas);
        limitAllMap.put(1964469847513717760L, (Pair<String, String>)limitAllCas);
        Pair limitAllIfm = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u4ed8\u6b3e-\u94f6\u4f01\u4e92\u8054\uff1b\u786e\u8ba4\u5df2\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_5", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,autocommitbei,barpaybei,barpayconfirm,commitbei,");
        Pair limitAllIfm2 = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u786e\u8ba4\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_6", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,autocommitbe,confirmpay,pay,");
        limitAllMap.put(1965352831477504000L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1965353393682012160L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1965354332786684928L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1965343790915278848L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1965344564839864320L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1965345728683734016L, (Pair<String, String>)limitAllIfm);
        limitAllMap.put(1967547117736499200L, (Pair<String, String>)limitAllIfm2);
        limitAllMap.put(1967552375313214464L, (Pair<String, String>)limitAllIfm2);
        limitAllMap.put(1967552746031093760L, (Pair<String, String>)limitAllIfm2);
        Pair keepAllCas = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_0", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,pay,commitbe,");
        keepAllMap.put(1950673774286721024L, (Pair<String, String>)keepAllCas);
        keepAllMap.put(1964464410571787264L, (Pair<String, String>)keepAllCas);
        Pair keepAllIfm = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u4ed8\u6b3e-\u94f6\u4f01\u4e92\u8054\uff1b\u786e\u8ba4\u5df2\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_5", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,autocommitbei,barpaybei,barpayconfirm,commitbei,");
        Pair keepAllIfm2 = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u786e\u8ba4\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_6", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,autocommitbe,confirmpay,pay,");
        keepAllMap.put(1965347235361609728L, (Pair<String, String>)keepAllIfm);
        keepAllMap.put(1965342687913990144L, (Pair<String, String>)keepAllIfm);
        keepAllMap.put(1967553639199616000L, (Pair<String, String>)keepAllIfm2);
        Pair submit = Pair.of((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\uff1b", (String)"StrategyOpUpService_1", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",submit,");
        limitSubmitMap.put(1950685696847097856L, (Pair<String, String>)submit);
        limitSubmitMap.put(1950717992719478784L, (Pair<String, String>)submit);
        limitSubmitMap.put(1950721199248109568L, (Pair<String, String>)submit);
        limitSubmitMap.put(1964465494220430336L, (Pair<String, String>)submit);
        limitSubmitMap.put(1964467687313067008L, (Pair<String, String>)submit);
        limitSubmitMap.put(1964469847513717760L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965352831477504000L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965353393682012160L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965354332786684928L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965343790915278848L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965344564839864320L, (Pair<String, String>)submit);
        limitSubmitMap.put(1965345728683734016L, (Pair<String, String>)submit);
        limitSubmitMap.put(1967547117736499200L, (Pair<String, String>)submit);
        limitSubmitMap.put(1967552375313214464L, (Pair<String, String>)submit);
        limitSubmitMap.put(1967552746031093760L, (Pair<String, String>)submit);
        keepSubmitMap.put(1950673774286721024L, (Pair<String, String>)submit);
        keepSubmitMap.put(1964464410571787264L, (Pair<String, String>)submit);
        keepSubmitMap.put(1965347235361609728L, (Pair<String, String>)submit);
        keepSubmitMap.put(1965342687913990144L, (Pair<String, String>)submit);
        keepSubmitMap.put(1967553639199616000L, (Pair<String, String>)submit);
        Pair payCas = Pair.of((Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_2", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",pay,commitbe,");
        limitPayMap.put(1950685696847097856L, (Pair<String, String>)payCas);
        limitPayMap.put(1950717992719478784L, (Pair<String, String>)payCas);
        limitPayMap.put(1950721199248109568L, (Pair<String, String>)payCas);
        limitPayMap.put(1964465494220430336L, (Pair<String, String>)payCas);
        limitPayMap.put(1964467687313067008L, (Pair<String, String>)payCas);
        limitPayMap.put(1964469847513717760L, (Pair<String, String>)payCas);
        Pair payIfm = Pair.of((Object)ResManager.loadKDString((String)"\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u4ed8\u6b3e-\u94f6\u4f01\u4e92\u8054\uff1b\u786e\u8ba4\u5df2\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_3", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",autocommitbei,barpaybei,barpayconfirm,commitbei,");
        Pair payIfm2 = Pair.of((Object)ResManager.loadKDString((String)"\u81ea\u52a8\u63d0\u4ea4\u94f6\u4f01\uff1b\u786e\u8ba4\u4ed8\u6b3e\uff1b\u63d0\u4ea4\u94f6\u4f01\uff1b", (String)"StrategyOpUpService_4", (String)"tmc-am-business", (Object[])new Object[0]), (Object)",autocommitbe,confirmpay,pay,");
        limitPayMap.put(1965352831477504000L, (Pair<String, String>)payIfm);
        limitPayMap.put(1965353393682012160L, (Pair<String, String>)payIfm);
        limitPayMap.put(1965354332786684928L, (Pair<String, String>)payIfm);
        limitPayMap.put(1965343790915278848L, (Pair<String, String>)payIfm);
        limitPayMap.put(1965344564839864320L, (Pair<String, String>)payIfm);
        limitPayMap.put(1965345728683734016L, (Pair<String, String>)payIfm);
        limitPayMap.put(1967547117736499200L, (Pair<String, String>)payIfm2);
        limitPayMap.put(1967552375313214464L, (Pair<String, String>)payIfm2);
        limitPayMap.put(1967552746031093760L, (Pair<String, String>)payIfm2);
        keepPayMap.put(1950673774286721024L, (Pair<String, String>)payCas);
        keepPayMap.put(1964464410571787264L, (Pair<String, String>)payCas);
        keepPayMap.put(1965347235361609728L, (Pair<String, String>)payIfm);
        keepPayMap.put(1965342687913990144L, (Pair<String, String>)payIfm);
        keepPayMap.put(1967553639199616000L, (Pair<String, String>)payIfm2);
        overSubmitMap.put(1940001588747936768L, (Pair<String, String>)submit);
        overSubmitMap.put(1964459998105132032L, (Pair<String, String>)submit);
        overSubmitMap.put(1962547934256434176L, (Pair<String, String>)submit);
        overSubmitMap.put(1960112852912136192L, (Pair<String, String>)submit);
        overSubmitMap.put(1959543062451480576L, (Pair<String, String>)submit);
        overSubmitMap.put(1960109401754919936L, (Pair<String, String>)submit);
        overSubmitMap.put(1960110770943547392L, (Pair<String, String>)submit);
        overPayMap.put(1947180470051954688L, (Pair<String, String>)payCas);
        overPayMap.put(1962489482712218624L, (Pair<String, String>)payIfm);
        overPayMap.put(1962488645109709824L, (Pair<String, String>)payIfm);
        overPayMap.put(1962548508725087232L, (Pair<String, String>)payIfm2);
        overPayMap.put(1964463652912585728L, (Pair<String, String>)payCas);
    }
}

