/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.innerstrategyset;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerStrategySetSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizbill");
        selector.add("inneracctpropname");
        selector.add("inneracctpropval");
        selector.add("checkfieldval");
        selector.add("checkop");
        selector.add("modeltype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String[] newCheckOps;
            DynamicProperty resProperty;
            DynamicObject info = extendedDataEntity.getDataEntity();
            String inneracctprop = info.getString("inneracctpropval");
            String checkFieldVal = info.getString("checkfieldval");
            String entryPropStr = "";
            String entryFiledPropStr = "";
            if (inneracctprop.contains(".")) {
                entryPropStr = inneracctprop.split("\\.")[0];
                entryFiledPropStr = inneracctprop.split("\\.")[1];
                String entryFiledAmPropStr = "";
                if (checkFieldVal.contains(".")) {
                    entryFiledAmPropStr = checkFieldVal.split("\\.")[0];
                }
                if (!entryPropStr.equals(entryFiledAmPropStr)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u914d\u7f6e\u5206\u5f55\u5b57\u6bb5\u65f6,\u6821\u9a8c\u8d26\u6237\u548c\u6821\u9a8c\u91d1\u989d\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5206\u5f55\u91cc\u7684\u5b57\u6bb5\u3002", (String)"InnerStrategySetSaveValidator_3", (String)"tmc-am-business", (Object[])new Object[0]), info.getString("inneracctpropname")));
                    continue;
                }
            }
            boolean isacctprop = false;
            List<String> acctEntitys = Arrays.asList("ifm_inneracct", "bd_accountbanks", "am_accountbank");
            DynamicObject bizbill = info.getDynamicObject("bizbill");
            String entityNumber = bizbill.getString("number");
            MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (EmptyUtil.isNoEmpty((String)entryPropStr)) {
                EntryProp entryProp = (EntryProp)sourceMainType.getProperty(entryPropStr);
                if (EmptyUtil.isEmpty((Object)entryProp)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u8be5\u5b57\u6bb5\u4e3a\u5b50\u5206\u5f55\u5c5e\u6027,\u4e0d\u652f\u6301\u8be5\u573a\u666f\u3002", (String)"InnerStrategySetSaveValidator_4", (String)"tmc-am-business", (Object[])new Object[0]), info.getString("inneracctpropname")));
                    continue;
                }
                DynamicObjectType entryFiledType = entryProp.getDynamicCollectionItemPropertyType();
                resProperty = entryFiledType.getProperty(entryFiledPropStr);
            } else {
                resProperty = sourceMainType.getProperty(inneracctprop);
            }
            if (resProperty instanceof BasedataProp) {
                isacctprop = true;
            }
            if (!isacctprop || !acctEntitys.contains(((BasedataProp)resProperty).getBaseEntityId())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u8d26\u6237\u5b57\u6bb5:%s \u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u975e\u94f6\u884c\u8d26\u6237\u6216\u5185\u90e8\u8d26\u6237,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InnerStrategySetSaveValidator_5", (String)"tmc-am-business", (Object[])new Object[0]), info.getString("inneracctpropname")));
                continue;
            }
            QFilter filter = new QFilter("bizbill.number", "=", (Object)entityNumber);
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "!=", info.getPkValue());
            DynamicObjectCollection strategySets = QueryServiceHelper.query((String)"ifm_strategysetting", (String)"id,checkop,checkfieldval,inneracctpropval,modeltype.id", (QFilter[])new QFilter[]{filter});
            HashSet<String> existStrategySets = new HashSet<String>(16);
            HashSet checkOpStrs = new HashSet(16);
            for (DynamicObject strategySet : strategySets) {
                checkOpStrs.addAll(Arrays.stream(strategySet.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
            for (DynamicObject strategySet : strategySets) {
                for (String checkOpStr : checkOpStrs) {
                    existStrategySets.add(this.genStrObj(strategySet, entityNumber, checkOpStr));
                }
            }
            String checkOp = info.getString("checkop");
            for (String newCheckOp : newCheckOps = checkOp.replaceFirst(",", "").split(",")) {
                if (!existStrategySets.contains(this.genStrObj(info, entityNumber, newCheckOp))) continue;
            }
        }
    }

    private String genStrObj(DynamicObject info, String entityNumber, String existStrategySet) {
        StringBuilder sb = new StringBuilder();
        sb.append(entityNumber).append('_').append(info.get("inneracctpropval")).append('_').append(info.get("checkfieldval")).append('_').append(info.get("modeltype.id")).append('_').append(existStrategySet);
        return sb.toString();
    }
}

