/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.accountmaintenance;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.OrgHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class AccountMaintenanceBillEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public static final String COMPANY = "company";
    public static final String ACCOUNT = "account";
    public static final String BILLBANK = "billbank";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("openorg", null);
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue(ACCOUNT);
        if (account != null) {
            model.setValue("bankname", (Object)account.getString("acctname"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.afterEdit(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.companyRegisterListener();
        BasedataEdit account = (BasedataEdit)this.getView().getControl(ACCOUNT);
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billcount = (BasedataEdit)this.getView().getControl(BILLBANK);
        billcount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"save"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "account": {
                DynamicObject company = this.getModel().getDataEntity().getDynamicObject(COMPANY);
                if (EmptyUtil.isEmpty((DynamicObject)company)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\uff01", (String)"LinkPayRelationEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Long companyid = company.getLong("id");
                QFilter accountqFilter = new QFilter(COMPANY, "=", (Object)companyid);
                evt.addCustomQFilter(accountqFilter);
                break;
            }
            case "billbank": {
                Long beankid;
                QFilter billFilter;
                DynamicObject bebankinfo;
                String union_number;
                DynamicObject bebank;
                QFilter qFilter = new QFilter("bebank", "=", null);
                DynamicObject bank = this.getModel().getDataEntity().getDynamicObject("bank");
                if (EmptyUtil.isNoEmpty((DynamicObject)bank) && EmptyUtil.isNoEmpty((DynamicObject)(bebank = bank.getDynamicObject("bebank"))) && (union_number = (bebankinfo = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{billFilter = new QFilter("id", "=", (Object)(beankid = Long.valueOf(bebank.getLong("id"))))})).getString("union_number")) != null && union_number.length() > 2) {
                    union_number = union_number.substring(0, 3);
                    qFilter = new QFilter("bebank.union_number", "like", (Object)(union_number + "%"));
                }
                evt.addCustomQFilter(qFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            DynamicObject account = this.getModel().getDataEntity().getDynamicObject(ACCOUNT);
            if (EmptyUtil.isEmpty((DynamicObject)account)) {
                return;
            }
            Long billbankid = account.getLong("id");
            Object[] accountmaintenancebill = BusinessDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,billbank", (QFilter[])new QFilter[]{new QFilter(ACCOUNT, "=", (Object)billbankid)});
            if (EmptyUtil.isNoEmpty((Object[])accountmaintenancebill) && accountmaintenancebill.length > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ef4\u62a4\u91cd\u590d\u7684\u94f6\u884c\u8d26\u53f7\u6570\u636e\u3002", (String)"AccountMaintenanceBillEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void companyRegisterListener() {
        IFormView view = this.getView();
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedAcctOrg((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"am_accountmaintenance", (String)"47150e89000000ac");
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)COMPANY, evt -> {
            ArrayList<Long> orgListId = new ArrayList<Long>();
            if (orgList != null && orgList.size() != 0) {
                for (DynamicObject orgPk : orgList) {
                    orgListId.add(orgPk.getLong("id"));
                }
            }
            return new QFilter("id", "in", orgListId);
        });
    }

    private void afterEdit(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "account": {
                this.dealAccount();
                break;
            }
            case "billbank": {
                this.dealBillBank();
                break;
            }
            case "company": {
                this.dealCompany();
                break;
            }
        }
    }

    private void dealCompany() {
        this.getModel().setValue(ACCOUNT, null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue(BILLBANK, null);
        this.getModel().setValue("billbankname", null);
        this.getModel().setValue("openorg", null);
        this.getModel().setValue("bank", null);
        this.getModel().setValue("bankname", null);
    }

    private void dealBillBank() {
        DynamicObject billbank = this.getModel().getDataEntity().getDynamicObject(BILLBANK);
        if (EmptyUtil.isEmpty((DynamicObject)billbank)) {
            this.getModel().setValue("billbankname", null);
        } else {
            Long billbankid;
            Long bankid;
            DynamicObject bank = this.getModel().getDataEntity().getDynamicObject("BANK");
            if (EmptyUtil.isNoEmpty((DynamicObject)bank) && (bankid = Long.valueOf(bank.getLong("id"))).compareTo(billbankid = Long.valueOf(billbank.getLong("id"))) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u7ef4\u62a4\u4e0e\u94f6\u884c\u8d26\u53f7\u5f00\u6237\u884c\u4e00\u81f4\u7684\u7968\u636e\u8d26\u53f7\u7684\u5f00\u6237\u884c\u3002", (String)"AccountMaintenanceBillEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(BILLBANK, null);
                return;
            }
            DynamicObject bebank = billbank.getDynamicObject("bebank");
            if (EmptyUtil.isNoEmpty((DynamicObject)bebank)) {
                this.getModel().setValue("billbankname", (Object)bebank.getString("number"));
            } else {
                this.getModel().setValue("billbankname", null);
            }
        }
    }

    private void dealAccount() {
        DynamicObject accout = this.getModel().getDataEntity().getDynamicObject(ACCOUNT);
        if (EmptyUtil.isEmpty((DynamicObject)accout)) {
            this.getModel().setValue("openorg", null);
            this.getModel().setValue("bank", null);
            this.getModel().setValue("bankname", null);
            this.getModel().setValue(BILLBANK, null);
            this.getModel().setValue("billbankname", null);
        } else {
            this.getModel().setValue("openorg", (Object)accout.getDynamicObject("openorg"));
            this.getModel().setValue("bank", (Object)accout.getDynamicObject("bank"));
            this.getModel().setValue("bankname", (Object)accout.getString("acctname"));
            this.getModel().setValue(BILLBANK, null);
            this.getModel().setValue("billbankname", null);
        }
    }
}

