/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.enums.AmBalanceCheckItemEnum;
import kd.tmc.am.common.enums.AmOutStandingCheckItemEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AcctBankLogHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.helper.PeriodHelper;
import kd.tmc.am.common.model.AcctBankLogModel;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class BankAccountAssignCancelEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener,
ClickListener,
CellClickListener {
    private static Log LOGGER = LogFactory.getLog(BankAccountAssignCancelEdit.class);
    private static final String F_BASE_DATA_ID = "fbasedataid";
    private static final String ID = "id";
    private static final String COMPANY = "company";
    private static final String ORG = "org";
    private static final String COLOR_RED = "#fb2323";
    private static final String COLOR_BLUE = "#701df0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addAccountF7SelectListener();
        this.addCardEntryHyperClickListener();
        this.addClickListeners(new String[]{"btn_inbusiness_refresh", "btn_balance_refresh", "btn_casfi_refresh", "btn_assingcancel"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("useorgentry");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.processBaseInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.processUseOryEntry();
        this.processAccountCheckInfo();
    }

    public void beforeClick(BeforeClickEvent evt) {
        String operateKey;
        Control source = (Control)evt.getSource();
        switch (operateKey = source.getKey()) {
            case "btn_assingcancel": {
                boolean result = this.beforeCancelAssign();
                if (result) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String operateKey = source.getKey();
        IFormView view = this.getView();
        switch (operateKey) {
            case "btn_inbusiness_refresh": {
                this.loadInBusinessCard();
                break;
            }
            case "btn_balance_refresh": {
                this.loadBalanceBusinessCard();
                break;
            }
            case "btn_casfi_refresh": {
                this.loadCasFiCheckCard();
                break;
            }
            case "btn_assingcancel": {
                boolean result = this.cancelAssign();
                if (!result) break;
                this.processUseOryEntry();
                this.processAccountCheckInfo();
                view.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f\u3002", (String)"BankAccountAssignCancelEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "accountbank": {
                this.processUseOryEntry();
                this.processAccountCheckInfo();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String key = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (event.getSource() instanceof CardEntry && EmptyUtil.isNoEmpty(this.getEntrySelectOrgId())) {
            CardEntry cardEntry = (CardEntry)event.getSource();
            DynamicObject currentRowEntry = this.getModel().getEntryRowEntity(cardEntry.getKey(), rowIndex);
            switch (key) {
                case "ib_checkresult": {
                    String itemType = currentRowEntry.getString("ib_checktype");
                    this.showRelaBillForm(itemType);
                    break;
                }
                case "be_checkresult": {
                    String itemType = currentRowEntry.getString("be_checktype");
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.DAILY_JOURNAL_BALANCE.getValue())) {
                        this.showListFrom("cas_bankjournalformrpt");
                        break;
                    }
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_BALANCE.getValue())) {
                        this.showListFrom("bei_bankbalance");
                        break;
                    }
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_TRANS_DETAIL.getValue())) {
                        this.showListFrom("bei_transdetail");
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_ELECT_RECEIPT.getValue())) break;
                    this.showListFrom("bei_elecreceipt");
                    break;
                }
                case "cf_checkresult": {
                    String itemType = currentRowEntry.getString("cf_checktype");
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmOutStandingCheckItemEnum.BANK_JOURNAL.getValue())) {
                        this.showListFrom("cas_bankvccheck");
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)itemType, (CharSequence)AmOutStandingCheckItemEnum.BANK_STATEMENT.getValue())) break;
                    this.showListFrom("cas_bankvccheck");
                    break;
                }
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String filedKey;
        switch (filedKey = cellClickEvent.getFieldKey()) {
            case "0": 
            case "useorg": 
            case "seq": {
                this.processAccountCheckInfo();
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private String verifyErrorCheckInfo() {
        boolean bankJournalCheck;
        boolean dailyJournalBalanceCheck;
        boolean inBusinessCheck;
        StringBuilder tips = new StringBuilder();
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity("inbusinessentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cardEntities) && (inBusinessCheck = cardEntities.stream().anyMatch(e -> !e.getBoolean("ib_checkflag")))) {
            tips.append(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u4e1a\u52a1\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"BankAccountAssignCancelEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(cardEntities = this.getModel().getEntryEntity("balanceentry"))) && (dailyJournalBalanceCheck = cardEntities.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("be_checktype"), (CharSequence)AmBalanceCheckItemEnum.DAILY_JOURNAL_BALANCE.getValue())).anyMatch(e -> !e.getBoolean("be_checkflag")))) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u4f59\u989d\u4e0d\u4e3a0\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"BankAccountAssignCancelEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(cardEntities = this.getModel().getEntryEntity("casfientry"))) && (bankJournalCheck = cardEntities.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("cf_checktype"), (CharSequence)AmOutStandingCheckItemEnum.BANK_JOURNAL.getValue())).anyMatch(e -> !e.getBoolean("cf_checkflag")))) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5b58\u5728\u672a\u52fe\u5bf9\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"BankAccountAssignCancelEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        return tips.toString();
    }

    private void processAccountCheckInfo() {
        this.loadInBusinessCard();
        this.loadBalanceBusinessCard();
        this.loadCasFiCheckCard();
        this.processAccountCheckInfoImg();
    }

    private void processUseOryEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entryKey = "useorgentry";
        DynamicObjectCollection useOrgEntries = dataEntity.getDynamicObjectCollection(entryKey);
        useOrgEntries.clear();
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            this.getView().updateView(entryKey);
            return;
        }
        long bankAccountId = bankAccount.getLong(ID);
        Set useOrgIds = AccountBankHelper.getUserAuthorityOrgs((Long)bankAccountId);
        if (!CollectionUtils.isEmpty((Collection)useOrgIds)) {
            useOrgIds.stream().filter(orgId -> orgId.longValue() != bankAccount.getDynamicObject("createorg").getLong(ID)).forEach(orgId -> {
                useOrgEntries.addNew();
                this.getModel().setValue("useorg", orgId, useOrgEntries.size() - 1);
            });
        }
        this.getView().updateView(entryKey);
    }

    private void processAccountCheckInfoImg() {
        Control inBusinessImg = this.getView().getControl("inbusinessimg");
        if (inBusinessImg != null) {
            ((Image)inBusinessImg).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
        }
        ((Image)this.getView().getControl("balanceimg")).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
        ((Image)this.getView().getControl("casfiimg")).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
    }

    private void loadCasFiCheckCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        String entryKey = "casfientry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        String haveText = ResManager.loadKDString((String)"\u6709", (String)"BankAcctManageTransferEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        String noneText = ResManager.loadKDString((String)"\u65e0", (String)"BankAcctManageTransferEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        Set<Long> orgIds = this.getEntrySelectOrgId();
        cardEntries.clear();
        block4: for (AmOutStandingCheckItemEnum item : AmOutStandingCheckItemEnum.values()) {
            String itemName = item.getName();
            String itemType = item.getValue();
            switch (item) {
                case BANK_JOURNAL: {
                    boolean bankJournalIsCheck = EmptyUtil.isNoEmpty(orgIds) && CasBusinessHelper.bankJournalIsCheck(orgIds, (Object)bankAccount.getPkValue());
                    this.addCardEntry(entryKey, itemType, itemName, bankJournalIsCheck ? haveText : noneText, !bankJournalIsCheck);
                    continue block4;
                }
                case BANK_STATEMENT: {
                    boolean bankStatementIsCheck = EmptyUtil.isNoEmpty(orgIds) && CasBusinessHelper.bankStatementIsCheck(orgIds, (Object)bankAccount.getPkValue());
                    this.addCardEntry(entryKey, itemType, itemName, bankStatementIsCheck ? haveText : noneText, !bankStatementIsCheck);
                }
            }
        }
        this.getView().updateView("casfientry");
    }

    private void loadBalanceBusinessCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        String entryKey = "balanceentry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        long bankAccountId = bankAccount.getLong(ID);
        DynamicObjectCollection currencies = bankAccount.getDynamicObjectCollection("currency");
        QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankAccountId);
        Date date = DateUtils.getCurrentDate();
        String showText = ResManager.loadKDString((String)"{0}\u7b14", (String)"BankAcctManageTransferEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        Set<Long> orgIds = this.getEntrySelectOrgId();
        cardEntries.clear();
        block6: for (AmBalanceCheckItemEnum item : AmBalanceCheckItemEnum.values()) {
            String itemName = item.getName();
            String itemType = item.getValue();
            switch (item) {
                case DAILY_JOURNAL_BALANCE: {
                    AtomicBoolean journalBalanceEmpty = new AtomicBoolean(true);
                    if (EmptyUtil.isNoEmpty(orgIds) && EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
                        List currencyIdList = currencies.stream().filter(c -> EmptyUtil.isNoEmpty((DynamicObject)c.getDynamicObject(F_BASE_DATA_ID))).map(c -> c.getDynamicObject(F_BASE_DATA_ID).getLong(ID)).collect(Collectors.toList());
                        Map balanceMap = CasBusinessHelper.getJournalBalanceBatch(orgIds, Collections.singletonList(bankAccountId), currencyIdList);
                        this.processBalanceCardEntry(balanceMap, currencies, entryKey, item, journalBalanceEmpty);
                    }
                    if (!journalBalanceEmpty.get()) continue block6;
                    this.addCardEntry(entryKey, itemType, itemName, "0", true);
                    continue block6;
                }
                case BEI_BALANCE: {
                    AtomicBoolean beiBalanceEmpty = new AtomicBoolean(true);
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
                        Map balanceResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"bankService", (String)"queryBalanceBatch", (Object[])new Object[]{Collections.singletonList(bankAccountId), date});
                        this.processBalanceCardEntry(balanceResultMap, currencies, entryKey, item, beiBalanceEmpty);
                    }
                    if (!beiBalanceEmpty.get()) continue block6;
                    this.addCardEntry(entryKey, itemType, itemName, "0", true);
                    continue block6;
                }
                case BEI_TRANS_DETAIL: {
                    QFilter transDetailsNotMatchFilter = new QFilter("receredtype", "=", (Object)"0");
                    transDetailsNotMatchFilter.or(new QFilter("ismatchereceipt", "=", (Object)"0"));
                    transDetailsNotMatchFilter.or(new QFilter("isdowntobankstate", "=", (Object)"0"));
                    DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)ID, (QFilter[])new QFilter[]{accountFilter, transDetailsNotMatchFilter});
                    int transDetailCount = details.length;
                    this.addCardEntry(entryKey, itemType, itemName, MessageFormat.format(showText, transDetailCount + ""), transDetailCount == 0);
                    continue block6;
                }
                case BEI_ELECT_RECEIPT: {
                    DynamicObject[] electReceipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)ID, (QFilter[])new QFilter[]{accountFilter, new QFilter("ismatch", "=", (Object)"0")});
                    int electReceiptCount = electReceipts.length;
                    this.addCardEntry(entryKey, itemType, itemName, MessageFormat.format(showText, electReceiptCount + ""), electReceiptCount == 0);
                    continue block6;
                }
            }
        }
        this.getView().updateView("balanceentry");
    }

    private void processBalanceCardEntry(Map<String, BigDecimal> balanceMap, DynamicObjectCollection currencies, String entryKey, AmBalanceCheckItemEnum item, AtomicBoolean isEmpty) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        long bankAccountId = bankAccount.getLong(ID);
        String itemType = item.getValue();
        String itemName = item.getName();
        Map idAndCurrencyMap = currencies.stream().filter(c -> EmptyUtil.isNoEmpty((DynamicObject)c.getDynamicObject(F_BASE_DATA_ID))).collect(Collectors.toMap(dy -> dy.getDynamicObject(F_BASE_DATA_ID).getLong(ID), o -> o, (o1, o2) -> o1, HashMap::new));
        HashMap<Long, Pair> currencyIdAndBalanceMap = new HashMap<Long, Pair>(16);
        if (!CollectionUtils.isEmpty(balanceMap)) {
            balanceMap.forEach((key, val) -> {
                String[] keys = key.split("-");
                switch (item) {
                    case DAILY_JOURNAL_BALANCE: {
                        DynamicObject dy;
                        if (keys.length <= 2 || !StringUtils.isNotEmpty((CharSequence)keys[2]) || !StringUtils.isNotEmpty((CharSequence)keys[1]) || !EmptyUtil.isNoEmpty((DynamicObject)(dy = (DynamicObject)idAndCurrencyMap.get(Long.parseLong(keys[2])))) || !EmptyUtil.isNoEmpty((BigDecimal)val) || Long.parseLong(keys[1]) != bankAccountId) break;
                        DynamicObject currency = dy.getDynamicObject(F_BASE_DATA_ID);
                        Pair pair = (Pair)currencyIdAndBalanceMap.get(currency.getLong(ID));
                        pair = pair == null ? Pair.of((Object)val, (Object)currency) : Pair.of((Object)((BigDecimal)pair.getKey()).add((BigDecimal)val), (Object)currency);
                        currencyIdAndBalanceMap.put(currency.getLong(ID), pair);
                        break;
                    }
                    case BEI_BALANCE: {
                        DynamicObject dy;
                        if (keys.length <= 1 || !StringUtils.isNotEmpty((CharSequence)keys[0]) || !StringUtils.isNotEmpty((CharSequence)keys[1]) || !EmptyUtil.isNoEmpty((DynamicObject)(dy = (DynamicObject)idAndCurrencyMap.get(Long.parseLong(keys[1])))) || !EmptyUtil.isNoEmpty((BigDecimal)val) || Long.parseLong(keys[0]) != bankAccountId) break;
                        DynamicObject currency = dy.getDynamicObject(F_BASE_DATA_ID);
                        currencyIdAndBalanceMap.put(currency.getLong(ID), Pair.of((Object)val, (Object)currency));
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(currencyIdAndBalanceMap)) {
            isEmpty.set(false);
            currencyIdAndBalanceMap.forEach((currencyId, pair) -> {
                DynamicObject currency = (DynamicObject)pair.getValue();
                this.addCardEntry(entryKey, itemType, itemName, currency.getString("sign") + TmcBusinessBaseHelper.formatDecimal((BigDecimal)((BigDecimal)pair.getKey()), (int)currency.getInt("amtprecision")), false);
            });
        }
    }

    private Set<Long> getEntrySelectOrgId() {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection useOrgEntries = dataEntity.getDynamicObjectCollection("useorgentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("useorgentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject entry = (DynamicObject)useOrgEntries.get(selectRow);
                DynamicObject org = entry.getDynamicObject("useorg");
                if (!EmptyUtil.isNoEmpty((DynamicObject)org)) continue;
                orgIds.add(org.getLong(ID));
            }
        }
        return orgIds;
    }

    private void loadInBusinessCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        String showText = ResManager.loadKDString((String)"{0}\u5f20", (String)"BankAcctManageTransferEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        IPageCache pageCache = this.getPageCache();
        Object bankAccountId = bankAccount.getPkValue();
        Set<Long> orgIds = this.getEntrySelectOrgId();
        String entryKey = "inbusinessentry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        cardEntries.clear();
        DynamicObject inBusinessConfig = BusinessDataServiceHelper.loadSingle((String)"am_inbusiness_checkconfig", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty((DynamicObject)inBusinessConfig) || EmptyUtil.isEmpty((DynamicObjectCollection)inBusinessConfig.getDynamicObjectCollection("entryentity"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inbusinessflexpanelap"});
            return;
        }
        DynamicObjectCollection checkList = inBusinessConfig.getDynamicObjectCollection("entryentity");
        HashMap cacheMap = new HashMap(8);
        for (DynamicObject checkInfo : checkList) {
            String accountKeys = checkInfo.getString("entityfieldkey");
            String orgKeys = checkInfo.getString("orgfieldkey");
            String entityName = checkInfo.getDynamicObject("billentity").getString("number");
            try {
                String condition;
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
                ArrayList cacheFilterStringList = new ArrayList(10);
                String[] accountKeyArray = accountKeys.split(",");
                QFilter accountQFilter = new QFilter(accountKeyArray[0], "=", bankAccountId);
                if (accountKeyArray.length > 1) {
                    for (int i = 1; i < accountKeyArray.length; ++i) {
                        accountQFilter.or(accountKeyArray[i], "=", bankAccountId);
                    }
                }
                qFilterList.add(accountQFilter);
                if (EmptyUtil.isNoEmpty(orgIds) && EmptyUtil.isNoEmpty((String)orgKeys)) {
                    String[] orgKeyArray = orgKeys.split(",");
                    QFilter orgQFilter = new QFilter(orgKeyArray[0], "in", orgIds);
                    if (orgKeyArray.length > 1) {
                        for (int i = 1; i < orgKeyArray.length; ++i) {
                            orgQFilter.or(orgKeyArray[i], "in", orgIds);
                        }
                    }
                    qFilterList.add(orgQFilter);
                }
                if (EmptyUtil.isNoEmpty((String)(condition = checkInfo.getString("savecondition_tag")))) {
                    CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
                    ConditionFactory conditionFactory = new ConditionFactory();
                    ConvertContext context = new ConvertContext();
                    BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
                    context.setSourceMainType(srcMainType);
                    ConvertRuleElement rule = new ConvertRuleElement();
                    rule.setRunCondition(targetCondition);
                    SingleRuleContext ruleContext = new SingleRuleContext();
                    ruleContext.setContext(context);
                    ruleContext.setRule(rule);
                    ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
                    ruleContext.setRuleCompiler(ruleCompiler);
                    conditionFactory.init(context, ruleContext);
                    CRConditionCompiler runCondCompiler = ruleContext.getRuleCompiler().compileRunCondition();
                    qFilterList.addAll(runCondCompiler.getGridQFilters());
                }
                qFilterList.forEach(f -> cacheFilterStringList.add(f.toSerializedString()));
                cacheMap.put(entityName, cacheFilterStringList);
                int inBusinessBillCount = 0;
                if (EmptyUtil.isNoEmpty(orgIds)) {
                    DynamicObject[] businessBills = TmcDataServiceHelper.load((String)entityName, (String)ID, (QFilter[])qFilterList.toArray(new QFilter[0]));
                    inBusinessBillCount = businessBills.length;
                }
                this.addCardEntry(entryKey, entityName, checkInfo.getString("checkname"), MessageFormat.format(showText, inBusinessBillCount + ""), inBusinessBillCount == 0);
            }
            catch (Exception e) {
                LOGGER.error("\u68c0\u67e5\u94f6\u884c\u8d26\u6237\u4f7f\u7528\u60c5\u51b5-\u6839\u636e\u5728\u9014\u6570\u636e\u6e05\u5355\u5217\u8868\u7684\u914d\u7f6e\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u5931\u8d25\u3002", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u5728\u9014\u6570\u636e\u6e05\u5355\u5217\u8868\u7684\u914d\u7f6e\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u4e1a\u52a1\u5355\u636e\uff1a{0}\uff0c\u8d26\u6237\u5b57\u6bb5\u540d\uff1a{1}\u3002", (String)"BankAcctManageTransferEdit_12", (String)"tmc-am-formplugin", (Object[])new Object[]{checkInfo.getDynamicObject("billentity").getString("name"), accountKeys}));
                this.addCardEntry(entryKey, entityName, checkInfo.getString("checkname"), MessageFormat.format(showText, "0"), false);
            }
        }
        pageCache.put("checkInfoResult", JSON.toJSONString(cacheMap));
        this.getView().updateView("inbusinessentry");
    }

    private void processBaseInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object accountBanks = customParams.get("accountbank");
        if (EmptyUtil.isEmpty(accountBanks)) {
            return;
        }
        List pkValues = (List)accountBanks;
        IDataModel model = this.getModel();
        model.setValue("accountbank", pkValues.get(0));
        if (pkValues.size() == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountbank"});
        }
        this.getPageCache().put("accountbank", SerializationUtils.toJsonString((Object)pkValues));
    }

    private void addAccountF7SelectListener() {
        BasedataEdit accountBank = (BasedataEdit)this.getControl("accountbank");
        if (EmptyUtil.isNoEmpty((Object)accountBank)) {
            accountBank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                IPageCache pageCache = this.getPageCache();
                List pkValues = SerializationUtils.fromJsonStringToList((String)pageCache.get("accountbank"), Object.class);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(ID, "in", (Object)pkValues)));
            });
        }
    }

    private void addCardEntryHyperClickListener() {
        CardEntry cardEntry = (CardEntry)this.getControl("balanceentry");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        CardEntry casFiCardEntry = (CardEntry)this.getControl("casfientry");
        casFiCardEntry.addHyperClickListener((HyperLinkClickListener)this);
        CardEntry inBusinessCardEntry = (CardEntry)this.getControl("inbusinessentry");
        inBusinessCardEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void showRelaBillForm(String entityName) {
        Map checkInfoResultMap;
        List qFilterStringList;
        String checkInfoResult = this.getPageCache().get("checkInfoResult");
        if (EmptyUtil.isNoEmpty((String)checkInfoResult) && EmptyUtil.isNoEmpty((Object)(qFilterStringList = (List)(checkInfoResultMap = (Map)JSON.parseObject((String)checkInfoResult, (TypeReference)new TypeReference<Map<String, List<String>>>(){}, (Feature[])new Feature[0])).get(entityName)))) {
            List qFilters = qFilterStringList.stream().map(QFilter::fromSerializedString).collect(Collectors.toList());
            IFormView view = this.getView();
            FormShowParameter currentViewForm = view.getFormShowParameter();
            ListShowParameter sp = new ListShowParameter();
            sp.setFormId("bos_list");
            sp.setBillFormId(entityName);
            List filters = sp.getListFilterParameter().getQFilters();
            filters.addAll(qFilters);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setAppId(currentViewForm.getAppId());
            sp.setParentFormId(currentViewForm.getFormId());
            sp.setCustomParam("isTrack", (Object)true);
            view.showForm((FormShowParameter)sp);
        }
    }

    private void showListFrom(String entityName) {
        IFormView view = this.getView();
        FormShowParameter currentViewForm = view.getFormShowParameter();
        FormShowParameter formShowParameter = this.createFormShowParameter(entityName);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setAppId(currentViewForm.getAppId());
        formShowParameter.setParentFormId(currentViewForm.getFormId());
        formShowParameter.setCustomParams(this.createCustomParams(entityName));
        view.showForm(formShowParameter);
    }

    private Map<String, Object> createCustomParams(String entityName) {
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        Date date = DateUtils.getCurrentDate();
        Set<Long> orgIds = this.getEntrySelectOrgId();
        switch (entityName) {
            case "cas_bankjournalformrpt": {
                customParamMap.put("queryorgtype", ORG);
                customParamMap.put(ORG, EmptyUtil.isNoEmpty(orgIds) ? SerializationUtils.toJsonString(orgIds) : SerializationUtils.toJsonString(new HashSet(0)));
                customParamMap.put("periodId", EmptyUtil.isNoEmpty(orgIds) ? PeriodHelper.getPeriodId((long)orgIds.iterator().next(), (Date)date) : null);
                customParamMap.put("periodtype", EmptyUtil.isNoEmpty(orgIds) ? Long.valueOf(PeriodHelper.getPeriodTypeId((long)orgIds.iterator().next())) : null);
                break;
            }
            case "bei_bankbalance": {
                customParamMap.put(COMPANY, "");
                customParamMap.put("bizDateRange", "");
                break;
            }
            case "bei_transdetail": 
            case "bei_elecreceipt": {
                customParamMap.put(COMPANY, 0L);
                break;
            }
            case "cas_bankvccheck": {
                customParamMap.put(ORG, EmptyUtil.isNoEmpty(orgIds) ? SerializationUtils.toJsonString(orgIds.stream().map(orgId -> orgId + "").collect(Collectors.toSet())) : SerializationUtils.toJsonString(new HashSet(0)));
                customParamMap.put("bizdate", CompareTypeEnum.THISMONTH.getId());
            }
        }
        customParamMap.put("accountbank", bankAccount.getPkValue());
        customParamMap.put("fromAccountTrade", "1");
        customParamMap.put("fromAccountAssignCancel", "1");
        return customParamMap;
    }

    private FormShowParameter createFormShowParameter(String entityName) {
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"cas_bankjournalformrpt")) {
            ReportShowParameter formShowParameter = new ReportShowParameter();
            formShowParameter.setFormId(entityName);
            return formShowParameter;
        }
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("bos_list");
        formShowParameter.setBillFormId(entityName);
        this.setListFromShowQFilters(entityName, formShowParameter);
        return formShowParameter;
    }

    private void setListFromShowQFilters(String entityName, ListShowParameter formShowParameter) {
        List filters = formShowParameter.getListFilterParameter().getQFilters();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date date = DateUtils.getCurrentDate();
        switch (entityName) {
            case "bei_transdetail": {
                QFilter transDetailsNotMatchFilter = new QFilter("receredtype", "=", (Object)"0");
                transDetailsNotMatchFilter.or(new QFilter("ismatchereceipt", "=", (Object)"0"));
                transDetailsNotMatchFilter.or(new QFilter("isdowntobankstate", "=", (Object)"0"));
                filters.add(transDetailsNotMatchFilter);
                break;
            }
            case "bei_elecreceipt": {
                filters.add(new QFilter("ismatch", "=", (Object)"0"));
                break;
            }
            case "bei_bankbalance": {
                filters.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false)));
            }
        }
    }

    private void addCardEntry(String entryKey, String itemType, String itemName, String checkResult, boolean checkFlag) {
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity(entryKey);
        DynamicObject dynamicObject = cardEntities.addNew();
        String fieldKey = "";
        switch (entryKey) {
            case "inbusinessentry": {
                dynamicObject.set("ib_checktype", (Object)itemType);
                dynamicObject.set("ib_checkname", (Object)itemName);
                dynamicObject.set("ib_checkresult", (Object)checkResult);
                dynamicObject.set("ib_checkflag", (Object)checkFlag);
                fieldKey = "ib_checkresult";
                break;
            }
            case "balanceentry": {
                dynamicObject.set("be_checktype", (Object)itemType);
                dynamicObject.set("be_checkname", (Object)itemName);
                dynamicObject.set("be_checkresult", (Object)checkResult);
                dynamicObject.set("be_checkflag", (Object)checkFlag);
                fieldKey = "be_checkresult";
                break;
            }
            case "casfientry": {
                dynamicObject.set("cf_checktype", (Object)itemType);
                dynamicObject.set("cf_checkname", (Object)itemName);
                dynamicObject.set("cf_checkresult", (Object)checkResult);
                dynamicObject.set("cf_checkflag", (Object)checkFlag);
                fieldKey = "cf_checkresult";
            }
        }
        this.setControlCssStyle(entryKey, fieldKey, cardEntities.size() - 1, checkFlag);
    }

    private void setControlCssStyle(String entryKey, String fieldKey, int index, boolean checkFlag) {
        CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
        HashMap customProMap = new HashMap(8);
        HashMap<String, String> controlProMap = new HashMap<String, String>(8);
        controlProMap.put("fc", checkFlag ? COLOR_BLUE : COLOR_RED);
        customProMap.put(fieldKey, controlProMap);
        cardEntry.setCustomProperties(entryKey, index, customProMap);
    }

    private boolean beforeCancelAssign() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BankAccountAssignCancelEdit_7", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.processAccountCheckInfo();
        Set<Long> selectOrgIds = this.getEntrySelectOrgId();
        if (EmptyUtil.isEmpty(selectOrgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BankAccountAssignCancelEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return false;
        }
        String tipsCheckInfo = this.verifyErrorCheckInfo();
        if (EmptyUtil.isNoEmpty((String)tipsCheckInfo)) {
            this.getView().showErrorNotification(tipsCheckInfo);
            return false;
        }
        return true;
    }

    private boolean cancelAssign() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        long accountId = bankAccount.getLong(ID);
        Set<Long> selectOrgIds = this.getEntrySelectOrgId();
        HashSet<Long> dataIdSet = new HashSet<Long>(8);
        dataIdSet.add(accountId);
        List cancelAssignResultList = new ArrayList(10);
        try (TXHandle tx = TX.required();){
            try {
                cancelAssignResultList = BaseDataServiceHelper.cancelAssign((String)"am_accountbank", dataIdSet, selectOrgIds);
                if (CollectionUtils.isEmpty(cancelAssignResultList)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"BankAccountAssignCancelEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
                CancelAssignResult cancelAssignResult = (CancelAssignResult)cancelAssignResultList.get(0);
                if (!cancelAssignResult.isSuccess()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{0}", (String)"BankAccountAssignCancelEdit_6", (String)"tmc-am-formplugin", (Object[])new Object[]{cancelAssignResult.getErrorMsg()}));
                }
                HashSet unAssignOrgIds = new HashSet(8);
                DBRoute dbRoute = new DBRoute("sys");
                String selectSql = "select fuseorgid from t_am_unassign_org_u where faccountid = ?";
                Object[] params = new Object[]{accountId};
                DataSet resultDataSet = DB.queryDataSet((String)"AccountUnAssignQueryUseOrgIds", (DBRoute)dbRoute, (String)selectSql, (Object[])params);
                resultDataSet.forEach(row -> unAssignOrgIds.add(row.getLong("fuseorgid")));
                selectOrgIds.removeIf(unAssignOrgIds::contains);
                selectOrgIds.removeIf(orgId -> !BankAcctHelper.isUse((Object)accountId, (Object)orgId));
                if (EmptyUtil.isNoEmpty(selectOrgIds)) {
                    ArrayList paramsList = new ArrayList(10);
                    String unAssignUseOrgSql = "insert into t_am_unassign_org_u(fid, faccountid, fuseorgid) values(?,?,?);";
                    selectOrgIds.forEach(orgId -> paramsList.add(new Object[]{DB.genGlobalLongId(), accountId, orgId}));
                    DB.executeBatch((DBRoute)dbRoute, (String)unAssignUseOrgSql, paramsList);
                }
                this.addAccountLog(bankAccount, accountId, selectOrgIds);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (Throwable)e);
                LOGGER.info("\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8d26\u6237id\uff1a{}\uff0c\u4f7f\u7528\u7ec4\u7ec7id\u96c6\u5408\uff1a{}\uff0c\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a{}", new Object[]{dataIdSet, selectOrgIds, cancelAssignResultList});
                if (e instanceof KDBizException) {
                    throw new KDBizException(e.getMessage());
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"BankAccountAssignCancelEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private void addAccountLog(DynamicObject bankAccount, long accountId, Set<Long> selectOrgIds) {
        ArrayList<AcctBankLogModel> acctBankLogModels = new ArrayList<AcctBankLogModel>(16);
        DynamicObjectCollection currencies = bankAccount.getDynamicObjectCollection("currency");
        if (currencies == null) {
            LOGGER.error("bank currencies is null::{}", (Object)currencies);
            return;
        }
        String accountName = bankAccount.getString("name");
        for (DynamicObject currency : currencies) {
            Long currencyId = currency.getLong("fbasedataid_id");
            Set<Long> orgIds = this.getEntrySelectOrgId();
            if (orgIds.isEmpty()) {
                LOGGER.error("orgIds is null accountId::{}", (Object)accountId);
                continue;
            }
            for (long orgId : orgIds) {
                AcctBankLogModel acctBankLogModel = new AcctBankLogModel(Long.valueOf(orgId), Long.valueOf(accountId), currencyId, AccountBankLogEnum.ACCOUNT_CALALLOCATION.getValue(), accountName);
                acctBankLogModels.add(acctBankLogModel);
            }
        }
        try {
            AcctBankLogHelper.getInstance().addAcctBankLog(acctBankLogModels, false);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u94f6\u884c\u8d26\u6237\u53d6\u6d88\u5206\u914d\u65e5\u8bb0\u5f02\u5e38:", (Throwable)e);
        }
    }
}

