/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.helper.AcctBankLogHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.model.AcctBankLogModel;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAccountAssignEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(BankAccountAssignEdit.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btn_amassign_query", "btn_assign"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_amassign_query".equals(control.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("asignedDatas", this.getPageCache().get(this.getView().getPageId() + "asignedDatas"));
            params.put("asignedOrgs", this.getPageCache().get(this.getView().getPageId() + "asignedOrgs"));
            params.put("useOrgId", this.getView().getFormShowParameter().getCustomParam("useOrgId"));
            params.put("entityNumber", this.getView().getFormShowParameter().getCustomParam("entityNumber"));
            CloseCallBack assignQueryCallBack = new CloseCallBack((IFormPlugin)this, "assignQueryCallBack");
            BankAcctHelper.showForm((String)"am_assign_query", params, (CloseCallBack)assignQueryCallBack, (ShowType)ShowType.Modal, (IFormView)this.getView());
        } else if ("btn_assign".equals(control.getKey())) {
            TreeView tree = (TreeView)this.getControl("treeviewap");
            List orgList = tree.getTreeState().getSelectedNodeId();
            BillList bill = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bill.getSelectedRows();
            List pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            if (bankAccounts.length > 0) {
                ArrayList<AcctBankLogModel> acctBankLogModels = new ArrayList<AcctBankLogModel>(orgList.size());
                for (String org : orgList) {
                    Long orgId = Long.valueOf(org);
                    for (DynamicObject account : bankAccounts) {
                        DynamicObjectCollection currencies = account.getDynamicObjectCollection("currency");
                        if (currencies == null || EmptyUtil.isEmpty((DynamicObjectCollection)currencies)) continue;
                        for (DynamicObject currency : currencies) {
                            Long currencyId = currency.getLong("fbasedataid_id");
                            Long accountId = account.getLong("id");
                            String accountName = account.getString("name");
                            AcctBankLogModel acctBankLogModel = new AcctBankLogModel(orgId, accountId, currencyId, AccountBankLogEnum.ACCOUNT_ALLOCATION.getValue(), accountName);
                            acctBankLogModels.add(acctBankLogModel);
                        }
                    }
                }
                try {
                    AcctBankLogHelper.getInstance().addAcctBankLog(acctBankLogModels, true);
                }
                catch (Exception e) {
                    logger.error("error:", (Throwable)e);
                }
            }
        }
    }
}

