/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.helper.AcctBankLogHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.model.AcctBankLogModel;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAccountAssignQueryEdit
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(BankAccountAssignQueryEdit.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnunassign"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        IDataModel model = this.getModel();
        if ("btnunassign".equals(key)) {
            EntryGrid billList = (EntryGrid)this.getControl("entryentity");
            int[] col = billList.getSelectRows();
            ArrayList<AcctBankLogModel> acctBankLogModels = new ArrayList<AcctBankLogModel>(col.length);
            ArrayList<Object> accountIds = new ArrayList<Object>(col.length);
            for (int i = 0; i < col.length; ++i) {
                Object accountId = model.getValue("dataid", col[i]);
                accountIds.add(accountId);
            }
            DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((Object[])accountIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            for (int i = 0; i < col.length; ++i) {
                Object accountId = model.getValue("dataid", col[i]);
                Object userOrgId = model.getValue("useorgid", col[i]);
                Object number = model.getValue("number", col[i]);
                Object useOrg = model.getValue("useorg", col[i]);
                boolean flag = BankAcctHelper.isRefrenced((Object)accountId, (Object)userOrgId);
                if (flag) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d26\u6237\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u5206\u914d", (String)"BankAccountAssignQueryEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]), useOrg, number), Integer.valueOf(6000));
                    evt.setCancel(true);
                }
                for (DynamicObject account : bankAccounts) {
                    DynamicObjectCollection currencies = account.getDynamicObjectCollection("currency");
                    if (currencies == null || EmptyUtil.isEmpty((DynamicObjectCollection)currencies)) continue;
                    for (DynamicObject currency : currencies) {
                        Long currencyId = currency.getLong("fbasedataid_id");
                        Long accId = account.getLong("id");
                        String accountName = account.getString("name");
                        AcctBankLogModel acctBankLogModel = new AcctBankLogModel((Long)userOrgId, accId, currencyId, AccountBankLogEnum.ACCOUNT_CALALLOCATION.getValue(), accountName);
                        acctBankLogModels.add(acctBankLogModel);
                    }
                }
            }
            try {
                AcctBankLogHelper.getInstance().addAcctBankLog(acctBankLogModels, false);
            }
            catch (Exception e) {
                logger.error("error:", (Throwable)e);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnunassign".equals(key)) {
            AcctBankLogHelper.getInstance().fireCASBankStatement();
        }
    }
}

