/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;

public class BankAccountElecPaymentEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.settleAcctInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        if (!"normal".equals(this.getModel().getValue("acctstatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iselecpayment", "elecpaymenttype", "elecpaymentlevel", "relatedsettleacct", "company", "openorg"});
        } else if (!OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iselecpayment"});
            if (Boolean.TRUE.equals(this.getModel().getValue("iselecpayment"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"company", "openorg"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] valueSet = args.getChangeSet();
        Object oldValue = valueSet[0].getOldValue();
        Object newValue = valueSet[0].getNewValue();
        if (newValue == oldValue) {
            return;
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        if ("iselecpayment".equals(propName)) {
            if (Boolean.TRUE.equals(newValue)) {
                String formId = this.getView().getFormShowParameter().getFormId();
                String currencyField = "am_accopenbill".equals(formId) ? "muiticurrency" : "currency";
                DynamicObject cny = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CNY")});
                DynamicObjectCollection currencyColl = (DynamicObjectCollection)this.getModel().getValue(currencyField);
                currencyColl.clear();
                DynamicObject newCurrency = new DynamicObject(currencyColl.getDynamicObjectType());
                newCurrency.set("fbasedataid", (Object)cny);
                currencyColl.add((Object)newCurrency);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)currencyField, (Object)currencyColl);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"defaultcurrency", (Object)cny);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isdefaultpay", (Object)Boolean.FALSE);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isdefaultrec", (Object)Boolean.FALSE);
            }
            this.getModel().setValue("issetbankinterface", (Object)"0");
        } else if ("relatedsettleacct".equals(propName) && !OperationStatus.ADDNEW.equals((Object)status)) {
            Set<Long> relatedSettleAcct = ((DynamicObjectCollection)newValue).stream().map(acct -> acct.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            Set changeRelatedSettleAcct = ((DynamicObjectCollection)oldValue).stream().map(acct -> acct.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            relatedSettleAcct.forEach(changeRelatedSettleAcct::remove);
            Set<String> relatedSettleAcctNum = ((DynamicObjectCollection)newValue).stream().map(acct -> acct.getDynamicObject("fbasedataid").getString("bankaccountnumber")).collect(Collectors.toSet());
            Set changeRelatedSettleAcctNum = ((DynamicObjectCollection)oldValue).stream().map(acct -> acct.getDynamicObject("fbasedataid").getString("bankaccountnumber")).collect(Collectors.toSet());
            relatedSettleAcctNum.forEach(changeRelatedSettleAcctNum::remove);
            boolean payBillExists = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("payeracctbank.id", "in", changeRelatedSettleAcct).or("payeebanknum", "in", changeRelatedSettleAcctNum), new QFilter("settletype.settlementtype", "=", (Object)"15"), new QFilter("billstatus", "not in", Arrays.asList("D", "G", "F", "H", "I", "J"))});
            if (payBillExists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237\u53d8\u66f4\u7684\u5173\u8054\u7ed3\u7b97\u8d26\u6237\u4e2d\u5b58\u5728\u5728\u9014\u6570\u5e01\u5b58\u53d6\u5355\uff0c\u8bf7\u5904\u7406\u5728\u9014\u5355\u636e\u540e\u518d\u8fdb\u884c\u53d8\u66f4\u3002", (String)"BankAccountElecPaymentEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("relatedsettleacct", oldValue);
            }
        }
    }

    private void settleAcctInit() {
        BasedataEdit settleAcctF7 = (BasedataEdit)this.getControl("relatedsettleacct");
        settleAcctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            qFilter.and("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
            qFilter.and("iselecpayment", "!=", (Object)true);
            Set acctSet = AccountBankHelper.getElecPaymentRelatedAcctIds((Long)((Long)this.getModel().getValue("id")));
            qFilter.and("id", "not in", (Object)acctSet);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

