/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;

public class BankAccountPrintPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
        String dataSourceName = e.getDataSourceName();
        Object billId = e.getPKId();
        Set customFields = e.getCustomFields();
        this.combineData(dataSourceName, billId, customFields, newDataEntities);
        e.setDataEntities(newDataEntities);
    }

    public void combineData(String dataSourceName, Object billId, Set<String> customFields, List<DynamicObject> newDataEntities) {
        if (dataSourceName.equals("am_accountbank")) {
            DynamicObject bankacct = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bd_accountbanks");
            boolean isdefaultrec = (Boolean)bankacct.get("isdefaultrec");
            boolean isdefaultpay = (Boolean)bankacct.get("isdefaultpay");
            boolean issetbankinterface = (Boolean)bankacct.get("issetbankinterface");
            boolean isopenbank = (Boolean)bankacct.get("isopenbank");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks");
            DynamicObjectType cloneType = null;
            try {
                cloneType = (DynamicObjectType)dataEntityType.clone();
                for (String customField : customFields) {
                    DynamicSimpleProperty demoProp = new DynamicSimpleProperty(customField, String.class, (Object)"");
                    cloneType.registerSimpleProperty(demoProp);
                }
                DynamicObject item = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)cloneType, (Object)bankacct);
                if (isdefaultrec) {
                    item.set("isdefaultrec", (Object)ResManager.loadKDString((String)"\u662f", (String)"BankAccountPrintPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                } else {
                    item.set("isdefaultrec", (Object)ResManager.loadKDString((String)"\u5426", (String)"BankAccountPrintPlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
                if (isdefaultpay) {
                    item.set("isdefaultpay", (Object)ResManager.loadKDString((String)"\u662f", (String)"BankAccountPrintPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                } else {
                    item.set("isdefaultpay", (Object)ResManager.loadKDString((String)"\u5426", (String)"BankAccountPrintPlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
                if (issetbankinterface) {
                    item.set("issetbankinterface", (Object)ResManager.loadKDString((String)"\u662f", (String)"BankAccountPrintPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                } else {
                    item.set("issetbankinterface", (Object)ResManager.loadKDString((String)"\u5426", (String)"BankAccountPrintPlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
                if (isopenbank) {
                    item.set("isopenbank", (Object)ResManager.loadKDString((String)"\u662f", (String)"BankAccountPrintPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                } else {
                    item.set("isopenbank", (Object)ResManager.loadKDString((String)"\u5426", (String)"BankAccountPrintPlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
                item.set("company", bankacct.get("company"));
                item.set("openorg", bankacct.get("openorg"));
                item.set("finorgtype", bankacct.get("finorgtype"));
                item.set("bank", bankacct.get("bank"));
                item.set("defaultcurrency", bankacct.get("defaultcurrency"));
                item.set("acctstyle", (Object)AcctStyleEnum.getName((String)((String)bankacct.get("acctstyle"))));
                item.set("accttype", (Object)AcctTypeEnum.getName((String)((String)bankacct.get("accttype"))));
                item.set("acctstatus", (Object)BankAcctStatusEnum.getName((String)((String)bankacct.get("acctstatus"))));
                item.set("acctproperty", bankacct.get("acctproperty"));
                item.set("manager", bankacct.get("manager"));
                item.set("strategy", bankacct.get("strategy"));
                item.set("managecurrency", bankacct.get("managecurrency"));
                newDataEntities.add(item);
            }
            catch (CloneNotSupportedException e1) {
                throw new KDBizException(new AmBizResource().getErrorPrintClone() + e1.getMessage());
            }
        }
    }
}

