/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.helper.BankFunctionHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class BankFuncListPlugin
extends AbstractFormPlugin {
    public static final Log logger = LogFactory.getLog(BankFuncListPlugin.class);
    private String[] bankFunc = new String[]{BankFuncEnum.QUERY.getValue(), BankFuncEnum.PAY.getValue(), BankFuncEnum.RECEIPT.getValue(), BankFuncEnum.ECD.getValue(), BankFuncEnum.PROXYINQUIRY.getValue()};
    private Object newValue = null;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long pkid = 0L;
        DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        pkid = this.getView().getFormShowParameter().getCustomParam("pkid") instanceof Long ? (Long)this.getView().getFormShowParameter().getCustomParam("pkid") : Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("pkid"));
        Boolean isElecPayment = (Boolean)this.getView().getFormShowParameter().getCustomParam("iselecpayment");
        if (isElecPayment != null && isElecPayment.booleanValue()) {
            entryentity.clear();
            for (int i = 0; i < 2; ++i) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("bankfunction", (Object)this.bankFunc[i]);
            }
            this.getModel().setValue("entry", (Object)entryentity);
            return;
        }
        List listMap = (List)this.getView().getFormShowParameter().getCustomParam("entries");
        if (listMap != null && !listMap.isEmpty()) {
            for (Map entry : listMap) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("id", entry.get("id"));
                dynamicObject.set("enable", entry.get("e_enable"));
                dynamicObject.set("bankfunction", entry.get("e_bankfunction"));
                dynamicObject.set("seq", entry.get("seq"));
                if (entry.get("e_predictopendate") != null) {
                    dynamicObject.set("predictopendate", (Object)DateUtils.stringToDate((String)entry.get("e_predictopendate").toString(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (entry.get("e_actualopendate") != null) {
                    dynamicObject.set("actualopendate", (Object)DateUtils.stringToDate((String)entry.get("e_actualopendate").toString(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                dynamicObject.set("billinfo", entry.get("e_billinfo"));
            }
        } else if (pkid == 0L) {
            for (int i = 0; i < 5; ++i) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("bankfunction", (Object)this.bankFunc[i]);
            }
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)pkid);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(qFilter);
            BankFunctionHelper.upgrade(filterList);
            DynamicObject[] accounts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"entry,entry.seq,entry.e_enable,entry.e_bankfunction,entry.e_predictopendate,entry.e_actualopendate,entry.e_billinfo", (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection entries = accounts[0].getDynamicObjectCollection("entry");
            if (entries == null || entries.size() == 0) {
                for (int i = 0; i < 5; ++i) {
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("bankfunction", (Object)this.bankFunc[i]);
                    dynamicObject.set("seq", (Object)(i + 1));
                    dynamicObject.set("enable", (Object)Boolean.FALSE);
                }
            } else if ("report".equals(source)) {
                int index = 0;
                for (DynamicObject entry : entries) {
                    if (!((Boolean)entry.get("e_enable")).booleanValue()) continue;
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("id", entry.getPkValue());
                    dynamicObject.set("enable", entry.get("e_enable"));
                    dynamicObject.set("seq", entry.get("seq"));
                    dynamicObject.set("bankfunction", entry.get("e_bankfunction"));
                    dynamicObject.set("predictopendate", entry.get("e_predictopendate"));
                    dynamicObject.set("actualopendate", entry.get("e_actualopendate"));
                    dynamicObject.set("billinfo", entry.get("e_billinfo"));
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"enable"});
                    ++index;
                }
                this.getView().updateView();
            } else {
                for (DynamicObject entry : entries) {
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("id", entry.getPkValue());
                    dynamicObject.set("enable", entry.get("e_enable"));
                    dynamicObject.set("seq", entry.get("seq"));
                    dynamicObject.set("bankfunction", entry.get("e_bankfunction"));
                    dynamicObject.set("predictopendate", entry.get("e_predictopendate"));
                    dynamicObject.set("actualopendate", entry.get("e_actualopendate"));
                    dynamicObject.set("billinfo", entry.get("e_billinfo"));
                }
            }
            this.getModel().setValue("entry", (Object)entryentity);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        long pkid = 0L;
        pkid = this.getView().getFormShowParameter().getCustomParam("pkid") instanceof Long ? (Long)this.getView().getFormShowParameter().getCustomParam("pkid") : Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("pkid"));
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)control.getKey())) {
            DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entry");
            String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date openDate = null;
            if (this.getView().getFormShowParameter().getCustomParam("opendate") != null) {
                try {
                    openDate = df.parse((String)this.getView().getFormShowParameter().getCustomParam("opendate"));
                }
                catch (ParseException ex) {
                    logger.error((Throwable)ex);
                }
            } else {
                QFilter qFilter = new QFilter("id", "=", (Object)pkid);
                DynamicObject[] accounts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"opendate", (QFilter[])new QFilter[]{qFilter});
                openDate = accounts[0].getDate("opendate");
            }
            for (DynamicObject row : rows) {
                int compareDate;
                Date predictopendate = row.getDate("predictopendate");
                if (openDate == null || predictopendate == null || !(this.newValue instanceof Date) || this.newValue == null || (compareDate = openDate.compareTo((Date)this.newValue)) <= 0) continue;
                return;
            }
            if ("report".equals(source)) {
                DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"am_accountbank");
                DynamicObjectCollection entry = account.getDynamicObjectCollection("entry");
                for (DynamicObject row : rows) {
                    for (int i = 0; i < entry.size(); ++i) {
                        if (!row.get("bankfunction").equals(((DynamicObject)entry.get(i)).get("e_bankfunction"))) continue;
                        ((DynamicObject)entry.get(i)).set("e_predictopendate", row.get("predictopendate"));
                    }
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{account});
            }
            HashMap<String, DynamicObjectCollection> returnData = new HashMap<String, DynamicObjectCollection>(1);
            returnData.put("rows", rows);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int compareDate;
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = changeData[0].getRowIndex();
        this.newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        Date predictopendate = ((DynamicObject)entryEntity.get(rowIndex)).getDate("predictopendate");
        if (StringUtils.equals((CharSequence)"enable", (CharSequence)e.getProperty().getName()) && Boolean.TRUE.equals(this.newValue) && predictopendate == null) {
            ((DynamicObject)entryEntity.get(rowIndex)).set("predictopendate", (Object)new Date());
        }
        if (StringUtils.equals((CharSequence)"predictopendate", (CharSequence)e.getProperty().getName()) && this.newValue == null && oldValue != null) {
            ((DynamicObject)entryEntity.get(rowIndex)).set("predictopendate", oldValue);
            this.getView().updateView("predictopendate", rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u5f00\u901a\u94f6\u4f01\u529f\u80fd\u540e\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankFuncListPlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date openDate = null;
        if (this.getView().getFormShowParameter().getCustomParam("opendate") != null) {
            try {
                openDate = df.parse((String)this.getView().getFormShowParameter().getCustomParam("opendate"));
            }
            catch (ParseException ex) {
                logger.error((Throwable)ex);
            }
        } else {
            long pkid = (Long)this.getView().getFormShowParameter().getCustomParam("pkid");
            QFilter qFilter = new QFilter("id", "=", (Object)pkid);
            DynamicObject[] accounts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"opendate", (QFilter[])new QFilter[]{qFilter});
            openDate = accounts[0].getDate("opendate");
        }
        if (openDate != null && predictopendate != null && (compareDate = openDate.compareTo(predictopendate)) > 0) {
            ((DynamicObject)entryEntity.get(rowIndex)).set("predictopendate", (Object)((Date)oldValue));
            this.getView().updateView("predictopendate", rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u5f00\u901a\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d26\u6237\u5f00\u6237\u65e5\u671f", (String)"BankFuncListPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateView();
    }
}

