/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.am.common.enums.AmBalanceCheckItemEnum;
import kd.tmc.am.common.enums.AmCasFiCheckItemEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.helper.PeriodHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BankAcctManageTransferEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener,
ClickListener {
    private static Log LOGGER = LogFactory.getLog(BankAcctManageTransferEdit.class);
    private static final String F_BASE_DATA_ID = "fbasedataid";
    private static final String ID = "id";
    private static final String COLOR_RED = "#fb2323";
    private static final String COLOR_BLUE = "#701df0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addOrgF7SelectListener();
        this.addCardEntryHyperClickListener();
        this.addClickListeners(new String[]{"btn_inbusiness_refresh", "btn_balance_refresh", "btn_casfi_refresh"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.processBaseInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.processControlVisible();
        this.processAccountCheckInfo();
        this.processUseOryEntry();
    }

    public void click(EventObject evt) {
        String operateKey;
        Control source = (Control)evt.getSource();
        switch (operateKey = source.getKey()) {
            case "btn_inbusiness_refresh": {
                this.loadInBusinessCard();
                break;
            }
            case "btn_balance_refresh": {
                this.loadBalanceBusinessCard();
                break;
            }
            case "btn_casfi_refresh": {
                this.loadCasFiCheckCard();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String key = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (event.getSource() instanceof CardEntry) {
            CardEntry cardEntry = (CardEntry)event.getSource();
            DynamicObject currentRowEntry = this.getModel().getEntryRowEntity(cardEntry.getKey(), rowIndex);
            switch (key) {
                case "ib_checkresult": {
                    String itemType = currentRowEntry.getString("ib_checktype");
                    this.showRelaBillForm(itemType);
                    break;
                }
                case "be_checkresult": {
                    String itemType = currentRowEntry.getString("be_checktype");
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.DAILY_JOURNAL_BALANCE.getValue())) {
                        this.showListFrom("cas_bankjournalformrpt");
                        break;
                    }
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_BALANCE.getValue())) {
                        this.showListFrom("bei_bankbalance");
                        break;
                    }
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_TRANS_DETAIL.getValue())) {
                        this.showListFrom("bei_transdetail");
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)itemType, (CharSequence)AmBalanceCheckItemEnum.BEI_ELECT_RECEIPT.getValue())) break;
                    this.showListFrom("bei_elecreceipt");
                    break;
                }
                case "cf_checkresult": {
                    String itemType = currentRowEntry.getString("cf_checktype");
                    if (StringUtils.equals((CharSequence)itemType, (CharSequence)AmCasFiCheckItemEnum.OUT_STANDING.getValue())) {
                        this.showListFrom("cas_bankvccheck");
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)itemType, (CharSequence)AmCasFiCheckItemEnum.MISS_BALANCE_ADJUST.getValue())) break;
                    this.showListFrom("cas_balanceadjust");
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        IFormView view = this.getView();
        switch (opKey) {
            case "submit": {
                this.processAccountCheckInfo();
                String tipsCheckInfo = this.verifyErrorCheckInfo();
                OperateOption option = op.getOption();
                if (EmptyUtil.isNoEmpty((String)tipsCheckInfo)) {
                    String msg = ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u8d26\u6237\u4f7f\u7528\u60c5\u51b5\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"BankAcctManageTransferEdit_10", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                    view.showConfirm(msg, tipsCheckInfo, MessageBoxOptions.OK, ConfirmTypes.Save, null);
                    args.setCancel(true);
                    return;
                }
                tipsCheckInfo = this.verifyTipsCheckInfo();
                if (!EmptyUtil.isNoEmpty((String)tipsCheckInfo) || option.containsVariable("confirmVerify")) break;
                String msg = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u9192", (String)"BankAcctManageTransferEdit_11", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
                btnNameMaps.put(6, ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"BankAcctManageTransferEdit_6", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(7, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BankAcctManageTransferEdit_7", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                view.showConfirm(msg, tipsCheckInfo, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("tipsConfirmCallBack", (IFormPlugin)this), btnNameMaps);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        AbstractOperate op = (AbstractOperate)eventArgs.getSource();
        String opKey = op.getOperateKey();
        IFormView view = this.getView();
        switch (opKey) {
            case "submit": 
            case "unsubmit": {
                OperationResult result = eventArgs.getOperationResult();
                if (!result.isSuccess()) break;
                this.processControlVisible();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult res = event.getResult();
        IFormView view = this.getView();
        switch (callBackId) {
            case "tipsConfirmCallBack": {
                if (!MessageBoxResult.Yes.equals((Object)res)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("confirmVerify", "1");
                view.invokeOperation("submit", option);
            }
        }
    }

    private String verifyTipsCheckInfo() {
        boolean balanceAdjustCheck;
        boolean dailyBalanceCheck;
        StringBuilder tips = new StringBuilder();
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity("balanceentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cardEntities) && (dailyBalanceCheck = cardEntities.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("be_checktype"), (CharSequence)AmBalanceCheckItemEnum.DAILY_JOURNAL_BALANCE.getValue())).anyMatch(e -> !e.getBoolean("be_checkflag")))) {
            tips.append(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u4f59\u989d\u4e0d\u4e3a0\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u7ed3\u8f6c\u4f59\u989d\u5230\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"BankAcctManageTransferEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(cardEntities = this.getModel().getEntryEntity("casfientry"))) && (balanceAdjustCheck = cardEntities.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("cf_checktype"), (CharSequence)AmCasFiCheckItemEnum.MISS_BALANCE_ADJUST.getValue())).anyMatch(e -> !e.getBoolean("cf_checkflag")))) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868\u5b58\u5728\u7f3a\u5931\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u5b8c\u6210\u540e\u539f\u7ec4\u7ec7\u65e0\u6cd5\u7ee7\u7eed\u5904\u7406\u8be5\u8d26\u6237\u7684\u76f8\u5173\u4e1a\u52a1\u3002", (String)"BankAcctManageTransferEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (tips.length() > 0) {
            tips.append("\r\n").append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BankAcctManageTransferEdit_13", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        return tips.toString();
    }

    private String verifyErrorCheckInfo() {
        boolean outStandingCheck;
        boolean inBusinessCheck;
        StringBuilder tips = new StringBuilder();
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity("inbusinessentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cardEntities) && (inBusinessCheck = cardEntities.stream().anyMatch(e -> !e.getBoolean("ib_checkflag")))) {
            tips.append(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u4e1a\u52a1", (String)"BankAcctManageTransferEdit_8", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(cardEntities = this.getModel().getEntryEntity("casfientry"))) && (outStandingCheck = cardEntities.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("cf_checktype"), (CharSequence)AmCasFiCheckItemEnum.OUT_STANDING.getValue())).anyMatch(e -> !e.getBoolean("cf_checkflag")))) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8fbe\u8d26\u9879", (String)"BankAcctManageTransferEdit_9", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        return tips.toString();
    }

    private void processAccountCheckInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (!dataEntity.getDataEntityState().getFromDatabase() || StringUtils.equals((CharSequence)dataEntity.getString("billstatus"), (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.loadInBusinessCard();
            this.loadBalanceBusinessCard();
            this.loadCasFiCheckCard();
        } else {
            this.processControlCssStyle();
        }
        this.processAccountCheckInfoImg();
    }

    private void processUseOryEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (!dataEntity.getDataEntityState().getFromDatabase() || StringUtils.equals((CharSequence)dataEntity.getString("billstatus"), (CharSequence)BillStatusEnum.SAVE.getValue())) {
            DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
            long bankAccountId = bankAccount.getLong(ID);
            DynamicObject bdAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccountId, (String)"bd_accountbanks");
            if (EmptyUtil.isEmpty((DynamicObject)bdAccount)) {
                return;
            }
            Set useOrgIds = AccountBankHelper.getUserAuthorityOrgs((Long)bankAccountId);
            String entryKey = "useorgrentry";
            DynamicObjectCollection useOrgEntries = dataEntity.getDynamicObjectCollection(entryKey);
            useOrgEntries.clear();
            if (!CollectionUtils.isEmpty((Collection)useOrgIds)) {
                DynamicObjectCollection onlyViewOrgEntries = bdAccount.getDynamicObjectCollection("transfervieworgentry");
                useOrgIds.forEach(orgId -> {
                    DynamicObject entry = useOrgEntries.addNew();
                    this.getModel().setValue("useorg", orgId, useOrgEntries.size() - 1);
                    entry.set("accountview", (Object)true);
                    entry.set("accountnewbill", (Object)(EmptyUtil.isEmpty((DynamicObjectCollection)onlyViewOrgEntries) || onlyViewOrgEntries.stream().noneMatch(e -> e.getDynamicObject("transfervieworg").getLong(ID) == orgId.longValue()) ? 1 : 0));
                });
            }
            this.getView().updateView(entryKey);
        }
    }

    private void processAccountCheckInfoImg() {
        Control inBusinessImg = this.getView().getControl("inbusinessimg");
        if (inBusinessImg != null) {
            ((Image)inBusinessImg).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
        }
        ((Image)this.getView().getControl("balanceimg")).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
        ((Image)this.getView().getControl("casfiimg")).setUrl("/kingdee/tmc/images/pc/icon/lable/zjy_risk1_40_40.png");
    }

    private void loadCasFiCheckCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        String entryKey = "casfientry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        String haveText = ResManager.loadKDString((String)"\u6709", (String)"BankAcctManageTransferEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        String noneText = ResManager.loadKDString((String)"\u65e0", (String)"BankAcctManageTransferEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        cardEntries.clear();
        block4: for (AmCasFiCheckItemEnum item : AmCasFiCheckItemEnum.values()) {
            String itemName = item.getName();
            String itemType = item.getValue();
            switch (item) {
                case OUT_STANDING: {
                    boolean journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)bankAccount);
                    this.addCardEntry(entryKey, itemType, itemName, journalIsCheck ? noneText : haveText, journalIsCheck);
                    continue block4;
                }
                case MISS_BALANCE_ADJUST: {
                    Date bizDate = DateUtils.getLastMonth((Date)dataEntity.getDate("transferdate"), (int)1);
                    Date transferDate = dataEntity.getDate("transferdate");
                    boolean haveBalanceAdjust = BankAcctHelper.checkMissBalanceAdjust((DynamicObject)bankAccount, (Date)bizDate, (Date)transferDate);
                    this.addCardEntry(entryKey, itemType, itemName, haveBalanceAdjust ? noneText : haveText, haveBalanceAdjust);
                }
            }
        }
        this.getView().updateView("casfientry");
    }

    private void loadBalanceBusinessCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        String entryKey = "balanceentry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        long bankAccountId = bankAccount.getLong(ID);
        DynamicObjectCollection currencies = bankAccount.getDynamicObjectCollection("currency");
        QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankAccountId);
        Date date = dataEntity.getDate("transferdate");
        String showText = ResManager.loadKDString((String)"{0}\u7b14", (String)"BankAcctManageTransferEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        cardEntries.clear();
        block6: for (AmBalanceCheckItemEnum item : AmBalanceCheckItemEnum.values()) {
            String itemName = item.getName();
            String itemType = item.getValue();
            switch (item) {
                case DAILY_JOURNAL_BALANCE: {
                    DynamicObjectCollection cardEntities;
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
                        currencies.forEach(dy -> {
                            DynamicObject currency = dy.getDynamicObject(F_BASE_DATA_ID);
                            BigDecimal balance = Constants.ZERO;
                            try {
                                balance = CasBusinessHelper.getBalanceFormCas((long)bankAccount.getDynamicObject("company").getLong(ID), (long)bankAccountId, (long)currency.getLong(ID));
                            }
                            catch (Exception e) {
                                LOGGER.error("\u68c0\u67e5\u94f6\u884c\u8d26\u6237\u4f7f\u7528\u60c5\u51b5-\u67e5\u8be2\u65e5\u8bb0\u8d26\u4f59\u989d\u5931\u8d25\u3002", (Throwable)e);
                                LOGGER.info("\u68c0\u67e5\u94f6\u884c\u8d26\u6237\u4f7f\u7528\u60c5\u51b5-\u67e5\u8be2\u65e5\u8bb0\u8d26\u4f59\u989d\u5931\u8d25\uff0c\u7ec4\u7ec7\uff1a{}\uff0c\u8d26\u6237\uff1a{}\uff0c\u5e01\u522b\uff1a{}", new Object[]{bankAccount.getDynamicObject("company").getLong(ID), bankAccountId, currency.getLong(ID)});
                            }
                            if (balance.compareTo(Constants.ZERO) != 0) {
                                this.addCardEntry(entryKey, itemType, itemName, currency.getString("sign") + TmcBusinessBaseHelper.formatDecimal((BigDecimal)balance, (int)currency.getInt("amtprecision")), false);
                            }
                        });
                    }
                    if (!EmptyUtil.isEmpty((DynamicObjectCollection)(cardEntities = this.getModel().getEntryEntity(entryKey)))) continue block6;
                    this.addCardEntry(entryKey, itemType, itemName, "0", true);
                    continue block6;
                }
                case BEI_BALANCE: {
                    AtomicBoolean beiBalanceEmpty = new AtomicBoolean(true);
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
                        Map balanceResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"bankService", (String)"queryBalanceBatch", (Object[])new Object[]{Collections.singletonList(bankAccountId), date});
                        Map idAndCurrencyMap = currencies.stream().collect(Collectors.toMap(dy -> dy.getDynamicObject(F_BASE_DATA_ID).getLong(ID), o -> o, (o1, o2) -> o1, HashMap::new));
                        if (!CollectionUtils.isEmpty((Map)balanceResultMap)) {
                            balanceResultMap.forEach((key, val) -> {
                                DynamicObject dy;
                                String[] keys = key.split("-");
                                if (keys.length > 1 && StringUtils.isNotEmpty((CharSequence)keys[0]) && StringUtils.isNotEmpty((CharSequence)keys[1]) && EmptyUtil.isNoEmpty((DynamicObject)(dy = (DynamicObject)idAndCurrencyMap.get(Long.parseLong(keys[1])))) && EmptyUtil.isNoEmpty((BigDecimal)val)) {
                                    DynamicObject currency = dy.getDynamicObject(F_BASE_DATA_ID);
                                    this.addCardEntry(entryKey, itemType, itemName, currency.getString("sign") + TmcBusinessBaseHelper.formatDecimal((BigDecimal)val, (int)currency.getInt("amtprecision")), false);
                                    beiBalanceEmpty.set(false);
                                }
                            });
                        }
                    }
                    if (!beiBalanceEmpty.get()) continue block6;
                    this.addCardEntry(entryKey, itemType, itemName, "0", true);
                    continue block6;
                }
                case BEI_TRANS_DETAIL: {
                    QFilter transDetailsNotMatchFilter = new QFilter("receredtype", "=", (Object)"0");
                    transDetailsNotMatchFilter.or(new QFilter("ismatchereceipt", "=", (Object)"0"));
                    transDetailsNotMatchFilter.or(new QFilter("isdowntobankstate", "=", (Object)"0"));
                    Object[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)ID, (QFilter[])new QFilter[]{accountFilter, transDetailsNotMatchFilter});
                    this.addCardEntry(entryKey, itemType, itemName, MessageFormat.format(showText, details.length + ""), EmptyUtil.isEmpty((Object[])details));
                    continue block6;
                }
                case BEI_ELECT_RECEIPT: {
                    Object[] electReceipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)ID, (QFilter[])new QFilter[]{accountFilter, new QFilter("ismatch", "=", (Object)"0")});
                    this.addCardEntry(entryKey, itemType, itemName, MessageFormat.format(showText, electReceipts.length + ""), EmptyUtil.isEmpty((Object[])electReceipts));
                    continue block6;
                }
            }
        }
        this.getView().updateView("balanceentry");
    }

    private void loadInBusinessCard() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return;
        }
        String showText = ResManager.loadKDString((String)"{0}\u5f20", (String)"BankAcctManageTransferEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]);
        IPageCache pageCache = this.getPageCache();
        Object bankAccountId = bankAccount.getPkValue();
        String entryKey = "inbusinessentry";
        DynamicObjectCollection cardEntries = dataEntity.getDynamicObjectCollection(entryKey);
        cardEntries.clear();
        DynamicObject inBusinessConfig = BusinessDataServiceHelper.loadSingle((String)"am_inbusiness_checkconfig", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty((DynamicObject)inBusinessConfig) || EmptyUtil.isEmpty((DynamicObjectCollection)inBusinessConfig.getDynamicObjectCollection("entryentity"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inbusinessflexpanelap"});
            return;
        }
        DynamicObjectCollection checkList = inBusinessConfig.getDynamicObjectCollection("entryentity");
        HashMap cacheMap = new HashMap(8);
        for (DynamicObject checkInfo : checkList) {
            String accountKeys = checkInfo.getString("entityfieldkey");
            String entityName = checkInfo.getDynamicObject("billentity").getString("number");
            try {
                ArrayList cacheFilterStringList = new ArrayList(10);
                String[] accountKeyArray = accountKeys.split(",");
                QFilter accountQFilter = new QFilter(accountKeyArray[0], "=", bankAccountId);
                if (accountKeyArray.length > 1) {
                    for (int i = 1; i < accountKeyArray.length; ++i) {
                        accountQFilter.or(accountKeyArray[i], "=", bankAccountId);
                    }
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
                qFilterList.add(accountQFilter);
                String condition = checkInfo.getString("savecondition_tag");
                if (EmptyUtil.isNoEmpty((String)condition)) {
                    CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
                    ConditionFactory conditionFactory = new ConditionFactory();
                    ConvertContext context = new ConvertContext();
                    BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
                    context.setSourceMainType(srcMainType);
                    ConvertRuleElement rule = new ConvertRuleElement();
                    rule.setRunCondition(targetCondition);
                    SingleRuleContext ruleContext = new SingleRuleContext();
                    ruleContext.setContext(context);
                    ruleContext.setRule(rule);
                    ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
                    ruleContext.setRuleCompiler(ruleCompiler);
                    conditionFactory.init(context, ruleContext);
                    CRConditionCompiler runCondCompiler = ruleContext.getRuleCompiler().compileRunCondition();
                    qFilterList.addAll(runCondCompiler.getGridQFilters());
                }
                qFilterList.forEach(f -> cacheFilterStringList.add(f.toSerializedString()));
                cacheMap.put(entityName, cacheFilterStringList);
                Object[] businessBills = TmcDataServiceHelper.load((String)entityName, (String)ID, (QFilter[])qFilterList.toArray(new QFilter[0]));
                this.addCardEntry(entryKey, entityName, checkInfo.getString("checkname"), MessageFormat.format(showText, businessBills.length + ""), EmptyUtil.isEmpty((Object[])businessBills));
            }
            catch (Exception e) {
                LOGGER.error("\u68c0\u67e5\u94f6\u884c\u8d26\u6237\u4f7f\u7528\u60c5\u51b5-\u6839\u636e\u5728\u9014\u6570\u636e\u6e05\u5355\u5217\u8868\u7684\u914d\u7f6e\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u5931\u8d25\u3002", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u5728\u9014\u6570\u636e\u6e05\u5355\u5217\u8868\u7684\u914d\u7f6e\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u4e1a\u52a1\u5355\u636e\uff1a{0}\uff0c\u8d26\u6237\u5b57\u6bb5\u540d\uff1a{1}\u3002", (String)"BankAcctManageTransferEdit_12", (String)"tmc-am-formplugin", (Object[])new Object[]{checkInfo.getDynamicObject("billentity").getString("name"), accountKeys}));
                this.addCardEntry(entryKey, entityName, checkInfo.getString("checkname"), MessageFormat.format(showText, "0"), false);
            }
        }
        pageCache.put("checkInfoResult", JSON.toJSONString(cacheMap));
        this.getView().updateView("inbusinessentry");
    }

    private void processControlVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)dataEntity.getString("billstatus"), (CharSequence)BillStatusEnum.SAVE.getValue())), new String[]{"btn_balance_refresh", "btn_casfi_refresh", "btn_inbusiness_refresh"});
    }

    private void processBaseInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkValue = customParams.get(ID);
        if (EmptyUtil.isEmpty(pkValue)) {
            return;
        }
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingle(pkValue, (String)"bd_accountbanks");
        DynamicObject company = bankAcct.getDynamicObject("company");
        IDataModel model = this.getModel();
        model.setValue("originorg", company.getPkValue());
        model.setValue("accountbank", bankAcct.getPkValue());
        model.setValue("transferor", (Object)RequestContext.get().getCurrUserId());
    }

    private void addOrgF7SelectListener() {
        BasedataEdit org = (BasedataEdit)this.getControl("targetorg");
        if (EmptyUtil.isNoEmpty((Object)org)) {
            org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                String entityName = this.getModel().getDataEntityType().getName();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
                DynamicObject originOrg = dataEntity.getDynamicObject("originorg");
                if (EmptyUtil.isNoEmpty((DynamicObject)originOrg)) {
                    orgIdSet.remove(originOrg.getLong(ID));
                }
                showParameter.setCustomParam("range", (Object)orgIdSet);
            });
        }
    }

    private void addCardEntryHyperClickListener() {
        CardEntry cardEntry = (CardEntry)this.getControl("balanceentry");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        CardEntry casFiCardEntry = (CardEntry)this.getControl("casfientry");
        casFiCardEntry.addHyperClickListener((HyperLinkClickListener)this);
        CardEntry inBusinessCardEntry = (CardEntry)this.getControl("inbusinessentry");
        inBusinessCardEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void showRelaBillForm(String entityName) {
        Map checkInfoResultMap;
        List qFilterStringList;
        String checkInfoResult = this.getPageCache().get("checkInfoResult");
        if (EmptyUtil.isNoEmpty((String)checkInfoResult) && EmptyUtil.isNoEmpty((Object)(qFilterStringList = (List)(checkInfoResultMap = (Map)JSON.parseObject((String)checkInfoResult, (TypeReference)new TypeReference<Map<String, List<String>>>(){}, (Feature[])new Feature[0])).get(entityName)))) {
            List qFilters = qFilterStringList.stream().map(QFilter::fromSerializedString).collect(Collectors.toList());
            IFormView view = this.getView();
            FormShowParameter currentViewForm = view.getFormShowParameter();
            ListShowParameter sp = new ListShowParameter();
            sp.setFormId("bos_list");
            sp.setBillFormId(entityName);
            List filters = sp.getListFilterParameter().getQFilters();
            filters.addAll(qFilters);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.setAppId(currentViewForm.getAppId());
            sp.setParentFormId(currentViewForm.getFormId());
            sp.setCustomParam("isTrack", (Object)true);
            view.showForm((FormShowParameter)sp);
        }
    }

    private void showListFrom(String entityName) {
        IFormView view = this.getView();
        FormShowParameter currentViewForm = view.getFormShowParameter();
        FormShowParameter formShowParameter = this.createFormShowParameter(entityName);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setAppId(currentViewForm.getAppId());
        formShowParameter.setParentFormId(currentViewForm.getFormId());
        formShowParameter.setCustomParams(this.createCustomParams(entityName));
        view.showForm(formShowParameter);
    }

    private Map<String, Object> createCustomParams(String entityName) {
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bankAccount = dataEntity.getDynamicObject("accountbank");
        Date transferDate = dataEntity.getDate("transferdate");
        DynamicObject org = dataEntity.getDynamicObject("originorg");
        switch (entityName) {
            case "cas_bankjournalformrpt": {
                customParamMap.put("queryorgtype", "org");
                customParamMap.put("org", org.getPkValue());
                Date date = dataEntity.getDate("transferdate");
                customParamMap.put("periodId", PeriodHelper.getPeriodId((long)org.getLong(ID), (Date)date));
                customParamMap.put("periodtype", PeriodHelper.getPeriodTypeId((long)org.getLong(ID)));
                break;
            }
            case "bei_bankbalance": {
                customParamMap.put("company", "");
                customParamMap.put("bizDateRange", "");
                break;
            }
            case "bei_transdetail": 
            case "bei_elecreceipt": {
                customParamMap.put("company", bankAccount.getDynamicObject("company").getPkValue());
                break;
            }
            case "cas_bankvccheck": {
                customParamMap.put("org", bankAccount.getDynamicObject("company").getPkValue());
                customParamMap.put("bizdate", CompareTypeEnum.THISMONTH.getId());
                break;
            }
            case "cas_balanceadjust": {
                Date bizDate = DateUtils.getLastMonth((Date)dataEntity.getDate("transferdate"), (int)1);
                Long periodId = PeriodHelper.getPeriodId((long)org.getLong(ID), (Date)bizDate);
                customParamMap.put("org", org.getPkValue());
                if (!EmptyUtil.isNoEmpty((Long)periodId)) break;
                customParamMap.put("periodId", periodId);
            }
        }
        customParamMap.put("accountbank", bankAccount.getPkValue());
        customParamMap.put("fromAccountTrade", "1");
        return customParamMap;
    }

    private FormShowParameter createFormShowParameter(String entityName) {
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"cas_bankjournalformrpt")) {
            ReportShowParameter formShowParameter = new ReportShowParameter();
            formShowParameter.setFormId(entityName);
            return formShowParameter;
        }
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("bos_list");
        formShowParameter.setBillFormId(entityName);
        this.setListFromShowQFilters(entityName, formShowParameter);
        return formShowParameter;
    }

    private void setListFromShowQFilters(String entityName, ListShowParameter formShowParameter) {
        List filters = formShowParameter.getListFilterParameter().getQFilters();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date transferDate = dataEntity.getDate("transferdate");
        switch (entityName) {
            case "bei_transdetail": {
                QFilter transDetailsNotMatchFilter = new QFilter("receredtype", "=", (Object)"0");
                transDetailsNotMatchFilter.or(new QFilter("ismatchereceipt", "=", (Object)"0"));
                transDetailsNotMatchFilter.or(new QFilter("isdowntobankstate", "=", (Object)"0"));
                filters.add(transDetailsNotMatchFilter);
                break;
            }
            case "bei_elecreceipt": {
                filters.add(new QFilter("ismatch", "=", (Object)"0"));
                break;
            }
            case "bei_bankbalance": {
                filters.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)transferDate, (boolean)false)));
            }
        }
    }

    private void addCardEntry(String entryKey, String itemType, String itemName, String checkResult, boolean checkFlag) {
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity(entryKey);
        DynamicObject dynamicObject = cardEntities.addNew();
        String fieldKey = "";
        switch (entryKey) {
            case "inbusinessentry": {
                dynamicObject.set("ib_checktype", (Object)itemType);
                dynamicObject.set("ib_checkname", (Object)itemName);
                dynamicObject.set("ib_checkresult", (Object)checkResult);
                dynamicObject.set("ib_checkflag", (Object)checkFlag);
                fieldKey = "ib_checkresult";
                break;
            }
            case "balanceentry": {
                dynamicObject.set("be_checktype", (Object)itemType);
                dynamicObject.set("be_checkname", (Object)itemName);
                dynamicObject.set("be_checkresult", (Object)checkResult);
                dynamicObject.set("be_checkflag", (Object)checkFlag);
                fieldKey = "be_checkresult";
                break;
            }
            case "casfientry": {
                dynamicObject.set("cf_checktype", (Object)itemType);
                dynamicObject.set("cf_checkname", (Object)itemName);
                dynamicObject.set("cf_checkresult", (Object)checkResult);
                dynamicObject.set("cf_checkflag", (Object)checkFlag);
                fieldKey = "cf_checkresult";
            }
        }
        this.setControlCssStyle(entryKey, fieldKey, cardEntities.size() - 1, checkFlag);
    }

    private void processControlCssStyle() {
        this.processControlCssStyle("inbusinessentry");
        this.processControlCssStyle("balanceentry");
        this.processControlCssStyle("casfientry");
    }

    private void processControlCssStyle(String entryKey) {
        DynamicObjectCollection cardEntities = this.getModel().getEntryEntity(entryKey);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)cardEntities)) {
            return;
        }
        String fieldKey = "";
        String flagKey = "";
        switch (entryKey) {
            case "inbusinessentry": {
                fieldKey = "ib_checkresult";
                flagKey = "ib_checkflag";
                break;
            }
            case "balanceentry": {
                fieldKey = "be_checkresult";
                flagKey = "be_checkflag";
                break;
            }
            case "casfientry": {
                fieldKey = "cf_checkresult";
                flagKey = "cf_checkflag";
            }
        }
        for (int i = 0; i < cardEntities.size(); ++i) {
            this.setControlCssStyle(entryKey, fieldKey, i, ((DynamicObject)cardEntities.get(i)).getBoolean(flagKey));
        }
        this.getView().updateView(entryKey);
    }

    private void setControlCssStyle(String entryKey, String fieldKey, int index, boolean checkFlag) {
        CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
        HashMap customProMap = new HashMap(8);
        HashMap<String, String> controlProMap = new HashMap<String, String>(8);
        controlProMap.put("fc", checkFlag ? COLOR_BLUE : COLOR_RED);
        customProMap.put(fieldKey, controlProMap);
        cardEntry.setCustomProperties(entryKey, index, customProMap);
    }
}

