/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct.management;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class BankAcctManageTransferList
extends AbstractTmcDataBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List columnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : columnList) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"originorg.id")) continue;
            filterColumn.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        IFormView view = this.getView();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow rows = billList.getCurrentSelectedRowInfo();
        DynamicObject bankAcctManage = null;
        if (EmptyUtil.isNoEmpty((Object)rows)) {
            Object rowID = rows.getPrimaryKeyValue();
            bankAcctManage = BusinessDataServiceHelper.loadSingle((String)"am_management_transfer", (String)"id,accountbank,transferdate", (QFilter[])new QFilter("id", "=", rowID).toArray());
        }
        if (bankAcctManage == null) {
            args.setCancel(true);
            return;
        }
        switch (opKey) {
            case "submit": {
                String tipsCheckInfo = this.verifyErrorCheckInfo(bankAcctManage);
                OperateOption option = op.getOption();
                if (EmptyUtil.isNoEmpty((String)tipsCheckInfo)) {
                    String msg = ResManager.loadKDString((String)"\u8d26\u6237\u4f7f\u7528\u60c5\u51b5\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"BankAcctManageTransferEdit_10", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                    view.showConfirm(msg, tipsCheckInfo, MessageBoxOptions.OK, ConfirmTypes.Save, null);
                    args.setCancel(true);
                    return;
                }
                tipsCheckInfo = this.verifyTipsCheckInfo(bankAcctManage);
                if (!EmptyUtil.isNoEmpty((String)tipsCheckInfo) || option.containsVariable("confirmVerify")) break;
                String msg = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u9192", (String)"BankAcctManageTransferEdit_11", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
                btnNameMaps.put(6, ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"BankAcctManageTransferEdit_6", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(7, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BankAcctManageTransferEdit_7", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                view.showConfirm(msg, tipsCheckInfo, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("tipsConfirmCallBack", (IFormPlugin)this), btnNameMaps);
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean checkBalance(DynamicObject row) {
        DynamicObject bankAccount = row.getDynamicObject("accountbank");
        Long bankAccountId = bankAccount.getLong("id");
        DynamicObjectCollection currencies = bankAccount.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
            for (DynamicObject dy : currencies) {
                DynamicObject currency = dy.getDynamicObject("fbasedataid");
                BigDecimal balance = Constants.ZERO;
                try {
                    balance = CasBusinessHelper.getBalanceFormCas((long)bankAccount.getDynamicObject("company").getLong("id"), (long)bankAccountId, (long)currency.getLong("id"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (balance.compareTo(Constants.ZERO) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean missBalanceAdjust(DynamicObject row) {
        Date transferDate;
        Date bizDate;
        DynamicObject bankAccount = row.getDynamicObject("accountbank");
        boolean haveBalanceAdjust = BankAcctHelper.checkMissBalanceAdjust((DynamicObject)bankAccount, (Date)(bizDate = DateUtils.getLastMonth((Date)row.getDate("transferdate"), (int)1)), (Date)(transferDate = row.getDate("transferdate")));
        return !haveBalanceAdjust;
    }

    private String verifyTipsCheckInfo(DynamicObject row) {
        boolean balanceAdjustCheck;
        StringBuilder tips = new StringBuilder();
        if (this.checkBalance(row)) {
            tips.append(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u4f59\u989d\u4e0d\u4e3a0\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u7ed3\u8f6c\u4f59\u989d\u5230\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"BankAcctManageTransferEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (balanceAdjustCheck = this.missBalanceAdjust(row)) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868\u5b58\u5728\u7f3a\u5931\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u5b8c\u6210\u540e\u539f\u7ec4\u7ec7\u65e0\u6cd5\u7ee7\u7eed\u5904\u7406\u8be5\u8d26\u6237\u7684\u76f8\u5173\u4e1a\u52a1\u3002", (String)"BankAcctManageTransferEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (tips.length() > 0) {
            tips.append("\r\n").append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002", (String)"BankAcctManageTransferEdit_13", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        return tips.toString();
    }

    private boolean verifyCheckUndoInfo(DynamicObject row) {
        DynamicObject bankAccount = row.getDynamicObject("accountbank");
        Long bankAccountId = bankAccount.getLong("id");
        DynamicObject inBusinessConfig = BusinessDataServiceHelper.loadSingle((String)"am_inbusiness_checkconfig", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty((DynamicObject)inBusinessConfig) || EmptyUtil.isEmpty((DynamicObjectCollection)inBusinessConfig.getDynamicObjectCollection("entryentity"))) {
            return false;
        }
        DynamicObjectCollection checkList = inBusinessConfig.getDynamicObjectCollection("entryentity");
        boolean isExistBusiness = false;
        for (DynamicObject checkInfo : checkList) {
            String accountKeys = checkInfo.getString("entityfieldkey");
            String entityName = checkInfo.getDynamicObject("billentity").getString("number");
            try {
                ArrayList cacheFilterStringList = new ArrayList(10);
                String[] accountKeyArray = accountKeys.split(",");
                QFilter accountQFilter = new QFilter(accountKeyArray[0], "=", (Object)bankAccountId);
                if (accountKeyArray.length > 1) {
                    for (int i = 1; i < accountKeyArray.length; ++i) {
                        accountQFilter.or(accountKeyArray[i], "=", (Object)bankAccountId);
                    }
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
                qFilterList.add(accountQFilter);
                String condition = checkInfo.getString("savecondition_tag");
                if (EmptyUtil.isNoEmpty((String)condition)) {
                    CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
                    ConditionFactory conditionFactory = new ConditionFactory();
                    ConvertContext context = new ConvertContext();
                    BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
                    context.setSourceMainType(srcMainType);
                    ConvertRuleElement rule = new ConvertRuleElement();
                    rule.setRunCondition(targetCondition);
                    SingleRuleContext ruleContext = new SingleRuleContext();
                    ruleContext.setContext(context);
                    ruleContext.setRule(rule);
                    ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
                    ruleContext.setRuleCompiler(ruleCompiler);
                    conditionFactory.init(context, ruleContext);
                    CRConditionCompiler runCondCompiler = ruleContext.getRuleCompiler().compileRunCondition();
                    qFilterList.addAll(runCondCompiler.getGridQFilters());
                }
                qFilterList.forEach(f -> cacheFilterStringList.add(f.toSerializedString()));
                Object[] businessBills = TmcDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
                isExistBusiness = isExistBusiness || EmptyUtil.isNoEmpty((Object[])businessBills);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u5728\u9014\u6570\u636e\u6e05\u5355\u5217\u8868\u7684\u914d\u7f6e\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\uff0c\u8d26\u6237\u5b57\u6bb5\u540d\u201c%2$s\u201d\u3002", (String)"BankAcctManageTransferEdit_12", (String)"tmc-am-formplugin", (Object[])new Object[]{checkInfo.getDynamicObject("billentity").getString("name"), accountKeys}));
                return true;
            }
        }
        return isExistBusiness;
    }

    private String verifyErrorCheckInfo(DynamicObject row) {
        boolean journalIsCheck;
        StringBuilder tips = new StringBuilder();
        if (this.verifyCheckUndoInfo(row)) {
            tips.append(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u4e1a\u52a1", (String)"BankAcctManageTransferEdit_8", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        if (!(journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)row.getDynamicObject("accountbank")))) {
            if (tips.length() > 0) {
                tips.append("\r\n");
            }
            tips.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8fbe\u8d26\u9879", (String)"BankAcctManageTransferEdit_9", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
        return tips.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult res = event.getResult();
        IFormView view = this.getView();
        switch (callBackId) {
            case "tipsConfirmCallBack": {
                if (!MessageBoxResult.Yes.equals((Object)res)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("confirmVerify", "1");
                view.invokeOperation("submit", option);
            }
        }
    }
}

