/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.property.FeeDetailEntryProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.feedetail.AbstractBizBillFeeTabEdit;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractAmBizBillFeeEdit
extends AbstractBizBillFeeTabEdit {
    public void setValWithoutDataChanged(IDataModel model, String headOrg, Object value) {
        model.setDataChanged(false);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)headOrg, (Object)value);
    }

    public void afterBindData(EventObject e) {
        boolean loadEntry = BillChangeHistoryHelper.loadEntrysInfo((IFormView)this.getView());
        if (loadEntry) {
            return;
        }
        if (TmcDataServiceHelper.exists((Object)this.getModel().getDataEntity().getPkValue(), (String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            this.loadFeeDetail();
            if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
                this.setFeeEntryEnableByScheme(null);
            }
        }
        ComboEdit feeSource = (ComboEdit)this.getControl("feesource");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(4);
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.HAND.getName()), FeeSourceEnum.HAND.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.BATCHINPUT.getName()), FeeSourceEnum.BATCHINPUT.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.LINKGEN.getName()), FeeSourceEnum.LINKGEN.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.BIZPATCH.getName()), FeeSourceEnum.BIZPATCH.getValue()));
        feeSource.setComboItems(data);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            if (!this.checkFormId() || !BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) continue;
            String mainOrg = this.getModel().getDataEntityType().getMainOrg();
            DynamicObject org = (DynamicObject)this.getModel().getValue(mainOrg);
            Long exchangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)org.getLong("id"));
            if (EmptyUtil.isEmpty((Long)exchangeTableId)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"excrate"});
                continue;
            }
            Pair currencyFieldProp = this.getBizBillCurrencyFieldProp();
            DynamicObject headCur = (DynamicObject)this.getModel().getValue((String)currencyFieldProp.getLeft());
            DynamicObject feeCur = ((DynamicObject)entrys.get(rowIndex)).getDynamicObject("feecurrency");
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)feeCur.getLong("id"), (Long)headCur.getLong("id"), null);
            this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((BigDecimal)exchangeRate) && !feeCur.getPkValue().equals(headCur.getPkValue())), rowIndex, new String[]{"excrate"});
        }
    }

    private boolean checkFormId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return FeeDetailEntryProp.FEENUMER_LIST.contains(formId);
    }

    private void setFeeEntryEnableByScheme(Integer rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (null != rowIndex && rowIndex == i) {
                this.setRowEnable(rowIndex, entry);
                continue;
            }
            if (null != rowIndex) continue;
            this.setRowEnable(i, entry);
        }
    }

    private void setRowEnable(int i, DynamicObject entry) {
        DynamicObject feeScheme = entry.getDynamicObject("feescheme");
        if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"feetype", "feeissettle"});
            String feeCalType = feeScheme.getString("feecaltype");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"feerate"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"feeamt"});
            } else {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"feeamt"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"feerate"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"feetype", "feeamt", "feerate", "feeissettle"});
        }
    }

    public String getOrgField() {
        String orgFiled = "company";
        String billName = this.getView().getEntityId();
        if ("am_businessapply".equalsIgnoreCase(billName) || "am_holdgoodsinfos".equalsIgnoreCase(billName)) {
            orgFiled = "org";
        }
        return orgFiled;
    }
}

