/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.base;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.am.formplugin.base.AbstractAmBizBillFeeEdit;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FeeTabEdit
extends AbstractAmBizBillFeeEdit {
    private static final Log logger = LogFactory.getLog(FeeTabEdit.class);
    private static final String OPERATE_KEY_SUBMIT = "submit";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().deleteEntryData("feedetail");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "feescheme": {
                this.feeSchemeChgEvt(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "feeoppunit": {
                this.oppUnitChgEvt(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "feeoppunittype": {
                super.getModel().setValue("feeoppunittext", null, rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)super.getView(), (IDataModel)super.getModel(), (String)"feeoppacctbank", null, (int)rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)super.getView(), (IDataModel)super.getModel(), (String)"feeoppbebank", null, (int)rowIndex);
                break;
            }
            case "defaultcurrency": {
                DynamicObject defaultCurrency = this.getModel().getDataEntity().getDynamicObject("defaultcurrency");
                if (EmptyUtil.isEmpty((DynamicObject)defaultCurrency)) {
                    return;
                }
                DynamicObjectCollection feeDetail = this.getModel().getEntryEntity("feedetail");
                if (feeDetail == null || feeDetail.size() <= 0) break;
                for (int index = 0; index < feeDetail.size(); ++index) {
                    this.getModel().setValue("feecurrency", defaultCurrency.getPkValue(), index);
                }
                break;
            }
        }
        String key = e.getProperty().getName();
        if ("company".equals(key) && newValue instanceof DynamicObject && newValue != null) {
            this.setValWithoutDataChanged(this.getModel(), "org", this.getModel().getValue("company"));
        }
    }

    private void feeSchemeChgEvt(int rowIndex, DynamicObject feeScheme) {
        boolean schemeNoEmpty = EmptyUtil.isNoEmpty((DynamicObject)feeScheme);
        this.getModel().setValue("feetype", schemeNoEmpty ? feeScheme.getDynamicObject("feetype") : Integer.valueOf(0), rowIndex);
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"feetype"});
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"feerate"});
        if (schemeNoEmpty) {
            this.getModel().setValue("feeissettle", (Object)(!feeScheme.getBoolean("handsettle") ? 1 : 0), rowIndex);
            String feeCalType = feeScheme.getString("feecaltype");
            BigDecimal amt = feeScheme.getBigDecimal("amountrate");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feerate", (Object)amt, (int)rowIndex);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)amt, (int)rowIndex);
            }
        } else {
            this.getModel().setValue("feeissettle", (Object)Boolean.FALSE, rowIndex);
            this.getModel().setValue("feetype", null, rowIndex);
            this.getModel().setValue("feeamt", null, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.refreshDataEntityState();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if (!"feedetail".equals(entryName)) {
            return;
        }
        DynamicObject baseCurrency = null;
        boolean hasDefaultCurrency = this.getModel().getDataEntity().containsProperty("defaultcurrency");
        if (hasDefaultCurrency) {
            baseCurrency = this.getModel().getDataEntity().getDynamicObject("defaultcurrency");
        } else {
            DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject(this.getOrgField());
            if (EmptyUtil.isEmpty((DynamicObject)companyDO)) {
                return;
            }
            baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()));
        }
        if (EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            return;
        }
        for (RowDataEntity row : e.getRowDataEntities()) {
            int index = row.getRowIndex();
            if (index < 0) continue;
            this.getModel().setValue("feecurrency", baseCurrency.getPkValue(), index);
        }
    }

    @Override
    public String getOrgField() {
        String orgFiled = "company";
        String billName = this.getView().getEntityId();
        if ("am_businessapply".equalsIgnoreCase(billName) || "am_holdgoodsinfos".equalsIgnoreCase(billName)) {
            orgFiled = "org";
        }
        return orgFiled;
    }

    private void oppUnitChgEvt(int rowIndex, DynamicObject oppUnit) {
        if (!EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            return;
        }
        super.getModel().setValue("feeoppunittext", (Object)oppUnit.getString("name"), rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)super.getView(), (IDataModel)super.getModel(), (String)"feeoppacctbank", null, (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)super.getView(), (IDataModel)super.getModel(), (String)"feeoppbebank", null, (int)rowIndex);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setValWithoutDataChanged(this.getModel(), "org", this.getModel().getValue(this.getOrgField()));
    }

    public Pair<String, String> getBizBillFeeAmtFieldProp() {
        return Pair.of((Object)"amount", (Object)"");
    }

    public Pair<String, String> getBizBillCurrencyFieldProp() {
        return Pair.of((Object)"feecurrency", (Object)"");
    }

    private void setValWithoutDataChanged(IDataModel model) {
        model.setDataChanged(false);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"org", (Object)this.getModel().getValue(this.getOrgField()));
    }

    private void refreshDataEntityState() {
        DynamicObjectCollection docs = this.getModel().getEntryEntity("feedetail");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)docs)) {
            return;
        }
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObject doc = (DynamicObject)docs.get(i);
            doc.refreshDataEntityState();
        }
    }
}

