/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.billselect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.am.common.enums.AssociatedTypeEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.OrgHelper;

public class BillSelectEdit
extends AbstractFormPlugin
implements BeforeBindDataListener {
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.size() > 0) {
            this.getModel().setValue("txttype", customParams.get("associatedtype"));
            this.loadListData();
            this.getView().updateView();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.addSetFilterListener(e1 -> {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object objType = customParams.get("associatedtype");
            String type = objType == null ? "" : objType.toString();
            QFilter qFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
            qFilter.and("billtype", "=", (Object)AssociatedTypeEnum.getName((String)type));
            e1.addCustomQFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.equalsIgnoreCase("btnok")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object objType = customParams.get("associatedtype");
            String type = objType == null ? "" : objType.toString();
            DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"am_billinfolist").getDBRouteKey()), (String)"delete from t_am_associatebill where fcreatorid = ?", (Object[])new Object[]{UserServiceHelper.getCurrentUserId()});
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("type", this.getModel().getValue("txttype"));
            ArrayList billNoList = new ArrayList();
            for (ListSelectedRow info : selectedRows) {
                HashMap<String, String> billMap = new HashMap<String, String>();
                billMap.put("billId", info.getNumber());
                billMap.put("billNo", info.getName());
                billNoList.add(billMap);
            }
            returnMap.put("billNoList", billNoList);
            returnMap.put("curIndex", customParams.get("curIndex"));
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private void loadListData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object objType = customParams.get("associatedtype");
        String type = objType == null ? "" : objType.toString();
        String orgId = customParams.get("orgId").toString();
        Long userId = UserServiceHelper.getCurrentUserId();
        DataSet queryResult = null;
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"am_billinfolist").getDBRouteKey()), (String)"delete from t_am_associatebill where fcreatorid = ?", (Object[])new Object[]{UserServiceHelper.getCurrentUserId()});
        switch (type) {
            case "A": {
                queryResult = this.getBankAccInfo(orgId);
                break;
            }
            case "B": {
                queryResult = this.getFinOrgInfo();
                break;
            }
            case "C": {
                queryResult = this.getChequeBookInfo(orgId);
                break;
            }
            case "D": {
                queryResult = this.getCimDepositInfo(orgId);
                break;
            }
            case "E": {
                queryResult = this.getNoticeDepositInfo(orgId);
                break;
            }
            case "F": {
                queryResult = this.getFinSubscribeInfo(orgId);
                break;
            }
            case "G": {
                queryResult = this.getCfmLoancontractBLInfo(orgId);
                break;
            }
            case "H": {
                queryResult = this.getCfmLoancontractICInfo(orgId);
                break;
            }
            case "I": {
                queryResult = this.getGmGuaranteeContractInfo(orgId);
                break;
            }
            case "J": {
                queryResult = this.getGmReceiveLetterInfo(orgId);
                break;
            }
            case "K": {
                queryResult = this.getLcReceiptInfo(orgId);
                break;
            }
        }
        if (queryResult != null) {
            this.fillData(queryResult, type);
        }
    }

    private DataSet getLcReceiptInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"lc_receipt", (String)"id,billno billno,credittype.name propname,creditno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getGmReceiveLetterInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gm_receiveletter", (String)"id,billno billno,guaranteevariety.name propname,contractno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getGmGuaranteeContractInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gm_guaranteecontract", (String)"id,billno billno,guarantee.name propname,guaranteeno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getCfmLoancontractICInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        ArrayList<String> type = new ArrayList<String>();
        type.add("ec");
        type.add("entrust");
        qFilters.and("loantype", "in", type);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loancontractbill", (String)"id,billno billno,contractname propname,contractno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getCfmLoancontractBLInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        ArrayList<String> type = new ArrayList<String>();
        type.add("loan");
        type.add("sl");
        qFilters.and("loantype", "in", type);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_loancontractbill", (String)"id,billno billno,contractname propname,contractno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getFinSubscribeInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_finsubscribe", (String)"id,billno billno,investvarieties.name propname,finaccount propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getNoticeDepositInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        qFilters.and("investvarieties.investtype", "=", (Object)"notice");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_noticedeposit", (String)"id,billno billno,investvarieties.name propname,finaccount propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getCimDepositInfo(String orgId) {
        QFilter qFilters = new QFilter("billstatus", "=", (Object)"C");
        qFilters.and("org", "=", (Object)Long.valueOf(orgId));
        qFilters.and("investvarieties.investtype", "=", (Object)"fixed");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_deposit", (String)"id,billno billno,investvarieties.name propname,finaccount propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getChequeBookInfo(String orgId) {
        QFilter qFilters = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cdm_cheque_book", (String)"id,billno billno,accountbank.name propname,billno propnum,'' propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private DataSet getBankAccInfo(String orgId) {
        List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"am", (String)"am_accountbank", (String)"47150e89000000ac");
        QFilter baseFilter = AccountBankHelper.getAccountBankFilterByOrg((Collection)orgIds);
        QFilter qFilters = new QFilter("acctstatus", "=", (Object)"normal");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"am_accountbank", (String)"id,bankaccountnumber billno,acctname propname,bankaccountnumber propnum,'' propnum1", (QFilter[])new QFilter[]{baseFilter, qFilters}, null);
        return dataSet;
    }

    private DataSet getFinOrgInfo() {
        QFilter qFilters = new QFilter("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_finorginfo", (String)"id,number billno,name propname,union_number propnum,swift_code propnum1", (QFilter[])qFilters.toArray(), null);
        return dataSet;
    }

    private void fillData(DataSet queryResult, String type) {
        if (queryResult != null) {
            Iterator iterator = queryResult.iterator();
            ArrayList<DynamicObject> lstDy = new ArrayList<DynamicObject>();
            while (iterator.hasNext()) {
                Row resultRow = (Row)iterator.next();
                DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"am_billinfolist");
                row.set("billid", resultRow.get("id"));
                row.set("billtype", (Object)AssociatedTypeEnum.getName((String)type));
                row.set("billno", resultRow.get("billno"));
                row.set("propname", resultRow.get("propname"));
                String propNum = (String)resultRow.get("propnum");
                if (propNum.isEmpty()) {
                    row.set("propnum", resultRow.get("propnum1"));
                } else {
                    row.set("propnum", resultRow.get("propnum"));
                }
                row.set("creator", (Object)UserServiceHelper.getCurrentUserId());
                lstDy.add(row);
            }
            if (lstDy.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])lstDy.toArray(new DynamicObject[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"am_billinfolist").getDBRouteKey()), (String)"delete from t_am_associatebill where fcreatorid = ?", (Object[])new Object[]{UserServiceHelper.getCurrentUserId()});
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }
}

