/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.businessapply;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.am.common.enums.AssociateBillTypeEnum;
import kd.tmc.am.common.enums.AssociatedTypeEnum;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusinessApplyEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Integer INDEX = 0;
    private static final Integer INT_ZERO = 0;
    private static final Integer INT_ONE = 1;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryCombo(INT_ZERO);
        this.initObjectDetail();
    }

    public void registerListener(EventObject e) {
        EntryGrid entryEntity;
        super.registerListener(e);
        this.addClickListeners(new String[]{"objecttype", "objectno", "enddate"});
        TextEdit textEdit = (TextEdit)this.getControl("billinfo");
        textEdit.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("objectdetail");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((entryEntity = (EntryGrid)this.getControl("entryentity")) != null) {
            entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.equalsIgnoreCase("billinfo")) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String type = String.valueOf(this.getModel().getValue("associatedtype", currentIndex));
            this.showBillList(type);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        switch (name.toLowerCase(Locale.ROOT)) {
            case "objecttype": {
                this.setEntryCombo(INT_ZERO);
                break;
            }
        }
    }

    private void showBillList(String type) {
        if (type.isEmpty()) {
            return;
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectedBill"));
        formShowParameter.setFormId("am_billselect");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("associatedtype", (Object)type);
        formShowParameter.setCustomParam("curIndex", (Object)currentIndex);
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (orgObj != null) {
            formShowParameter.setCustomParam("orgId", orgObj.getPkValue());
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map resultMap;
        super.closedCallBack(e);
        if ("selectedBill".equals(e.getActionId()) && (resultMap = (Map)e.getReturnData()) != null) {
            int curIndex = (Integer)resultMap.get("curIndex");
            String type = (String)resultMap.get("type");
            List billNoList = (List)resultMap.get("billNoList");
            this.getModel().beginInit();
            int size = billNoList.size();
            for (int i = 0; i < size; ++i) {
                Map billMap = (Map)billNoList.get(i);
                String billNo = (String)billMap.get("billNo");
                String billId = (String)billMap.get("billId");
                this.getModel().setValue("associatedtype", (Object)type, curIndex);
                this.getModel().setValue("billinfo", (Object)billNo, curIndex);
                this.getModel().setValue("billid", (Object)billId, curIndex);
                if (i >= size - 1) continue;
                curIndex = this.getModel().insertEntryRow("entryentity", curIndex + 1);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataModel model = this.getModel();
        Control ce = (Control)evt.getSource();
        int curIndex = evt.getRow();
        String entryname = ce.getKey();
        if (entryname.equalsIgnoreCase("objectdetail")) {
            this.setEntryCombo(curIndex);
        }
    }

    private void setEntryCombo(int curIndex) {
        DynamicObject objectType = null;
        objectType = curIndex > INT_ZERO ? (DynamicObject)this.getModel().getValue("objecttype", curIndex) : (DynamicObject)this.getModel().getValue("objecttype");
        if (objectType == null) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("associatedtype");
            comboEdit.setComboItems(null);
            return;
        }
        String multyCombo = (String)objectType.get("associatedtype");
        if (multyCombo.isEmpty()) {
            return;
        }
        String[] comboArr = multyCombo.split(",");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        for (String item : comboArr) {
            if (item.isEmpty()) continue;
            data.add(new ComboItem(new LocaleString(AssociatedTypeEnum.getName((String)item)), item));
        }
        if (data.toArray().length > INT_ZERO) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("associatedtype");
            comboEdit.setComboItems(data);
        }
    }

    private void checkEndDate() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null || endDate == null) {
            return;
        }
        if (startDate.after(endDate)) {
            this.getModel().setValue("enddate", (Object)"");
            String message = ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"BusinessApplyEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
    }

    public void initObjectDetail() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("objectdetail");
        if (EmptyUtil.isEmpty((Object)entryGrid)) {
            return;
        }
        DynamicObjectCollection docs = this.getModel().getEntryEntity("objectdetail");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)docs)) {
            return;
        }
        if (docs.size() > INT_ONE) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)docs.get(INT_ZERO.intValue());
        String objectType = dynamicObject.getString("objecttype");
        String objectNo = dynamicObject.getString("objectno");
        String objectName = dynamicObject.getString("objectname");
        String explain = dynamicObject.getString("explain");
        Object authority = dynamicObject.get("authority");
        Date endDate = dynamicObject.getDate("enddate");
        Object keeper = dynamicObject.get("keeper");
        MulBasedataDynamicObjectCollection mbdoc = (MulBasedataDynamicObjectCollection)dynamicObject.get("attachment");
        Boolean getNotEmpty = this.isNotEmpty(objectType, objectNo, objectName, explain, authority, endDate, keeper, mbdoc);
        if (getNotEmpty.booleanValue()) {
            return;
        }
        this.getModel().deleteEntryData("objectdetail");
        docs.addNew();
        this.getModel().setValue("startdate", (Object)new Date(), INDEX.intValue());
        this.getView().updateView("objectdetail");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        this.getModel().deleteEntryData("entryentity");
        entity.addNew();
        this.getView().updateView("entryentity");
    }

    private Boolean isNotEmpty(Object ... objects) {
        Boolean result = Boolean.FALSE;
        for (Object object : objects) {
            if (!EmptyUtil.isNoEmpty((Object)object)) continue;
            result = Boolean.TRUE;
            break;
        }
        return result;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billinfo".equals(key)) {
            int currentRowIndex = e.getRowIndex();
            String billType = (String)this.getModel().getValue("associatedtype", currentRowIndex);
            String entityName = AssociateBillTypeEnum.valueOf((String)billType).getValue();
            String billNo = (String)this.getModel().getValue("billinfo", currentRowIndex);
            String strBillId = (String)this.getModel().getValue("billid", currentRowIndex);
            long billId = 0L;
            billId = EmptyUtil.isEmpty((String)strBillId) ? AmCommonHelper.getBillIdByBillNo((String)entityName, (String)billNo) : Long.parseLong(strBillId);
            if (billId <= 0L) {
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId(entityName);
            bsp.setPkId((Object)billId);
            bsp.setStatus(OperationStatus.VIEW);
            bsp.getOpenStyle().setShowType("cdm_cheque_book".equalsIgnoreCase(bsp.getFormId()) ? ShowType.Modal : ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }
}

