/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.changeapply;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;

public class ChangeApplyConfigEdit
extends AbstractBillPlugIn {
    private static final String HEAD_SHOWFIELDS = "showfields";
    private static final String HEAD_COMPANY = "company";
    private static final String HEAD_SHOWFIELDSDESC = "showfieldsdesc";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{HEAD_SHOWFIELDS});
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue(HEAD_COMPANY, (Object)RequestContext.get().getOrgId());
        this.initBillBusinessFieldComboEditControl();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (HEAD_SHOWFIELDS.equals(key)) {
            if (ObjectUtils.isEmpty((Object)newValue)) {
                this.getModel().setValue(HEAD_SHOWFIELDSDESC, (Object)"");
                return;
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
            Map allFields = dataEntityType.getAllFields();
            String[] selectFields = newValue.toString().split(",");
            StringBuilder showFields = new StringBuilder();
            for (String selectField : selectFields) {
                if (StringUtils.isEmpty((CharSequence)selectField)) continue;
                showFields.append(((IDataEntityProperty)allFields.get(selectField)).getDisplayName()).append("\uff1b");
            }
            this.getModel().setValue(HEAD_SHOWFIELDSDESC, (Object)showFields.substring(0, showFields.lastIndexOf("\uff1b")));
        }
    }

    private void initBillBusinessFieldComboEditControl() {
        ComboEdit businessBillComboEdit = (ComboEdit)this.getControl(HEAD_SHOWFIELDS);
        Map<String, LocaleString> fieldColumn = this.getFields();
        ArrayList<ComboItem> businessBillComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
        for (Map.Entry<String, LocaleString> entry : fieldColumn.entrySet()) {
            LocaleString displayName = entry.getValue();
            String key = entry.getKey();
            ComboItem comboItem = new ComboItem();
            if ("closedate".equals(key) || "createorg".equals(key)) continue;
            if ("managecurrency".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u5e01\u79cd", (String)"ChangeApplyEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0])));
                comboItem.setValue(key);
            } else if ("acctmanageamt".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u91d1\u989d", (String)"ChangeApplyEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0])));
                comboItem.setValue(key);
            } else {
                comboItem.setCaption(displayName);
                comboItem.setValue(key);
            }
            businessBillComboItemList.add(comboItem);
        }
        businessBillComboEdit.setComboItems(businessBillComboItemList);
    }

    private Map<String, LocaleString> getFields() {
        String businessBill = "am_accountbank";
        Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])new String[0]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Set keySet = ((EntityType)dataEntityType.getAllEntities().get(businessBill)).getFields().keySet();
        return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

