/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.closeacct;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctCloseEdit
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(BankAcctCloseEdit.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"recbill", "paybill", "agentpaybill"});
    }

    public void afterCreateNewData(EventObject e) {
        Object billstatus;
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        model.setValue("applier", (Object)RequestContext.get().getUserId());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject bankAcctStr = (JSONObject)customParams.get("accountbank");
        if (null != bankAcctStr) {
            model.setValue("accountbank", bankAcctStr.get((Object)"id"));
            JSONObject company = (JSONObject)bankAcctStr.get((Object)"company");
            model.setValue("company", company.get((Object)"id"));
        }
        if (null != (billstatus = model.getValue("billstatus")) && BillStatusEnum.SAVE.getValue().equals(billstatus)) {
            ((DateEdit)this.getControl("closedate")).setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"comment", "closedate"});
        }
        this.showDeftCurrency();
        this.showOther();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterBindData(EventObject e) {
        Object scene;
        super.afterBindData(e);
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject closeBill = model.getDataEntity();
        String billstatus = closeBill.getString("billstatus");
        Date closeDate = closeBill.getDate("closedate");
        if (null != billstatus && BillStatusEnum.HANDLE.getValue().equals(billstatus)) {
            ((DateEdit)this.getControl("closedate")).setMustInput(true);
        }
        if ((scene = this.getView().getFormShowParameter().getCustomParam("SCENE")) != null && scene.equals("AUDITFLOW") && BillStatusEnum.HANDLE.getValue().equals(billstatus)) {
            if (EmptyUtil.isEmpty((Object)closeDate)) {
                model.setValue("closedate", (Object)DateUtils.getCurrentDate());
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"closedate"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"closedate"});
        }
        if (BillStatusEnum.REVIEW.getValue().equals(billstatus) || BillStatusEnum.HANDLE.getValue().equals(billstatus) || BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"closedate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"closedate"});
        }
        this.loadAcctCheckInfo();
        this.initToolButtonStatus();
        this.showDeftCurrency();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operationkey = source.getKey();
        DynamicObject bankAcct = (DynamicObject)this.getModel().getDataEntity().get("accountbank");
        if (bankAcct == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5728\u9014\u4e1a\u52a1\u5355\u636e", (String)"BankAcctCloseEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return;
        }
        Object bankAcctId = bankAcct.getPkValue();
        switch (operationkey) {
            case "paybill": {
                BankAcctHelper.showRelBillList((String)"cas_paybill", (Object)bankAcctId, (AbstractFormPlugin)this);
                break;
            }
            case "recbill": {
                BankAcctHelper.showRelBillList((String)"cas_recbill", (Object)bankAcctId, (AbstractFormPlugin)this);
                break;
            }
            case "agentpaybill": {
                BankAcctHelper.showRelBillList((String)"cas_agentpaybill", (Object)bankAcctId, (AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        IDataModel model = this.getModel();
        Date currentDate = DateUtils.getCurrentDate();
        switch (propName) {
            case "closedate": {
                DynamicObject bankAcct;
                Date openDate;
                if (EmptyUtil.isEmpty((Object)propValue)) break;
                Date bizDate = (Date)propValue;
                if (bizDate.after(currentDate)) {
                    this.getView().showTipNotification(new AmBizResource().getClosedateError());
                    model.setValue("closedate", (Object)currentDate);
                }
                if (!EmptyUtil.isNoEmpty((Object)(openDate = DateUtils.getDataFormat((Date)(bankAcct = model.getDataEntity().getDynamicObject("accountbank")).getDate("opendate"), (boolean)true))) || !bizDate.before(openDate)) break;
                this.getView().showTipNotification(new AmBizResource().getClosedateBeforopendate());
                model.setValue("closedate", (Object)currentDate);
                break;
            }
        }
    }

    private void loadAcctCheckInfo() {
        DynamicObject bankAcct = (DynamicObject)this.getModel().getDataEntity().get("accountbank");
        if (null == bankAcct) {
            return;
        }
        Long bankAcctId = bankAcct.getLong("id");
        Map recBill = BankAcctHelper.loadRelBill((String)"cas_recbill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)recBill)) {
            ((Image)this.getView().getControl("recbillimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        ((Label)this.getControl("recbill")).setText(String.format(ResManager.loadKDString((String)"%s\u5f20", (String)"BankAcctCloseEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), recBill.size()));
        Map payBill = BankAcctHelper.loadRelBill((String)"cas_paybill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)payBill)) {
            ((Image)this.getView().getControl("paybillimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        ((Label)this.getControl("paybill")).setText(String.format(ResManager.loadKDString((String)"%s\u5f20", (String)"BankAcctCloseEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), payBill.size()));
        Map agentPayBills = BankAcctHelper.loadRelBill((String)"cas_agentpaybill", (Object)bankAcctId);
        if (!CollectionUtils.isEmpty((Map)agentPayBills)) {
            ((Image)this.getView().getControl("agentpayimg")).setUrl("/icons/pc/state/warning34_34.png");
        }
        ((Label)this.getControl("agentpaybill")).setText(String.format(ResManager.loadKDString((String)"%s\u5f20", (String)"BankAcctCloseEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), agentPayBills.size()));
        DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
        StringBuilder sb = new StringBuilder();
        if (null != currencys) {
            for (int i = 0; i < currencys.size(); ++i) {
                DynamicObject currency = ((DynamicObject)currencys.get(i)).getDynamicObject("fbasedataid");
                BigDecimal balance = Constants.ZERO;
                try {
                    balance = CasBusinessHelper.getBalanceFormCas((long)bankAcct.getDynamicObject("company").getLong("id"), (long)bankAcctId, (long)currency.getLong("id"));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                if (balance.compareTo(Constants.ZERO) == 0) continue;
                if (sb.length() != 0) {
                    sb.append(" | ");
                }
                sb.append(currency.getString("sign")).append(TmcBusinessBaseHelper.formatDecimal((BigDecimal)balance, (int)currency.getInt("amtprecision")));
            }
        }
        if (sb.length() != 0) {
            ((Image)this.getView().getControl("daybillimg")).setUrl("/icons/pc/state/warning34_34.png");
        } else {
            sb.append('0');
        }
        ((Label)this.getControl("casmount")).setText(sb.toString());
        boolean journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)bankAcct);
        if (!journalIsCheck) {
            ((Image)this.getView().getControl("unreachimg")).setUrl("/icons/pc/state/warning34_34.png");
            ((Label)this.getControl("unreachmount")).setText(ResManager.loadKDString((String)"\u6709", (String)"BankAcctCloseEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        } else {
            ((Label)this.getControl("unreachmount")).setText(ResManager.loadKDString((String)"\u65e0", (String)"BankAcctCloseEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
    }

    private void initToolButtonStatus() {
        DynamicObject openBill = this.getModel().getDataEntity();
        String billstatus = openBill.getString("billstatus");
        if (billstatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viewflow,bar_unsubmit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_viewflow", "bar_unsubmit"});
        }
    }

    private void showDeftCurrency() {
        DynamicObject closeBill = this.getModel().getDataEntity();
        DynamicObject bankAcct = closeBill.getDynamicObject("accountbank");
        if (null == bankAcct) {
            return;
        }
        DynamicObjectCollection currency = bankAcct.getDynamicObjectCollection("currency");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)currency) && currency.size() > 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        }
    }

    private void showOther() {
        DynamicObject closeBill = this.getModel().getDataEntity();
        DynamicObject bankAcct = closeBill.getDynamicObject("accountbank");
        if (null == bankAcct) {
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)(bankAcct = BusinessDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"am_accountbank")))) {
            return;
        }
        Date closeDate = bankAcct.getDate("closedatef");
        String authorizeInfo = bankAcct.getString("authorizeinfo");
        String fundAccFlag = bankAcct.getString("fundaccflag");
        this.getModel().setValue("closedatef", (Object)closeDate);
        this.getModel().setValue("authorizeinfo", (Object)authorizeInfo);
        this.getModel().setValue("fundaccflag", (Object)fundAccFlag);
        this.getModel().setValue("enteraccount", (Object)bankAcct.getDynamicObject("enteraccount"));
        DynamicObjectCollection netBankGrantEntity = bankAcct.getDynamicObjectCollection("netbankgrantentity");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("netbankgrantentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)netBankGrantEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)rows)) {
            for (DynamicObject bankGrant : netBankGrantEntity) {
                DynamicObject row = rows.addNew();
                row.set("netgrant", bankGrant.get("netgrant"));
                row.set("operator", bankGrant.get("operator"));
                row.set("goods", bankGrant.get("goods"));
                row.set("netgrantcur", bankGrant.get("netgrantcur"));
                row.set("approvedamount", bankGrant.get("approvedamount"));
            }
        }
        DynamicObjectCollection entrySigNetEntity = bankAcct.getDynamicObjectCollection("entrysignetentity");
        DynamicObjectCollection sigNetRows = this.getModel().getEntryEntity("entrysignetentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrySigNetEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)sigNetRows)) {
            for (DynamicObject bankGrant : entrySigNetEntity) {
                DynamicObject row = sigNetRows.addNew();
                row.set("signettype", bankGrant.get("signettype"));
                row.set("signetname", bankGrant.get("signetname"));
                row.set("signetkeeper", bankGrant.get("signetkeeper"));
            }
        }
    }
}

