/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.closeacct;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcImportPlugin;

public class BankAcctCloseImportPlugin
extends AbstractTmcImportPlugin {
    public void validate(Map<String, Object> data) {
        JSONObject acctJsonInfo = (JSONObject)data.get("accountbank");
        String acctNumber = acctJsonInfo.getString("number");
        if (EmptyUtil.isNoEmpty((String)acctNumber)) {
            AmBizResource amBizResource = new AmBizResource();
            DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)acctNumber)});
            if (null == bankAcct) {
                return;
            }
            DynamicObject company = bankAcct.getDynamicObject("company");
            boolean isCloseByProc = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)TmcParamEnum.AM002.getValue());
            if (!isCloseByProc) {
                throw new KDBizException(amBizResource.getCloseByProcError());
            }
            String acctStatus = bankAcct.getString("acctstatus");
            if (acctStatus.equals(BankAcctStatusEnum.CLOSED.getValue()) || acctStatus.equals(BankAcctStatusEnum.CLOSING.getValue())) {
                throw new KDBizException(amBizResource.getUncloseacctStatuserror());
            }
            QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", bankAcct.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())};
            DynamicObject closeBill = BusinessDataServiceHelper.loadSingleFromCache((String)"am_acctclosebill", (QFilter[])filters);
            if (null != closeBill) {
                throw new KDBizException(amBizResource.getCloseacctExistbill());
            }
            String billstatus = (String)data.get("billstatus");
            if (!EmptyUtil.isEmpty((String)billstatus) && !billstatus.equals(BillStatusEnum.SAVE.getValue())) {
                throw new KDBizException(amBizResource.getImportBillError());
            }
        }
    }
}

