/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.holdgoodsmainfest;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.am.common.enums.AssociateBillTypeEnum;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HoldGoodsMainfestEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(HoldGoodsMainfestEdit.class);
    private static final Integer OPERATE_ONE = 1;

    public void registerListener(EventObject e) {
        EntryGrid entryEntity;
        TextEdit textEdit;
        TextEdit afterChange;
        BasedataEdit orgEdit;
        super.registerListener(e);
        BasedataEdit bEdit = (BasedataEdit)this.getView().getControl("inventorygood");
        if (null != bEdit) {
            bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (orgEdit = (BasedataEdit)this.getView().getControl("org"))) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((afterChange = (TextEdit)this.getView().getControl("afterchange")) != null) {
            afterChange.addClickListener((ClickListener)this);
        }
        if ((textEdit = (TextEdit)this.getView().getControl("postbillinfo")) != null) {
            textEdit.addClickListener((ClickListener)this);
        }
        if ((entryEntity = (EntryGrid)this.getControl("subentryentity")) != null) {
            entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void fillData() {
        DynamicObject[] selectDys;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = "";
        List selectedIdList = new ArrayList();
        if (!customParams.isEmpty()) {
            selectedIdList = (List)customParams.get("selectedIdList");
        }
        if (selectedIdList == null || selectedIdList.size() <= 0) {
            return;
        }
        type = String.valueOf(customParams.get("businessType"));
        this.getModel().setValue("businesstype", (Object)type);
        this.getModel().setValue("org", (Object)this.getFisBankRollOrg());
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject selectDy : selectDys = BusinessDataServiceHelper.load((Object[])selectedIdList.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_inventorygoodmanager"))) {
            DynamicObject entryRow = entryEntity.addNew();
            entryRow.set("inventorygood", (Object)selectDy);
            entryRow.set("adopter", selectDy.get("adopter"));
            DynamicObjectCollection inventDySub = selectDy.getDynamicObjectCollection("entryentity");
            if (inventDySub == null || inventDySub.size() <= 0) continue;
            DynamicObjectCollection subEntryEntity = entryRow.getDynamicObjectCollection("subentryentity");
            int index = 0;
            for (DynamicObject dySub : inventDySub) {
                DynamicObject subRow = new DynamicObject(subEntryEntity.getDynamicObjectType());
                subRow.set("associatedtype", dySub.get("associatedtype"));
                subRow.set("billinfo", dySub.get("billinfo"));
                subRow.set("billid", dySub.get("billid"));
                subEntryEntity.add(index, subRow);
                ++index;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "inventorygood": {
                String entityName = "subentryentity";
                String parentEntity = "entryentity";
                this.setSubEntryEntity(rowIndex, newValue, entityName, parentEntity);
                break;
            }
            case "org": {
                this.getModel().deleteEntryData("changeentryentity");
                break;
            }
        }
    }

    private void setSubEntryEntity(int rowIndex, Object newValue, String sunEntityName, String parentEntity) {
        DynamicObject entity = this.getModel().getEntryRowEntity(parentEntity, rowIndex);
        DynamicObjectCollection subEntity = entity.getDynamicObjectCollection(sunEntityName);
        subEntity.clear();
        DynamicObject newValueDy = (DynamicObject)newValue;
        if (newValueDy == null) {
            return;
        }
        DynamicObject invGoods = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(newValueDy.getPkValue().toString()), (String)"am_inventorygoodmanager");
        DynamicObjectCollection newDyCo = invGoods.getDynamicObjectCollection(parentEntity);
        if (newDyCo != null && newDyCo.size() > 0) {
            for (DynamicObject dy : newDyCo) {
                DynamicObject row = subEntity.addNew();
                row.set("associatedtype", (Object)dy.getString("associatedtype"));
                row.set("billinfo", (Object)dy.getString("billinfo"));
            }
        }
        this.getView().updateView(sunEntityName);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "inventorygood": {
                String entityName = "entryentity";
                this.beforeInventoryGoodF7Select(e, dataEntity, index, entityName);
                break;
            }
            case "org": {
                List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)UserServiceHelper.getCurrentUserId(), (String)"am", (String)"am_inventorygoodmanager", (String)"47150e89000000ac");
                QFilter filter = new QFilter("id", "in", (Object)orgIdList);
                ListFilterParameter filterList = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
                filterList.getQFilters().add(filter);
                break;
            }
        }
    }

    private void beforeInventoryGoodF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, int index, String entityName) {
        String businessType = dataEntity.getString("businesstype");
        DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection(entityName);
        ArrayList<String> billNoLs = new ArrayList<String>();
        for (DynamicObject entity : entities) {
            Object inventoryGood = entity.getDynamicObject("inventorygood");
            if (inventoryGood == null) continue;
            billNoLs.add(inventoryGood.getString("number"));
        }
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)UserServiceHelper.getCurrentUserId(), (String)"am", (String)"am_inventorygoodmanager", (String)"47150e89000000ac");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("org.id", "in", (Object)orgIdList);
        filter.and("status", "=", (Object)"C");
        filter.and("goodstatus", "=", (Object)"A");
        if (billNoLs.size() > 0) {
            filter.and("number", "not in", billNoLs);
        }
        if (businessType != null) {
            switch (businessType.toLowerCase(Locale.ROOT)) {
                case "invalid": 
                case "logout": 
                case "adoption": {
                    filter.and("adoptionstatus", "=", (Object)"0");
                    break;
                }
                case "return": 
                case "transfer": {
                    filter.and("adoptionstatus", "=", (Object)"1");
                    break;
                }
            }
        }
        ListFilterParameter filterList = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        filterList.getQFilters().add(filter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        int currentIndex = this.getModel().getEntryCurrentRowIndex("changeentryentity");
        if (key.equalsIgnoreCase("afterchange")) {
            Object propertyType = this.getModel().getValue("propertytype", currentIndex);
            if (propertyType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsMainfestWarn_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("org") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsMainfestWarn_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showPropertyEditForm(propertyType.toString(), currentIndex);
        }
    }

    private void showPropertyEditForm(String propertyType, int currentIndex) {
        if (propertyType.isEmpty()) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(5);
        customParams.put("propertyType", propertyType);
        customParams.put("curIndex", currentIndex);
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (orgObj != null) {
            customParams.put("orgId", orgObj.getPkValue());
        }
        this.showForm("am_holdsgoodpropertyset", ShowType.Floating, customParams, "propertyEdit");
    }

    private void showForm(String formId, ShowType showType, Map<String, Object> customParams, String collBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, collBack));
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("propertyEdit".equals(e.getActionId())) {
            this.getModel().beginInit();
            Map resultMap = (Map)e.getReturnData();
            if (null == resultMap) {
                return;
            }
            int currIndex = Integer.parseInt(resultMap.get("curIndex").toString());
            Iterator iterator = resultMap.entrySet().iterator();
            Set keys = resultMap.keySet();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("curIndex") || key.equalsIgnoreCase("afterchange")) continue;
                String targetKey = "c" + key;
                this.getModel().setValue(targetKey, entry.getValue());
            }
            this.getModel().setValue("afterchange", resultMap.get("afterchange"));
            this.getModel().endInit();
            this.getView().updateView("changeentryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billinfo".equals(key)) {
            int currentRowIndex = e.getRowIndex();
            String billType = (String)this.getModel().getValue("associatedtype", currentRowIndex);
            String entityName = AssociateBillTypeEnum.valueOf((String)billType).getValue();
            String billNo = (String)this.getModel().getValue("billinfo", currentRowIndex);
            String strBillId = (String)this.getModel().getValue("billid", currentRowIndex);
            long billId = 0L;
            billId = EmptyUtil.isEmpty((String)strBillId) ? AmCommonHelper.getBillIdByBillNo((String)entityName, (String)billNo) : Long.parseLong(strBillId);
            if (billId <= 0L) {
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId(AssociateBillTypeEnum.valueOf((String)billType).getValue());
            bsp.setPkId((Object)billId);
            bsp.setStatus(OperationStatus.VIEW);
            bsp.getOpenStyle().setShowType("cdm_cheque_book".equalsIgnoreCase(bsp.getFormId()) ? ShowType.Modal : ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public Long getFisBankRollOrg() {
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }
}

