/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.holdsgoodpropertyset;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.am.common.util.DateUtils;

public class HoldsGoodPropertySetEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("propertyType", customParams.get("propertyType"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        TextEdit textEdit = (TextEdit)this.getView().getControl("billinfo");
        if (textEdit != null) {
            textEdit.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.equalsIgnoreCase("billinfo")) {
            Object type = this.getModel().getValue("associatedtype");
            if (type == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsMainfestWarn_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBillList(type.toString());
        } else if (key.equalsIgnoreCase("btnok")) {
            this.btnOkClick();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        String fieldName = e.getProperty().getName();
        if ("associatedtype".equals(fieldName)) {
            this.getModel().setValue("billinfo", null);
            this.getModel().setValue("billid", null);
        }
    }

    private void showBillList(String type) {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        if (type.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsMainfestWarn_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return;
        }
        if (parentCustomParams.get("orgId") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HoldGoodsMainfestWarn_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(5);
        customParams.put("associatedtype", type);
        String orgId = parentCustomParams.get("orgId").toString();
        customParams.put("orgId", orgId);
        this.showForm("am_billselect", ShowType.Floating, customParams, "selectedBillPost");
    }

    private void showForm(String formId, ShowType showType, Map<String, Object> customParams, String collBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, collBack));
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("selectedBillPost".equals(e.getActionId())) {
            Map resultMap = (Map)e.getReturnData();
            if (null == resultMap) {
                return;
            }
            List billInfoList = (List)resultMap.get("billNoList");
            String billNoStr = "";
            String billIdStr = "";
            for (Map billInfo : billInfoList) {
                billNoStr = String.join((CharSequence)",", billNoStr, (CharSequence)billInfo.get("billNo"));
                billIdStr = String.join((CharSequence)",", billIdStr, (CharSequence)billInfo.get("billId"));
            }
            this.getModel().setValue("billinfo", (Object)billNoStr.replaceFirst(",", ""));
            this.getModel().setValue("billid", (Object)billIdStr.replaceFirst(",", ""));
        }
    }

    private void btnOkClick() {
        String propertyType;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        switch (propertyType = this.getModel().getValue("propertytype").toString()) {
            case "goodsname": 
            case "description": {
                String eleValue = this.getModel().getValue(propertyType).toString();
                returnMap.put("afterchange", eleValue);
                returnMap.put(propertyType, eleValue);
                break;
            }
            case "associatedtype": {
                Object associatedtype = this.getModel().getValue(propertyType);
                String eleValue = associatedtype != null ? associatedtype.toString() : "";
                returnMap.put(propertyType, eleValue);
                eleValue = this.getModel().getValue("billinfo").toString();
                String billIds = this.getModel().getValue("billid").toString();
                returnMap.put("billinfo", eleValue);
                returnMap.put("billId", billIds);
                returnMap.put("afterchange", eleValue);
                break;
            }
            case "keeper": {
                DynamicObject keeperDy = (DynamicObject)this.getModel().getValue(propertyType);
                if (keeperDy != null) {
                    returnMap.put("afterchange", keeperDy.getString("name"));
                }
                returnMap.put(propertyType, keeperDy);
                break;
            }
            case "startdate": 
            case "enddate": {
                Date date = (Date)this.getModel().getValue(propertyType);
                if (date == null) break;
                String dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                returnMap.put(propertyType, dateStr);
                returnMap.put("afterchange", dateStr);
                break;
            }
            case "permission": {
                ComboProp combo = (ComboProp)this.getModel().getDataEntityType().getProperties().get((Object)"permission");
                Map<String, Object> mapSet = HoldsGoodPropertySetEdit.getDownList(combo);
                Object permission = this.getModel().getValue("permission");
                if (permission == null) break;
                String[] selectedItem = permission.toString().split(",");
                ArrayList<String> selectedStr = new ArrayList<String>();
                if (selectedItem.length > 0) {
                    for (String item : selectedItem) {
                        if (item.isEmpty()) continue;
                        selectedStr.add(mapSet.get(item).toString());
                    }
                }
                String result = String.join((CharSequence)",", selectedStr);
                returnMap.put(propertyType, permission);
                returnMap.put("afterchange", result);
                break;
            }
        }
        returnMap.put("curIndex", customParams.get("curIndex"));
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    public static Map<String, Object> getDownList(ComboProp iDataEntityProperty) {
        HashMap<String, Object> mapSetResult = new HashMap<String, Object>(16);
        for (ValueMapItem comboItem : iDataEntityProperty.getComboItems()) {
            String key = comboItem.getValue();
            LocaleString value = comboItem.getName();
            mapSetResult.put(key, value);
        }
        return mapSetResult;
    }
}

