/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.index;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AccountbankCountPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("paymode".equals(key)) {
            this.fetchData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fetchData();
    }

    private void fetchData() {
        Date today = new Date();
        String paymode = (String)this.getModel().getValue("paymode");
        Date lastDay = DateUtils.getLastMonth((Date)today, (int)Integer.parseInt(paymode));
        QFilter todayQFilter = new QFilter("opendate", "<=", (Object)today);
        QFilter lastDayQFilter = new QFilter("opendate", ">=", (Object)lastDay);
        QFilter dateQFilter = todayQFilter.and(lastDayQFilter);
        String appId = this.getView().getFormShowParameter().getAppId();
        RequestContext context = RequestContext.get();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(context.getUserId()), (String)appId, (String)"am_accountbank", (String)"47150e89000000ac");
        BillList billList = (BillList)this.getControl("billlistap");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(dateQFilter);
        filters.add(new QFilter("company.id", "in", (Object)comIdList));
        FilterParameter filterParameter = billList.getFilterParameter();
        filterParameter.setQFilters(filters);
        this.setCardBackground(billList);
        this.getView().updateView("billlistap");
    }

    private void setCardBackground(BillList billList) {
        Map<String, String> bankImgMap = this.getBankImgMap();
        HashMap otherBankMap = new HashMap(8);
        String[] bankInfo = new String[]{null, null};
        int[] turnNum = new int[]{1};
        billList.addPackageDataListener(evt -> {
            if (evt.getSource() instanceof ColumnDesc) {
                ColumnDesc columnDesc = (ColumnDesc)evt.getSource();
                if ("bank.bank_cate.number".equals(columnDesc.getKey())) {
                    bankInfo[0] = (String)evt.getFormatValue();
                }
                if ("finorgtype".equals(columnDesc.getKey())) {
                    bankInfo[1] = (String)evt.getFormatValue();
                }
                if ("bank.logo".equals(columnDesc.getKey())) {
                    String path = null;
                    if (EmptyUtil.isEmpty((String)bankInfo[0])) {
                        if (EmptyUtil.isNoEmpty((String)bankInfo[1])) {
                            int finOrgTypeValue = Integer.parseInt(bankInfo[1]);
                            if (finOrgTypeValue < 1 || finOrgTypeValue > 7) {
                                finOrgTypeValue = Math.abs(finOrgTypeValue - 7);
                            }
                            path = finOrgTypeValue + "_";
                        }
                    } else if (!bankImgMap.containsKey(bankInfo[0])) {
                        String string;
                        if (otherBankMap.containsKey(bankInfo[0])) {
                            string = (String)otherBankMap.get(bankInfo[0]);
                        } else {
                            int n = turnNum[0];
                            turnNum[0] = n + 1;
                            string = n + "_";
                        }
                        path = string;
                        otherBankMap.put(bankInfo[0], path);
                        if (turnNum[0] > 7) {
                            turnNum[0] = 1;
                        }
                    } else {
                        path = (String)bankImgMap.get(bankInfo[0]);
                    }
                    String realPath = this.getRealPath(path);
                    evt.setFormatValue((Object)realPath);
                    bankInfo[0] = null;
                    bankInfo[1] = null;
                }
            }
        });
    }

    private Map<String, String> getBankImgMap() {
        DynamicObjectCollection settings = QueryServiceHelper.query((String)"cas_settingmapper", (String)"type,key,value", (QFilter[])new QFilter("type", "=", (Object)"finorgimg").toArray());
        Map<String, String> bankImgMap = settings.stream().collect(Collectors.toMap(setting -> setting.getString("key"), setting -> setting.getString("value"), (o1, o2) -> o2));
        return bankImgMap;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"bankaccountnumber", (CharSequence)evt.getFieldName())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("am_accountbank");
            showParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"AccountbankCountPlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            showParameter.setParentPageId(this.getView().getPageId());
            showParameter.setPkId(currentSelectedRowInfo.getPrimaryKeyValue());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private String getRealPath(String relativePath) {
        String defaultPath = "/images/pc/cardbackgroundv2/bankcard_international_01_390_202.png";
        String bkImg = relativePath == null ? defaultPath : (relativePath.length() != 2 ? relativePath : defaultPath.replace("1_", relativePath));
        String rootUrl = UrlService.getDomainContextUrl();
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        return rootUrl + bkImg;
    }
}

