/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AccountbankDistributePlugin
extends AbstractFormPlugin {
    private static final String BTN_FINORG = "btn_finorg";
    private static final String BTN_ACCTPURPOSE = "btn_acctpurpose";
    private static final String BTN_LOCAL = "btn_local";
    private static final String BTN_CURRENCY = "btn_currency";
    private static final String TABAP = "tabap";
    private static final String CACHEKEY_DIMENSION = "dimension";
    private HistogramChart customChart = null;
    private List<String> names = new ArrayList<String>();
    private List<Integer> values = new ArrayList<Integer>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent event) {
                AccountbankDistributePlugin.this.setDimension(event.getTabKey());
                AccountbankDistributePlugin.this.fetchData();
                AccountbankDistributePlugin.this.paintChart(AccountbankDistributePlugin.this.names, AccountbankDistributePlugin.this.values);
            }
        });
    }

    private String getDimension() {
        String dimension = this.getPageCache().get(CACHEKEY_DIMENSION);
        if (EmptyUtil.isEmpty((String)dimension)) {
            dimension = BTN_FINORG;
        }
        return dimension;
    }

    private void setDimension(String key) {
        this.getPageCache().put(CACHEKEY_DIMENSION, key);
    }

    private String getShowmode() {
        String showmode = this.getPageCache().get("showmode");
        if (EmptyUtil.isEmpty((String)showmode)) {
            showmode = "10";
        }
        return showmode;
    }

    private void setShowmode(String value) {
        this.getPageCache().put("showmode", value);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("showmode".equals(key)) {
            String paymode = (String)this.getModel().getValue("showmode");
            paymode = EmptyUtil.isEmpty((String)paymode) ? "10" : paymode;
            this.setShowmode(paymode);
            this.fetchData();
            this.paintChart(this.names, this.values);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fetchData();
        this.paintChart(this.names, this.values);
    }

    private void fetchData() {
        String appId = this.getView().getFormShowParameter().getAppId();
        RequestContext context = RequestContext.get();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(context.getUserId()), (String)appId, (String)"am_accountbank", (String)"47150e89000000ac");
        ArrayList<QFilter> accountbankQFilters = new ArrayList<QFilter>();
        accountbankQFilters.add(new QFilter("company.id", "in", (Object)comIdList));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("normal");
        statusList.add("closing");
        accountbankQFilters.add(new QFilter("acctstatus", "in", statusList));
        DataSet bizDs = null;
        String dimension = this.getDimension();
        String groupByFieldStr = "bank.bank_cate.name";
        switch (dimension) {
            case "btn_finorg": {
                groupByFieldStr = "bank_cate";
                bizDs = this.queryData_ByFinOrgInfo(accountbankQFilters.toArray(new QFilter[0]));
                break;
            }
            case "btn_acctpurpose": {
                groupByFieldStr = "acctproperty";
                bizDs = this.queryData_ByAcctPurpose(accountbankQFilters.toArray(new QFilter[0]));
                break;
            }
            case "btn_local": {
                groupByFieldStr = "city";
                bizDs = this.queryData_ByLocal(accountbankQFilters.toArray(new QFilter[0]));
                break;
            }
            case "btn_currency": {
                groupByFieldStr = "currencyname";
                bizDs = this.queryData_ByCurrency(accountbankQFilters.toArray(new QFilter[0]));
                break;
            }
        }
        String paymode = this.getShowmode();
        if (bizDs != null) {
            Iterator it = (bizDs = bizDs.orderBy(new String[]{"count desc"}).top(Integer.parseInt(paymode))).iterator();
            if (!it.hasNext()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_quesheng"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_quesheng"});
            ArrayList<String> xName = new ArrayList<String>();
            ArrayList<Integer> yValue = new ArrayList<Integer>();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                xName.add(row.getString(groupByFieldStr));
                yValue.add(row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count"));
            }
            this.names.clear();
            this.values.clear();
            this.names.addAll(xName);
            this.values.addAll(yValue);
        }
    }

    protected DataSet queryData_ByCurrency(QFilter[] filter) {
        String bankAcctSic = "currency,currency.fbasedataid";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        String currency = "id,name currencyname";
        DataSet currencySet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_currency", (String)currency, null, null);
        bankAcctSet = bankAcctSet.join(currencySet, JoinType.LEFT).on("currency.fbasedataid", "id").select(new String[]{"currencyname"}).finish();
        return bankAcctSet.groupBy(new String[]{"currencyname"}).count().finish();
    }

    protected DataSet queryData_ByFinOrgInfo(QFilter[] filter) {
        String bankAcctSic = "case when finorgtype='0' then bank.bank_cate.name else bank.name end as bank_cate";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        return bankAcctSet.groupBy(new String[]{"bank_cate"}).count().finish();
    }

    protected DataSet queryData_ByLocal(QFilter[] filter) {
        String bankAcctSic = "bank.id";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        String finOrgSic = "id,city.name city";
        DataSet bankSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_finorginfo", (String)finOrgSic, null, null);
        bankAcctSet = bankAcctSet.join(bankSet, JoinType.LEFT).on("bank.id", "id").select(new String[]{"city"}).finish();
        return bankAcctSet.groupBy(new String[]{"city"}).count().finish();
    }

    protected DataSet queryData_ByAcctPurpose(QFilter[] filter) {
        String bankAcctSic = "acctproperty.name acctproperty";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter, null);
        return bankAcctSet.groupBy(new String[]{"acctproperty"}).count().finish();
    }

    private void paintChart(List<String> xName, List<Integer> yValue) {
        this.customChart = (HistogramChart)this.getControl("expchart");
        if (null == this.customChart || CollectionUtils.isEmpty(this.values)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"expchart"});
            return;
        }
        this.customChart.clearData();
        this.customChart.setDraggable(true);
        this.customChart.setShowTooltip(true);
        this.customChart.setTitleAlign(XAlign.left, YAlign.top);
        this.customChart.setMargin(Position.left, "30px");
        this.customChart.setMargin(Position.right, "10px");
        BarSeries barSeries = this.customChart.createBarSeries(ResManager.loadKDString((String)"\u8d26\u6237\u6570", (String)"AccountbankDistributePlugin_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        Collections.replaceAll(xName, null, ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"AccountbankDistributePlugin_7", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        Collections.replaceAll(xName, "", ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"AccountbankDistributePlugin_7", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        if (xName.size() < 5) {
            barSeries.setBarWidth("100");
        } else if (xName.size() < 9) {
            barSeries.setBarWidth("50");
        } else if (xName.size() < 11) {
            barSeries.setBarWidth("45");
        } else {
            barSeries.setBarWidth("4");
        }
        Axis xAxis = this.customChart.createXAxis(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"AccountbankDistributePlugin_1", (String)"tmc-am-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap axisLabel = new HashMap();
        xAxis.setPropValue("axisLabel", axisLabel);
        xAxis.setCategorys(xName);
        Axis yAxis = this.customChart.createYAxis(ResManager.loadKDString((String)"\u8d26\u6237\u6570 ", (String)"AccountbankDistributePlugin_2", (String)"tmc-am-formplugin", (Object[])new Object[0]), AxisType.value);
        barSeries.setColor("#5F8AFF");
        for (Integer amount : yValue) {
            barSeries.addData((Number)amount);
        }
        this.setLableStyle(barSeries);
        this.setLinearGradient(barSeries, "#5E80EB", "#83bff6");
        this.setLineColor(xAxis, "#666666");
        this.setLineColor(yAxis, "#666666");
        this.customChart.refresh();
    }

    private void setLableStyle(BarSeries barSeries) {
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setColor("#5F8AFF");
        label.setFormatter("function(itemValue,index){var itemData = itemValue.value;return itemData;}");
        barSeries.setLabel(label);
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("label");
        funPath.add("normal");
        funPath.add("formatter");
        barSeries.addFuncPath(funPath);
    }

    private void setLinearGradient(BarSeries barSeries, String color1, String color2) {
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("itemStyle");
        funPath.add("normal");
        funPath.add("color");
        barSeries.addFuncPath(funPath);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 1, 0, 0, [{\"offset\": 0,\"color\": '" + color1 + "'}, {\"offset\": 1, \"color\": '" + color2 + "'}])");
        normap.put("normal", map);
        barSeries.setPropValue("itemStyle", normap);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

