/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.inventorygoodsmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.enums.AssociateBillTypeEnum;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InventoryGoodsManagerEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setEntryInfo("useentryentity", "am_holdgoods_use", "usebill");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        if (entryEntity != null) {
            entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        }
        TextEdit textEdit = (TextEdit)this.getControl("billinfo");
        textEdit.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private void setEntryInfo(String entryName, String targetBill, String fieldName) {
        DataSet queryResult = this.getLogInfo(targetBill);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryName);
        if (queryResult != null) {
            Iterator iterator = queryResult.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Row resultRow = (Row)iterator.next();
                DynamicObject row = rows.addNew();
                row.set("id", (Object)index);
                DynamicObject usingLog = BusinessDataServiceHelper.loadSingle((Object)resultRow.get("id"), (String)targetBill);
                row.set(fieldName, (Object)usingLog);
                ++index;
            }
        }
    }

    private DataSet getLogInfo(String targetBill) {
        ArrayList<String> typeLs = new ArrayList<String>();
        typeLs.add("adoption");
        typeLs.add("transfer");
        typeLs.add("return");
        typeLs.add("change");
        typeLs.add("logout");
        typeLs.add("loss");
        typeLs.add("invalid");
        long id = (Long)this.getModel().getDataEntity().getPkValue();
        QFilter qFilters = new QFilter("status", "=", (Object)"C");
        qFilters.and("businesstype", "in", typeLs);
        qFilters.and("entryentity.inventorygood.id", "=", (Object)id);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)targetBill, (String)"id,businessdate,createtime,auditdate", (QFilter[])qFilters.toArray(), null);
        return dataSet.orderBy(new String[]{"businessdate", "auditdate"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        List<String> opList = Arrays.asList("change", "logout", "loss", "invalid", "adoption", "transfer", "return");
        if (opList.contains(opKey) && e.getOperationResult().isSuccess()) {
            ArrayList<Long> selectedIdList = new ArrayList<Long>();
            Long id = Long.parseLong(this.getModel().getValue("id").toString());
            selectedIdList.add(id);
            String targetBillType = "am_holdgoods_use";
            this.showManifestForm(opKey, targetBillType, selectedIdList);
        }
    }

    private void showManifestForm(String opKey, String targetBillType, List<Long> selectedIdList) {
        BaseShowParameter parameter = new BaseShowParameter();
        Map customParam = parameter.getCustomParams();
        customParam.put("selectedIdList", selectedIdList);
        customParam.put("businessType", opKey);
        parameter.setCustomParams(customParam);
        parameter.setFormId(targetBillType);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectedBill"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billinfo".equals(key)) {
            int currentRowIndex = e.getRowIndex();
            String billType = (String)this.getModel().getValue("associatedtype", currentRowIndex);
            String entityName = AssociateBillTypeEnum.valueOf((String)billType).getValue();
            String billNo = (String)this.getModel().getValue("billinfo", currentRowIndex);
            String strBillId = (String)this.getModel().getValue("billid", currentRowIndex);
            long billId = 0L;
            billId = EmptyUtil.isEmpty((String)strBillId) ? AmCommonHelper.getBillIdByBillNo((String)entityName, (String)billNo) : Long.parseLong(strBillId);
            if (billId <= 0L) {
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId(AssociateBillTypeEnum.valueOf((String)billType).getValue());
            bsp.setPkId((Object)billId);
            bsp.setStatus(OperationStatus.VIEW);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.equalsIgnoreCase("billinfo")) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String type = String.valueOf(this.getModel().getValue("associatedtype", currentIndex));
            this.showBillList(type);
        }
    }

    private void showBillList(String type) {
        if (type.isEmpty()) {
            return;
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectedBill"));
        formShowParameter.setFormId("am_billselect");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("associatedtype", (Object)type);
        formShowParameter.setCustomParam("curIndex", (Object)currentIndex);
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (orgObj != null) {
            formShowParameter.setCustomParam("orgId", orgObj.getPkValue());
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map resultMap;
        super.closedCallBack(e);
        if ("selectedBill".equals(e.getActionId()) && (resultMap = (Map)e.getReturnData()) != null) {
            int curIndex = (Integer)resultMap.get("curIndex");
            String type = (String)resultMap.get("type");
            List billNoList = (List)resultMap.get("billNoList");
            this.getModel().beginInit();
            int size = billNoList.size();
            for (int i = 0; i < size; ++i) {
                Map billMap = (Map)billNoList.get(i);
                String billNo = (String)billMap.get("billNo");
                String billId = (String)billMap.get("billId");
                this.getModel().setValue("associatedtype", (Object)type, curIndex);
                this.getModel().setValue("billinfo", (Object)billNo, curIndex);
                this.getModel().setValue("billid", (Object)billId, curIndex);
                if (i >= size - 1) continue;
                curIndex = this.getModel().insertEntryRow("entryentity", curIndex + 1);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }
}

