/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.openacct;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.errorcode.ErrorCodeUtils;
import kd.tmc.am.common.exception.AmException;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAcctOpenEdit
extends AbstractBillPlugIn {
    private static String[] FEILDS = new String[]{"bankaccountnumber", "acctname", "englishname", "opendate", "shortnumber", "comment", "fs_manageinfo", "name"};
    private static String[] REVFEILDS = new String[]{"company", "openorg", "finorgtype", "bank", "muiticurrency", "defaultcurrency", "acctstyle", "accttype", "acctproperty", "reason", "applytime", "applier"};
    private static String[] FS_BANKINFO = new String[]{"bebankfunc", "bankinterface", "isopenbank", "bankfunc", "fs_bankinfo", "nooperbeireason", "noopenlinereason"};

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        BasedataEdit openorg;
        super.registerListener(e);
        this.initControlEvi();
        BasedataEdit bank = (BasedataEdit)this.getControl("bank");
        final String finOrgType = Objects.toString(this.getModel().getValue("finorgtype"));
        bank.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)BankAcctOpenEdit.this, "resin"));
                if (finOrgType.equals(FinOrgTypeEnum.BANK.getValue())) {
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam("resin", (Object)Boolean.TRUE);
                }
            }
        });
        if (this.getModel().getProperty("openorg") != null && this.getView().getControl("openorg") != null && (openorg = (BasedataEdit)this.getControl("openorg")) != null) {
            openorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setCustomParam("range", null);
            });
        }
        this.innitAcctPurpose();
    }

    public QFilter getCurrencyQFilter(DynamicObject bankAcct) {
        DynamicObjectCollection currencyCol = bankAcct.getDynamicObjectCollection("muiticurrency");
        HashSet<Long> currencyIDs = new HashSet<Long>();
        for (DynamicObject prop : currencyCol) {
            currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
        }
        QFilter qFilter = new QFilter("id", "in", currencyIDs);
        return qFilter;
    }

    private void innitAcctPurpose() {
        DynamicObject bankAcct = this.getModel().getDataEntity();
        DynamicObject company = bankAcct.getDynamicObject("company");
        BasedataEdit accProp = (BasedataEdit)this.getControl("acctproperty");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return;
        }
        boolean isShowEnd = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"isselectend");
        if (!isShowEnd) {
            return;
        }
        accProp.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject company;
        DynamicObjectCollection muiticurrency;
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        Long currentUser = Long.valueOf(RequestContext.get().getUserId());
        model.setValue("applier", (Object)currentUser);
        if (model.getValue("openorg") != null) {
            model.setValue("name", (Object)((DynamicObject)this.getModel().getValue("openorg")).getString("name"));
        }
        if (model.getValue("manager") == null) {
            model.setValue("manager", (Object)currentUser);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("muiticurrency");
        if (null != currencys && currencys.size() > 0) {
            this.currencyChange(currencys);
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(muiticurrency = (DynamicObjectCollection)model.getValue("muiticurrency")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        }
        if (!EmptyUtil.isEmpty((DynamicObject)(company = bankAcct.getDynamicObject("company"))) && model.getProperty("openorg") != null) {
            DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)company);
            if (!EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
                this.getModel().setValue("openorg", (Object)accountOrg);
            }
            this.companyChange(bankAcct.getDynamicObject("openorg"));
        }
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("company");
        this.showDynamicBill(applyOrg);
    }

    private void showDynamicBill(DynamicObject applyOrg) {
        Object id = 0L;
        if (applyOrg != null) {
            id = applyOrg.getPkValue();
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("acctbanklistflex");
        formShowParameter.setFormId("am_acctbanklist");
        formShowParameter.setSendToClient(true);
        formShowParameter.setCustomParam("companyid", id);
        this.getView().showForm(formShowParameter);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        Long currentUser = Long.valueOf(RequestContext.get().getUserId());
        model.setValue("applier", (Object)currentUser);
        if (model.getValue("manager") == null) {
            model.setValue("manager", (Object)currentUser);
        }
        if (model.getValue("openorg") != null) {
            model.setValue("name", (Object)((DynamicObject)this.getModel().getValue("openorg")).getString("name"));
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection currency;
        super.afterBindData(e);
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        billShowParameter.setBillStatus(BillOperationStatus.AUDIT);
        Object billstatus = model.getValue("billstatus");
        if (null != billstatus && BillStatusEnum.HANDLE.getValue().equals(billstatus)) {
            ((DateEdit)this.getControl("opendate")).setMustInput(true);
            ((UserEdit)this.getControl("manager")).setMustInput(true);
            ((TextEdit)this.getControl("bankaccountnumber")).setMustInput(true);
            ((TextEdit)this.getControl("acctname")).setMustInput(true);
            ((ComboEdit)this.getControl("bankinterface")).setMustInput(true);
            boolean isElecPayment = (Boolean)model.getValue("iselecpayment");
            if (isElecPayment) {
                ComboEdit bankFunc = (ComboEdit)this.getControl("bebankfunc");
                MulComboProp bankFuncProperty = (MulComboProp)bankFunc.getProperty();
                List comboItems = bankFuncProperty.getComboItems();
                comboItems = comboItems.stream().filter(item -> BankFuncEnum.QUERY.getValue().equals(item.getValue()) || BankFuncEnum.PAY.getValue().equals(item.getValue())).collect(Collectors.toList());
                ArrayList<ComboItem> bankFuncItems = new ArrayList<ComboItem>(comboItems.size());
                for (ValueMapItem comboItem : comboItems) {
                    bankFuncItems.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
                }
                bankFunc.setComboItems(bankFuncItems);
            }
        }
        Object scene = this.getView().getFormShowParameter().getCustomParam("SCENE");
        if (BillStatusEnum.SAVE.getValue().equals(billstatus)) {
            this.getView().setEnable(Boolean.valueOf(true), REVFEILDS);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), REVFEILDS);
        }
        if (BillStatusEnum.AUDIT.getValue().equals(billstatus) || BillStatusEnum.REVIEW.getValue().equals(billstatus)) {
            this.getView().setVisible(Boolean.valueOf(true), FEILDS);
        } else if (scene != null && scene.equals("AUDITFLOW") && BillStatusEnum.HANDLE.getValue().equals(billstatus)) {
            if (model.getValue("manager") == null) {
                model.setValue("manager", (Object)RequestContext.get().getUserId());
            }
            this.getView().setVisible(Boolean.valueOf(true), FEILDS);
            this.getView().setEnable(Boolean.valueOf(true), FEILDS);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), FEILDS);
            this.getView().setEnable(Boolean.valueOf(false), FEILDS);
        }
        String finorgType = bankAcct.getString("finorgtype");
        if (EmptyUtil.isNotEmpty((CharSequence)finorgType) && finorgType.equals(FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_bankinfo"});
        }
        this.initToolButtonStatus();
        if ((status == OperationStatus.EDIT || status == OperationStatus.VIEW) && bankAcct.getBoolean("issetbankinterface")) {
            this.initBankVersionBox(false);
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)(currency = bankAcct.getDynamicObjectCollection("muiticurrency"))) && currency.size() > 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        }
        if (EmptyUtil.isNotEmpty((CharSequence)finorgType) && (finorgType.equals(FinOrgTypeEnum.BANK.getValue()) || finorgType.equals(FinOrgTypeEnum.FINCOMP.getValue())) && (BillStatusEnum.SAVE.getValue().equals(billstatus) || BillStatusEnum.SUBMIT.getValue().equals(billstatus))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_bankinfo"});
            this.getView().setVisible(Boolean.valueOf(true), FS_BANKINFO);
        }
        this.verifyProcParam();
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("company");
        this.showDynamicBill(applyOrg);
        boolean isBank = (Boolean)this.getModel().getValue("issetbankinterface");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] valueSet = args.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        switch (propName) {
            case "opendate": {
                Date bizDate;
                Date currentDate = DateUtils.getCurrentDate();
                if (EmptyUtil.isEmpty((Object)propValue) || !(bizDate = (Date)propValue).after(currentDate)) break;
                this.getView().showTipNotification(new AmBizResource().getOpendateError());
                model.setValue("opendate", (Object)currentDate);
                break;
            }
            case "openorg": {
                if (propValue != null) {
                    DynamicObject dynamicObject = (DynamicObject)propValue;
                    this.getModel().setValue("commonseal", (Object)dynamicObject.getString("name"));
                    this.getModel().setValue("name", (Object)dynamicObject.getString("name"));
                }
                this.companyChange((DynamicObject)propValue);
                break;
            }
            case "muiticurrency": {
                if (Objects.equals(model.getValue("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue()) && ((DynamicObjectCollection)propValue).size() > 1) {
                    this.getView().showTipNotification(new AmBizResource().getContMultipleSelectCurrency());
                    this.setMultiCurrency();
                }
                this.currencyChange(propValue);
                break;
            }
            case "defaultcurrency": {
                if (null == propValue) break;
                model.setValue("managecurrency", propValue);
                break;
            }
            case "finorgtype": {
                model.setValue("bank", null);
                if (Objects.equals(propValue, FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
                    this.setMultiCurrency();
                }
                this.virtualEntryValueChanged(propValue);
                break;
            }
            case "issetbankinterface": 
            case "bank": {
                DynamicObject bankCate;
                boolean isSetBankInterface = (Boolean)model.getValue("issetbankinterface");
                if (isSetBankInterface) {
                    try {
                        this.initBankVersionBox(true);
                        boolean isElecPayment = (Boolean)model.getValue("iselecpayment");
                        ComboEdit bankFunc = (ComboEdit)this.getControl("bebankfunc");
                        MulComboProp bankFuncProperty = (MulComboProp)bankFunc.getProperty();
                        List comboItems = bankFuncProperty.getComboItems();
                        ArrayList<ComboItem> bankFuncItems = new ArrayList<ComboItem>(comboItems.size());
                        if (isElecPayment) {
                            comboItems = comboItems.stream().filter(item -> BankFuncEnum.QUERY.getValue().equals(item.getValue()) || BankFuncEnum.PAY.getValue().equals(item.getValue())).collect(Collectors.toList());
                            for (ValueMapItem comboItem : comboItems) {
                                bankFuncItems.add(new ComboItem(comboItem.getName(), comboItem.getValue()));
                            }
                            bankFunc.setComboItems(bankFuncItems);
                            break;
                        }
                        bankFuncItems.add(new ComboItem(new LocaleString(BankFuncEnum.QUERY.getName()), BankFuncEnum.QUERY.getValue()));
                        bankFuncItems.add(new ComboItem(new LocaleString(BankFuncEnum.PAY.getName()), BankFuncEnum.PAY.getValue()));
                        bankFuncItems.add(new ComboItem(new LocaleString(BankFuncEnum.ECD.getName()), BankFuncEnum.ECD.getValue()));
                        bankFuncItems.add(new ComboItem(new LocaleString(BankFuncEnum.PROXYINQUIRY.getName()), BankFuncEnum.PROXYINQUIRY.getValue()));
                        bankFuncItems.add(new ComboItem(new LocaleString(BankFuncEnum.RECEIPT.getName()), BankFuncEnum.RECEIPT.getValue()));
                        bankFunc.setComboItems(bankFuncItems);
                    }
                    catch (Exception e) {
                        model.setValue("issetbankinterface", (Object)false);
                        ((ComboEdit)this.getControl("bankinterface")).setMustInput(false);
                        this.getView().showErrorNotification(e.getMessage());
                    }
                    break;
                }
                ((ComboEdit)this.getControl("bebankfunc")).setMustInput(false);
                DynamicObject bankObj = (DynamicObject)model.getValue("bank");
                if (bankObj == null || !EmptyUtil.isNoEmpty((DynamicObject)(bankCate = bankObj.getDynamicObject("bank_cate")))) break;
                Long id = (Long)bankCate.getPkValue();
                if (EmptyUtil.isNoEmpty((Long)id) && Boolean.TRUE.equals(VisibleVirtualAcctHelper.checkVirtualAcct((Long)id))) {
                    this.getModel().setValue("isvirtual", (Object)"1");
                    this.getModel().setValue("issetbankinterface", (Object)"0");
                    this.getModel().setValue("isopenbank", (Object)"0");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"isvirtual", "issetbankinterface", "isopenbank"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"isvirtual", "issetbankinterface", "isopenbank"});
                break;
            }
            case "bankinterface": {
                this.initBankAcctTypes();
                break;
            }
        }
    }

    private void virtualEntryValueChanged(Object propValue) {
        if (EmptyUtil.isNoEmpty((Object)propValue) && !FinOrgTypeEnum.FINCOMP.getValue().equals(propValue)) {
            this.getModel().deleteEntryData("virtualentity");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("virtual_attachmentap");
            List attdata = attachmentPanel.getAttachmentData();
            attdata.forEach(map -> {
                String formId = map.get("entityNum").toString();
                Object pkId = map.get("billPkId");
                Object fileUid = map.get("uid");
                AttachmentServiceHelper.remove((String)formId, pkId, fileUid);
                attachmentPanel.remove(map);
            });
        }
    }

    public void initBankAcctTypes() {
        Map stringMap;
        String pageCacheStr = this.getView().getPageCache().get("EBGetLoginListResult");
        EBGetLoginListResult loginListResult = (EBGetLoginListResult)JSON.parseObject((String)pageCacheStr, EBGetLoginListResult.class);
        if (EmptyUtil.isEmpty((Object)loginListResult)) {
            return;
        }
        Map bankAccTypeMap = loginListResult.getBankAccTypeMap();
        if (null != bankAccTypeMap && null != (stringMap = (Map)bankAccTypeMap.get(this.getModel().getValue("bankinterface")))) {
            ArrayList<ComboItem> bankAccTypeItems = new ArrayList<ComboItem>(stringMap.size());
            for (Map.Entry entry : stringMap.entrySet()) {
                ComboItem item = new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey());
                bankAccTypeItems.add(item);
            }
            ComboEdit bankVersion = (ComboEdit)this.getControl("additionalproperty");
            bankVersion.setComboItems(bankAccTypeItems);
            Object obj = this.getModel().getValue("additionalproperty");
            if (obj == null && bankAccTypeItems.size() > 0) {
                this.getModel().setValue("additionalproperty", (Object)((ComboItem)bankAccTypeItems.get(0)).getValue());
            }
        }
    }

    private void setMultiCurrency() {
        IDataModel model = this.getModel();
        DynamicObjectCollection muitiCurrency = (DynamicObjectCollection)model.getValue("muiticurrency");
        if (muitiCurrency.size() > 1) {
            DynamicObject[] dynamicObjects = new DynamicObject[]{((DynamicObject)muitiCurrency.get(0)).getDynamicObject("fbasedataid")};
            DynamicObjectCollection newMutiCurrency = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"muiticurrency", (DynamicObject[])dynamicObjects);
            model.setValue("muiticurrency", (Object)newMutiCurrency);
        }
    }

    private void initBankVersionBox(boolean isSelectFirst) {
        try {
            EBGetLoginListResult loginListResult = BankServiceHelper.getLoginListResult((DynamicObject)this.getModel().getDataEntity());
            Map bankVersionMap = loginListResult.getLoginMap();
            this.getView().getPageCache().put("EBGetLoginListResult", JSON.toJSONString((Object)loginListResult));
            if (null != bankVersionMap) {
                ArrayList<String> bankVersionList;
                if (Boolean.TRUE.equals(this.getModel().getValue("iselecpayment"))) {
                    bankVersionList = new ArrayList<String>(10);
                    for (String string : bankVersionMap.keySet()) {
                        if (string.contains("ECNY")) continue;
                        bankVersionList.add(string);
                    }
                    bankVersionList.forEach(bankVersionMap::remove);
                } else {
                    bankVersionList = new ArrayList(10);
                    for (String string : bankVersionMap.keySet()) {
                        if (!string.contains("ECNY")) continue;
                        bankVersionList.add(string);
                    }
                    bankVersionList.forEach(bankVersionMap::remove);
                }
                ArrayList<ComboItem> bankVersionItems = new ArrayList<ComboItem>(bankVersionMap.size());
                for (Map.Entry entry : bankVersionMap.entrySet()) {
                    ComboItem item = new ComboItem(new LocaleString((String)entry.getValue() + "  " + (String)entry.getKey()), (String)entry.getKey());
                    bankVersionItems.add(item);
                }
                ComboEdit bankVersion = (ComboEdit)this.getControl("bankinterface");
                bankVersion.setComboItems(bankVersionItems);
                if (isSelectFirst) {
                    String string = this.getKeyword(this.getModel().getDataEntity());
                    List keywordMatchList = bankVersionMap.entrySet().stream().filter(o -> ((String)o.getValue()).contains(keyword.trim())).collect(Collectors.toList());
                    if (string != null && keywordMatchList.size() > 0) {
                        this.getModel().setValue("bankinterface", ((Map.Entry)keywordMatchList.get(0)).getKey());
                    } else {
                        this.getModel().setValue("bankinterface", (Object)((ComboItem)bankVersionItems.get(0)).getValue());
                    }
                }
            }
            this.initBankAcctTypes();
        }
        catch (Exception e) {
            throw new AmException(ErrorCodeUtils.create((String)"errorCode", (String)e.getMessage()));
        }
    }

    private String getKeyword(DynamicObject bankAcct) {
        String keyword = null;
        DynamicObject finOrg = bankAcct.getDynamicObject("bank");
        if (finOrg != null) {
            String finOrgType = bankAcct.getString("finorgtype");
            if (finOrgType.equals("0")) {
                DynamicObject bankCate = finOrg.getDynamicObject("bank_cate");
                if (bankCate != null) {
                    keyword = bankCate.getString("name");
                }
            } else {
                keyword = finOrg.getString("name");
            }
        }
        return keyword;
    }

    private void currencyChange(Object propValue) {
        DynamicObjectCollection currencys = (DynamicObjectCollection)propValue;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            return;
        }
        IDataModel model = this.getModel();
        int size = currencys.size();
        if (size != 0) {
            DynamicObject currency = (DynamicObject)currencys.get(0);
            model.setValue("defaultcurrency", (Object)((Long)((DataEntityBase)currency.get("fbasedataid")).getPkValue()));
            this.defCurrencyChange(model.getValue("defaultcurrency"));
        }
        if (size <= 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultcurrency"});
        }
    }

    private void initControlEvi() {
        DynamicObject openBill = this.getModel().getDataEntity();
        BasedataEdit multiCurrency = (BasedataEdit)this.getControl("muiticurrency");
        multiCurrency.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit defaultCurrencyF7 = (BasedataEdit)this.getControl("defaultcurrency");
        defaultCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bankAcct = this.getModel().getDataEntity();
            QFilter qFilter = this.getCurrencyQFilter(bankAcct);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit bankF7 = (BasedataEdit)this.getControl("bank");
        bankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String finOrgType = Objects.toString(this.getModel().getValue("finorgtype"));
            QFilter qFilter = new QFilter("finorgtype.type", "in", (Object)finOrgType);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit strategyF7 = (BasedataEdit)this.getControl("strategy");
        strategyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("currency.id", "in", (Object)openBill.getLong("defaultcurrency.id"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit proxyCurrency = (BasedataEdit)this.getControl("proxycurrency");
        proxyCurrency.addBeforeF7SelectListener(evt -> {
            DynamicObject bankAcct = this.getModel().getDataEntity();
            QFilter currencyQFilter = this.getCurrencyQFilter(bankAcct);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(currencyQFilter);
        });
    }

    private void initToolButtonStatus() {
        DynamicObject openBill = this.getModel().getDataEntity();
        String billstatus = openBill.getString("billstatus");
        if (billstatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viewflow,bar_unsubmit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_viewflow", "bar_unsubmit"});
        }
    }

    private void companyChange(DynamicObject propValue) {
        this.getModel().setValue("strategy", null);
    }

    private void defCurrencyChange(Object propValue) {
        if (!EmptyUtil.isEmpty((Object)propValue)) {
            DynamicObject defCurrency = (DynamicObject)propValue;
            this.getModel().setValue("managecurrency", (Object)defCurrency);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (null != returnData) {
            if (returnData instanceof JSONArray) {
                DynamicObject bank = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bebank", "in", ((JSONArray)returnData).get(0))});
                if (null != bank) {
                    this.getModel().setValue("bank", bank.get("id"));
                }
            } else if (returnData instanceof ListSelectedRowCollection) {
                this.getModel().setValue("bank", ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue());
            }
        }
    }

    private void verifyProcParam() {
        IDataModel model = this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        DynamicObject company = bankAcct.getDynamicObject("company");
        String isOpenByProcess = "0";
        if (!EmptyUtil.isEmpty((DynamicObject)company)) {
            isOpenByProcess = AmParameterHelper.getAppStringParameter((long)company.getLong("id"), (String)TmcParamEnum.AM001.getValue());
        }
        if (status == OperationStatus.ADDNEW && "0".equals(isOpenByProcess)) {
            this.getView().showTipNotification(new AmBizResource().getErrorDirecTopen(), Integer.valueOf(7000));
            model.setValue("company", null);
            model.setValue("openorg", null);
        }
    }
}

