/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.openacct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankAcctOpenList
extends AbstractTmcBillBaseList {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (null != result && result.isSuccess() && EmptyUtil.isNotEmpty((CharSequence)operateKey) && operateKey.equals("showacct")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object pkValue = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject openBill = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"am_accopenbill");
            QFilter[] filters = new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)openBill.getString("bankaccountnumber"))};
            DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((String)"am_accountbank", (QFilter[])filters);
            if (Objects.isNull(bankAcct)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"BankAcctOpenList_1", (String)"tmc-am-formplugin", (Object[])new Object[0]), openBill.getString("bankaccountnumber")));
            } else {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("pkValue", bankAcct.getPkValue());
                param.put("formId", "am_accountbank");
                param.put("showType", ShowType.MainNewTabPage);
                AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("new")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            DynamicObjectCollection authorizedBankOrg = TmcOrgDataHelper.getAuthorizedBankOrg((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem(), (boolean)true);
            if (CollectionUtils.isEmpty((Collection)authorizedBankOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7", (String)"BankAcctOpenList_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"bank.bank_cate.")) {
            args.getQFilters().addAll(this.getBankCateFilter());
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        switch (fieldName) {
            case "bank.bank_cate.name": {
                return this.getBankCateFilter();
            }
        }
        return null;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"bank.bank_cate.")) {
            args.getQfilters().addAll(this.getBankCateFilter());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("applytime desc,company.number,bank.number");
    }

    /*
     * WARNING - void declaration
     */
    private List<QFilter> getBankCateFilter() {
        Object[] authorizedBankOrg;
        ArrayList filterCache;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List pageFilterColumnCache = this.getPageFilterColumnCache("company.name");
        ArrayList<Object> authOrgIds = new ArrayList<Object>();
        List<Object> list = filterCache = EmptyUtil.isEmpty((Collection)pageFilterColumnCache) ? new ArrayList() : pageFilterColumnCache.stream().filter(v -> !v.equals("")).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(filterCache)) {
            authOrgIds = filterCache;
        } else {
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            authorizedBankOrg = TmcOrgDataHelper.getAuthorizedBankOrg((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem(), (boolean)true);
            for (DynamicObject dynamicObject : authorizedBankOrg) {
                authOrgIds.add(dynamicObject.getPkValue());
            }
        }
        if (!EmptyUtil.isEmpty(authOrgIds)) {
            Object[] bankAccts = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"company,bank", (QFilter[])new QFilter[]{new QFilter("company.id", "in", authOrgIds.stream().map(p -> Long.valueOf(p.toString())).collect(Collectors.toList()))});
            HashSet<Long> bankCateIds = new HashSet<Long>();
            if (!EmptyUtil.isEmpty((Object[])bankAccts)) {
                void var9_12;
                authorizedBankOrg = bankAccts;
                int n = authorizedBankOrg.length;
                boolean bl = false;
                while (var9_12 < n) {
                    Object bankAcct = authorizedBankOrg[var9_12];
                    DynamicObject bank = bankAcct.getDynamicObject("bank");
                    DynamicObject bankCate = null;
                    if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                        bankCate = bank.getDynamicObject("bank_cate");
                    }
                    if (EmptyUtil.isNoEmpty(bankCate)) {
                        bankCateIds.add(bankCate.getLong("id"));
                    }
                    ++var9_12;
                }
            }
            if (bankCateIds != null && bankCateIds.size() > 0) {
                QFilter fi = new QFilter("id", "in", bankCateIds);
                filters.add(fi);
            }
        }
        if (EmptyUtil.isEmpty(filters)) {
            filters.add(new QFilter("id", "=", (Object)0));
        }
        return filters;
    }
}

