/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.proxyaccount;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class ProxyAccountEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("bankacct".equalsIgnoreCase(key)) {
            Set<Object> currencyIdSet = new HashSet();
            DynamicObject accountBank = (DynamicObject)e.getChangeSet()[0].getNewValue();
            currencyIdSet = this.getCurrencyPks(accountBank);
            if (currencyIdSet != null && currencyIdSet.size() == 1) {
                this.getModel().setValue("currency", currencyIdSet.toArray()[0]);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object selectOrgId = this.getView().getFormShowParameter().getCustomParams().get("SELECT_ORG_ID");
        if (selectOrgId != null) {
            this.getModel().setValue("org", selectOrgId);
        } else {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.orgF7Event();
        this.bankAcctF7Event();
        this.currencyF7Event();
    }

    private void orgF7Event() {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                String appId = ProxyAccountEdit.this.getView().getFormShowParameter().getAppId();
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"am_proxyinquiryaccount", (String)"47156aff000000ac");
                QFilter qFilter = new QFilter("id", "in", (Object)authOrgIds);
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    private void bankAcctF7Event() {
        BasedataEdit bankAcct = (BasedataEdit)this.getControl("bankacct");
        bankAcct.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                DynamicObject orgOb = (DynamicObject)ProxyAccountEdit.this.getModel().getValue("org");
                if (AmHelper.isEmpty((Object)orgOb)) {
                    e.setCancel(true);
                    ProxyAccountEdit.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ProxyAccountEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter qFilter = new QFilter("createorg", "=", orgOb.getPkValue());
                qFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
                qFilter.and(new QFilter("bebankfunc", "like", (Object)"%proxyinquiry%"));
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    private void currencyF7Event() {
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                DynamicObject bankAcctObj = (DynamicObject)ProxyAccountEdit.this.getModel().getValue("bankacct");
                if (bankAcctObj == null) {
                    ProxyAccountEdit.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"ProxyAccountEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Set<Object> currencyIdSet = new HashSet();
                DynamicObject acctBank = (DynamicObject)ProxyAccountEdit.this.getModel().getValue("bankacct");
                currencyIdSet = ProxyAccountEdit.this.getCurrencyPks(acctBank);
                QFilter qFilter = new QFilter("id", "in", currencyIdSet);
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        });
    }

    public Set<Long> getCurrencyPks(DynamicObject accountBank) {
        Set<Long> currencyIdSet = new HashSet<Long>();
        if (accountBank != null) {
            long bankAcctId = (Long)accountBank.getPkValue();
            currencyIdSet = AccountBankHelper.getCurrencyPks((long)bankAcctId);
        }
        return currencyIdSet;
    }
}

