/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.proxyaccount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.OrgHelper;

public class ProxyAccountList
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        switch (operateKey) {
            case "syncmappedacct": 
            case "disable": 
            case "enable": {
                if (null == result || !result.isSuccess()) break;
                ((BillList)this.getControl("billlistap")).refreshData();
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (CommonFilterColumn commonFilterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("createorg.")) continue;
            DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"am_proxyaccount", (String)"47156aff000000ac");
            Set<Long> collect = orgList.stream().map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            HashSet<ComboItem> useableAccountPks = ProxyAccountList.getUseableOrgPks(collect);
            commonFilterColumn.setComboItems(new ArrayList<ComboItem>(useableAccountPks));
        }
    }

    public static HashSet<ComboItem> getUseableOrgPks(Collection<Long> orgIds) {
        QFilter org = new QFilter("id", "in", orgIds);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{org});
        ArrayList accountPks = new ArrayList(accounts.length);
        HashSet<ComboItem> acctItems = new HashSet<ComboItem>(accountPks.size());
        for (DynamicObject account : accounts) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(account.getString("name")));
            item.setValue(account.getString("id"));
            acctItems.add(item);
        }
        return acctItems;
    }
}

