/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.restrictedfunds;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.helper.AccountBankHelper;

public class RestrictedFundsManagerEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit currencyCtrl = (BasedataEdit)this.getControl("currency");
        currencyCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "currency": {
                DynamicObject bankAcctDy = (DynamicObject)this.getModel().getValue("bankacct");
                if (bankAcctDy == null) {
                    e.setCancel(Boolean.TRUE.booleanValue());
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u8d26\u6237\u7f16\u53f7\u3011\u3002", (String)"RestrictedFundsManager_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    break;
                }
                long acctId = Long.parseLong(bankAcctDy.getPkValue().toString());
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                Set currencyIdSet = new HashSet();
                currencyIdSet = AccountBankHelper.getCurrencyPks((long)acctId);
                QFilter qFilter = new QFilter("id", "in", currencyIdSet);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"push", (CharSequence)formOperate.getOperateKey())) {
            long selectId = Long.parseLong(this.getModel().getValue("id").toString());
            String errorMsg = this.checkBillProperty(selectId);
            if (!errorMsg.isEmpty()) {
                args.setCancel(true);
                this.getView().showErrorNotification(errorMsg);
            }
            String billNo = this.getModel().getValue("billno").toString();
            QFilter qFilter = new QFilter("srcbillno", "=", (Object)billNo);
            qFilter.and("billstatus", "<>", (Object)"C");
            DynamicObjectCollection result = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (result != null && result.size() > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u89e3\u9664\u53d7\u9650\u5931\u8d25\u3002", (String)"RestrictedFundsManager_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        String billNo = this.getModel().getValue("billno").toString();
        QFilter qFilter = new QFilter("srcbillno", "=", (Object)billNo);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("businesstype", "=", (Object)"2");
        String selectFields = "id,billno,businesstype,businessdate,auditdate,liftdate,currency.name curName,thistimeunblockamt,comment";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"am_restrictedfundsmanager", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        DataSet result = dataSet.orderBy(new String[]{"auditdate"});
        if (result != null) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            Iterator iterator = result.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Row resultRow = (Row)iterator.next();
                DynamicObject row = rows.addNew();
                row.set("id", (Object)index);
                row.set("liftedbillno", resultRow.get("billno"));
                row.set("liftedbusinesstype", resultRow.get("businesstype"));
                row.set("liftedbusinessdate", resultRow.get("businessdate"));
                row.set("lifteddate", resultRow.get("liftdate"));
                row.set("liftedcurrency", resultRow.get("curName"));
                row.set("liftedamt", resultRow.get("thistimeunblockamt"));
                row.set("liftedcomment", resultRow.get("comment"));
                ++index;
            }
        }
        this.getView().getModel().setDataChanged(false);
    }

    private String checkBillProperty(long selectId) {
        String errorMsg = "";
        DynamicObject selectedDo = this.getSelectedDynamicObject(selectId);
        if (selectedDo != null) {
            Date actualLiftDate;
            String businessType = selectedDo.getString("businesstype");
            if (businessType.equalsIgnoreCase("2")) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u589e\u52a0\u53d7\u9650\u5355\u636e\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"RestrictedFundsManager_5", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            String billStatus = selectedDo.getString("billstatus");
            if (!billStatus.equalsIgnoreCase("C")) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u589e\u52a0\u53d7\u9650\u5355\u636e\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"RestrictedFundsManager_7", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            BigDecimal unrestrictedAmt = selectedDo.getBigDecimal("unrestrictedamt");
            boolean isAllRestricted = selectedDo.getBoolean("isallrestricted");
            if (unrestrictedAmt.floatValue() <= 0.0f && !isAllRestricted) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u64cd\u4f5c\u5f53\u524d\u53ef\u89e3\u9664\u53d7\u9650\u91d1\u989d\u5927\u4e8e\u96f6\u7684\u8bb0\u5f55\u3002", (String)"RestrictedFundsManager_6", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            if (isAllRestricted && (actualLiftDate = selectedDo.getDate("actualliftdate")) != null) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u89e3\u9664\u53d7\u9650\u3002", (String)"RestrictedFundsManager_8", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
        }
        return errorMsg;
    }

    private DynamicObject getSelectedDynamicObject(long selectId) {
        QFilter qFilter = new QFilter("id", "in", (Object)selectId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id,businesstype,billstatus,unrestrictedamt,isallrestricted,actualliftdate", (QFilter[])new QFilter[]{qFilter});
        if (result != null && result.size() > 0) {
            DynamicObject selectedDo = (DynamicObject)result.get(0);
            return selectedDo;
        }
        return null;
    }
}

