/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.restrictedfunds;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class RestrictedFundsManagerList
extends AbstractTmcDataBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String businessType;
        long selectId;
        DynamicObject result;
        super.beforeDoOperation(args);
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        int selectedCount = listSelectedData.size();
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"push", (CharSequence)formOperate.getOperateKey())) {
            if (selectedCount > 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InventoryGoodsManager_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            } else {
                long selectId2 = Long.parseLong(listSelectedData.get(0).getPrimaryKeyValue().toString());
                String errorMsg = this.checkBillProperty(selectId2);
                if (!errorMsg.isEmpty()) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(errorMsg);
                }
                List billNoList = listSelectedData.stream().map(y -> y.getBillNo()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("srcbillno", "in", billNoList);
                qFilter.and("billstatus", "<>", (Object)"C");
                DynamicObjectCollection result2 = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (result2 != null && result2.size() > 0) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u53d7\u9650\u91d1\u989d\u6709\u89e3\u9664\u53d7\u9650\u64cd\u4f5c\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"RestrictedFundsManager_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (StringUtils.equals((CharSequence)"copy", (CharSequence)formOperate.getOperateKey()) && (result = this.getSelectedDynamicObject(selectId = Long.parseLong(listSelectedData.get(0).getPrimaryKeyValue().toString()))) != null && (businessType = result.getString("businesstype")).equalsIgnoreCase("2")) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u9664\u53d7\u9650\u5355\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"RestrictedFundsManager_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
    }

    private String checkBillProperty(long selectId) {
        String errorMsg = "";
        DynamicObject selectedDo = this.getSelectedDynamicObject(selectId);
        if (selectedDo != null) {
            Date actualLiftDate;
            String businessType = selectedDo.getString("businesstype");
            if (businessType.equalsIgnoreCase("2")) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u589e\u52a0\u53d7\u9650\u5355\u636e\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"RestrictedFundsManager_5", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            String billStatus = selectedDo.getString("billstatus");
            if (!billStatus.equalsIgnoreCase("C")) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u589e\u52a0\u53d7\u9650\u5355\u636e\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"RestrictedFundsManager_7", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            BigDecimal unrestrictedAmt = selectedDo.getBigDecimal("unrestrictedamt");
            boolean isAllRestricted = selectedDo.getBoolean("isallrestricted");
            if (unrestrictedAmt.floatValue() <= 0.0f && !isAllRestricted) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u64cd\u4f5c\u5f53\u524d\u53ef\u89e3\u9664\u53d7\u9650\u91d1\u989d\u5927\u4e8e\u96f6\u7684\u8bb0\u5f55\u3002", (String)"RestrictedFundsManager_6", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
            if (isAllRestricted && (actualLiftDate = selectedDo.getDate("actualliftdate")) != null) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u89e3\u9664\u53d7\u9650\u3002", (String)"RestrictedFundsManager_8", (String)"tmc-am-formplugin", (Object[])new Object[0]);
                return errorMsg;
            }
        }
        return errorMsg;
    }

    private DynamicObject getSelectedDynamicObject(long selectId) {
        QFilter qFilter = new QFilter("id", "in", (Object)selectId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id,businesstype,billstatus,unrestrictedamt,isallrestricted,actualliftdate", (QFilter[])new QFilter[]{qFilter});
        if (result != null && result.size() > 0) {
            DynamicObject selectedDo = (DynamicObject)result.get(0);
            return selectedDo;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }
}

