/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.innerstrategyset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.BillOperationHelper;

public class InnerStrategySettingEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final int MAX_LENGTH = 255;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit destLkPkField = (TextEdit)this.getControl("checkfieldname");
        destLkPkField.addButtonClickListener((ClickListener)this);
        TextEdit inneracctprop = (TextEdit)this.getControl("inneracctpropname");
        inneracctprop.addButtonClickListener((ClickListener)this);
        TextEdit checkCurrencyName = (TextEdit)this.getControl("checkcurrencyname");
        checkCurrencyName.addButtonClickListener((ClickListener)this);
        BasedataEdit balanceModel = (BasedataEdit)this.getControl("balancemodel");
        balanceModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit countModel = (BasedataEdit)this.getControl("countmodel");
        countModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("bizbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)destEntity)) {
            BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)destEntity.getString("number"), new ArrayList(), (String[])new String[]{"checkop"});
        }
        this.reBuildFilterGrid();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "bizbill": {
                this.getModel().setValue("checkfieldname", null);
                this.getModel().setValue("checkfieldval", null);
                this.getModel().setValue("inneracctpropname", null);
                this.getModel().setValue("inneracctpropval", null);
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    this.getModel().setValue("name", (Object)((DynamicObject)newValue).getString("name"));
                    this.getModel().setValue("number", (Object)((DynamicObject)newValue).getString("number"));
                    BillOperationHelper.setOperateComboItem((IFormView)this.getView(), (String)((DynamicObject)newValue).getString("number"), new ArrayList(), (String[])new String[]{"checkop"});
                } else {
                    this.getModel().setValue("name", null);
                    this.getModel().setValue("number", null);
                }
                this.getModel().setValue("datafilterdesc", (Object)"");
                this.reBuildFilterGrid();
                break;
            }
            case "checkop": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    List<String> checkOp = Arrays.asList(((String)newValue).replaceFirst(",", "").split(","));
                    this.getModel().setValue("checkopname", (Object)BillOperationHelper.getOpNameBykey((IFormView)this.getView(), checkOp, (String)key));
                    break;
                }
                this.getModel().setValue("checkopname", null);
                break;
            }
            case "datafilterdesc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getPageCache().put("datafilter", "");
                this.getModel().setValue("datafilter", (Object)"");
                this.getModel().setValue("datafilter_TAG", (Object)"");
                break;
            }
            case "balancemodel": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    DynamicObject modelType = ((DynamicObject)newValue).getDynamicObject("modeltype");
                    this.getModel().setValue("modeltype", modelType.getPkValue());
                    break;
                }
                this.getModel().setValue("modeltype", newValue);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("checkfieldname".equals(key) || "inneracctpropname".equals(key) || "checkcurrencyname".equals(key)) {
            DynamicObject bizbillEntity = (DynamicObject)this.getModel().getValue("bizbill");
            if (EmptyUtil.isEmpty((DynamicObject)bizbillEntity)) {
                TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizbill");
            } else {
                this.showSelectField(key, bizbillEntity);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            String tranExpr;
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            CRCondition conditionObj = new CRCondition();
            conditionObj.setFilterCondition(filterGridState.getFilterCondition());
            try {
                tranExpr = this.tranFormula((CRFormula)conditionObj);
                conditionObj.setExprTran(tranExpr);
            }
            catch (Exception exp) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getMessage()));
                return;
            }
            String tagVal = (String)this.getModel().getValue("datafilter_TAG");
            if (EmptyUtil.isNoEmpty((String)tagVal) && EmptyUtil.isEmpty((String)tranExpr) || EmptyUtil.isNoEmpty((String)tranExpr)) {
                this.receiveExpressionSet(SerializationUtils.toJsonString((Object)conditionObj));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("checkbizrule".equals(operateKey) && opResult.isSuccess()) {
            String opKeyStr = (String)this.getModel().getValue("checkop");
            DynamicObject bizbill = (DynamicObject)this.getModel().getValue("bizbill");
            Set opkeys = Arrays.stream(opKeyStr.replaceFirst(",", "").split(",")).collect(Collectors.toSet());
            QFilter ruleQfilter = new QFilter("opbizrule", "=", (Object)"innerstrategy").and("objecttype", "=", bizbill.getPkValue()).and("entryentity.operationkey", "in", opkeys);
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)"bos_opbizruleset", (String)"id", (QFilter[])ruleQfilter.toArray());
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("bos_opbizruleset");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            HashSet<Object> pks = new HashSet<Object>(targetBills.length);
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showSelectField(String key, DynamicObject bizbillEntity) {
        PropTreeBuildOption option;
        String billEntity = bizbillEntity.getString("number");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        if ("checkfieldname".equals(key)) {
            option = new PropTreeBuildOption(null, AmountProp.class);
            option.setIncludeChildEntity(true);
        } else if ("inneracctpropname".equals(key)) {
            option = new PropTreeBuildOption(null, BasedataProp.class);
            option.setIncludeChildEntity(true);
        } else {
            option = new PropTreeBuildOption(null, CurrencyProp.class);
            option.setIncludeChildEntity(false);
        }
        option.setCurrentEntity(billEntity);
        option.setIncludeBDPropPK(false);
        option.setIncludeBDRefProp(false);
        option.setOnlyPhysicsField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(treeNode, key);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tmc_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String returnData = (String)e.getReturnData();
        switch (e.getActionId()) {
            case "checkfieldname": {
                if (returnData == null) break;
                this.getModel().setValue("checkfieldval", (Object)returnData.split(",")[0]);
                this.getModel().setValue("checkfieldname", (Object)returnData.split(",")[1]);
                break;
            }
            case "inneracctpropname": {
                if (returnData == null) break;
                this.getModel().setValue("inneracctpropval", (Object)returnData.split(",")[0]);
                this.getModel().setValue("inneracctpropname", (Object)returnData.split(",")[1]);
                break;
            }
            case "checkcurrencyname": {
                if (returnData == null) break;
                this.getModel().setValue("checkcurrencyprop", (Object)returnData.split(",")[0]);
                this.getModel().setValue("checkcurrencyname", (Object)returnData.split(",")[1]);
                break;
            }
        }
    }

    private void receiveExpressionSet(String formula) {
        if (StringUtils.isBlank((CharSequence)formula)) {
            this.getModel().setValue("datafilter", (Object)"");
        } else {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
            this.getModel().setValue("datafilter_TAG", (Object)formula);
            String desc = "";
            if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                desc = filterObj.getExprTran();
            }
            if (desc.length() > 255) {
                desc = desc.substring(0, 255);
            }
            this.getModel().setValue("datafilterdesc", (Object)desc);
        }
    }

    private void reBuildFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        String entityNumber = null;
        if (this.getModel().getValue("bizbill") != null) {
            entityNumber = ((DynamicObject)this.getModel().getValue("bizbill")).getString("number");
        }
        if (StringUtils.isNotBlank(entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType(entityNumber);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            option.setCompatibleProductMode(true);
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            String conditionJson = (String)this.getModel().getValue("datafilter_TAG");
            if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                FilterCondition filterCondition = conditionObj.getFilterCondition();
                if (filterCondition != null) {
                    filterGrid.SetValue(filterCondition);
                }
            } else {
                filterGrid.SetValue(new FilterCondition());
            }
            this.getView().updateView("ffiltergrid");
        }
    }

    private String tranFormula(CRFormula formulaObj) {
        String tranExpr = " ";
        DynamicObject entity = (DynamicObject)this.getModel().getValue("bizbill");
        String entityNumber = entity.getString("number");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && !filterCondition.getFilterRow().isEmpty()) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>(2);
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)" \u4e14 ", (String)"ConditionEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("balancemodel".equals(key) || "countmodel".equals(key)) {
            boolean mustInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizbill");
            if (!mustInput) {
                evt.setCancel(true);
            } else {
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("bizbill");
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("bizbillset.bizbill.number", "=", bizBill.getPkValue());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }
}

