/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.common.helper;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.bcr.common.enums.ExeStatusEnum;
import kd.tmc.bcr.common.helper.RpaServiceHelper;
import kd.tmc.bcr.common.model.ExecParam;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class RobotExecuteHelper {
    public static final String FORMAT_YMD = "yyyyMMdd";

    public static DynamicObject execute(DynamicObject robotScheme, Date startDate, Date endDate, Long ushieldId) {
        String procCode = (String)robotScheme.get("proccode");
        String robotId = (String)robotScheme.get("clientid");
        ExecParam execParam = new ExecParam();
        execParam.setAppid("bei");
        execParam.setAccountId(RequestContext.get().getAccountId());
        execParam.setStartDate(RobotExecuteHelper.format(startDate, FORMAT_YMD));
        execParam.setEndDate(RobotExecuteHelper.format(endDate, FORMAT_YMD));
        execParam.setAppSecuret(robotScheme.getString("appSecuret"));
        execParam.setCcuser(robotScheme.getString("ccuser"));
        execParam.setCcpassword(robotScheme.getString("ccpassword"));
        execParam.setUrl(robotScheme.getString("url"));
        execParam.setBankpath(robotScheme.getString("bankpath"));
        execParam.setDirpath(robotScheme.getString("dirpath"));
        String queryTypeStr = robotScheme.getString("querytype");
        execParam.setQuerytype(queryTypeStr.trim().replaceFirst("^,+", "").replaceFirst(",+$", ""));
        String taskId = null;
        String errorInfo = null;
        DynamicObject bankUd = BusinessDataServiceHelper.loadSingle((Object)ushieldId, (String)"bcr_bankudset", (String)"usercode,userpasswd,ukeypasswd,ccuser,ccpassword,udversion,usbhub,usbport,ukeyenddate,retrylogins,enterpriseno,storeman,bank,entry,entry.sender,entry.receiver,entry.verifycode,entry.serveraddr,acctbank.bankaccountnumber,acctbank");
        RobotExecuteHelper.setExecParam(execParam, bankUd);
        List<Map<String, String>> rpaParams = RobotExecuteHelper.trans2RpaParams(execParam, procCode, robotId);
        DynamicObject execLog = BusinessDataServiceHelper.newDynamicObject((String)"bcr_robotscheme_log");
        try {
            taskId = RpaServiceHelper.addTask(procCode, robotId, "", rpaParams);
        }
        catch (Exception ex) {
            errorInfo = "procCode " + procCode + " robotId " + robotId + " " + ex.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"RobotExecuteHelper_0", (String)"tmc-bcr-common", (Object[])new Object[]{ex.getMessage()}));
        }
        finally {
            RobotExecuteHelper.assembleRow(execParam, robotScheme, bankUd, taskId, errorInfo, execLog);
        }
        return execLog;
    }

    private static List<Map<String, String>> trans2RpaParams(ExecParam execParam, String procCode, String procVer) {
        List<Map<String, String>> rpaParams = RpaServiceHelper.getProcessParms(procCode, "");
        Map execParamMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)execParam), Map.class);
        for (Map<String, String> map : rpaParams) {
            if (!execParamMap.containsKey(map.get("Name"))) continue;
            map.put("Value", execParamMap.get(map.get("Name")).toString());
        }
        return rpaParams;
    }

    private static void setExecParam(ExecParam execParam, DynamicObject bankud) {
        execParam.setLoginuser(bankud.getString("usercode"));
        execParam.setLoginpasswd(bankud.getString("userpasswd"));
        execParam.setUkeypasswd(bankud.getString("ukeypasswd"));
        execParam.setUdversion(bankud.getString("udversion"));
        execParam.setUsbhub(bankud.getString("usbhub"));
        execParam.setUsbport(bankud.getString("usbport"));
        execParam.setUkeyenddate(bankud.getString("ukeyenddate"));
        execParam.setRetrylogins(bankud.getInt("retrylogins"));
        execParam.setEnterpriseno(bankud.getString("enterpriseno"));
        execParam.setStoreman(bankud.getString("storeman"));
        HashSet<String> acctNumber = new HashSet<String>(16);
        HashMap<String, String> acctBank2OrgMap = new HashMap<String, String>(16);
        HashMap<String, String> accBank2InfoMap = new HashMap<String, String>(16);
        DynamicObjectCollection bankAccts = bankud.getDynamicObjectCollection("entry");
        List ids = bankAccts.stream().map(v -> v.getDynamicObject("acctbank").getPkValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,company.number", (QFilter[])filter.toArray());
        for (int i = 0; i < accountBanks.length; ++i) {
            String bankAccountNumber = accountBanks[i].getString("bankaccountnumber");
            String orgNumber = accountBanks[i].getDynamicObject("company").getString("number");
            acctNumber.add(bankAccountNumber);
            acctBank2OrgMap.put(bankAccountNumber, orgNumber);
        }
        execParam.setAcctBank2OrgMap(acctBank2OrgMap);
        for (DynamicObject bankAcct : bankAccts) {
            String bankAccountNumber = bankAcct.getDynamicObject("acctbank").getString("bankaccountnumber");
            HashMap<String, String> infoMap = new HashMap<String, String>(4);
            infoMap.put("sender", bankAcct.getString("sender"));
            infoMap.put("receiver", bankAcct.getString("receiver"));
            infoMap.put("verifycode", bankAcct.getString("verifycode"));
            infoMap.put("serveraddr", bankAcct.getString("serveraddr"));
            accBank2InfoMap.put(bankAccountNumber, JSON.toJSONString(infoMap));
        }
        execParam.setAcctBank2InfoMap(accBank2InfoMap);
        execParam.setAcctbanks(StringUtils.join(acctNumber, (String)","));
    }

    private static void assembleRow(ExecParam execParam, DynamicObject robotScheme, DynamicObject bankUd, String taskId, String errorInfo, DynamicObject execLog) {
        execLog.set("id", (Object)DBServiceHelper.genGlobalLongId());
        execLog.set("robotscheme", robotScheme.getPkValue());
        execLog.set("ushield", bankUd.getPkValue());
        execLog.set("bank", bankUd.getDynamicObject("bank").getPkValue());
        execLog.set("org", ((DynamicObject)robotScheme.get("org")).getPkValue());
        execLog.set("procname", robotScheme.get("procname"));
        execLog.set("proccode", robotScheme.get("proccode"));
        execLog.set("client", robotScheme.get("client"));
        execLog.set("clientid", robotScheme.get("clientid"));
        if (taskId != null) {
            execLog.set("exestatus", (Object)ExeStatusEnum.PENDING.getValue());
        } else {
            execLog.set("exestatus", (Object)ExeStatusEnum.FAILED.getValue());
        }
        execLog.set("executeuser", (Object)RequestContext.get().getCurrUserId());
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = new SimpleDateFormat(FORMAT_YMD).parse(execParam.getStartDate());
        }
        catch (ParseException e1) {
            throw new KDBizException(e1.getMessage());
        }
        try {
            endDate = new SimpleDateFormat(FORMAT_YMD).parse(execParam.getEndDate());
        }
        catch (ParseException e1) {
            throw new KDBizException(e1.getMessage());
        }
        execLog.set("querystartdate", (Object)startDate);
        execLog.set("queryenddate", (Object)endDate);
        execLog.set("taskid", (Object)taskId);
        execLog.set("errorinfo", (Object)new LocaleString(errorInfo));
    }

    public static String format(Date date, String forPattern) {
        return new DateTime((Object)date).toString(DateTimeFormat.forPattern((String)forPattern));
    }
}

