/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.common.helper;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RpaServiceHelper {
    private static final Log logger = LogFactory.getLog(RpaServiceHelper.class);
    private static final String SERVICE = "RpaService";

    public static List<Map<String, Object>> getRobotList(String procId) {
        return (List)RpaServiceHelper.invokeBizService("getRobotList", procId);
    }

    public static List<Map<String, Object>> getProcessList(String userId, String procLabel) {
        return (List)RpaServiceHelper.invokeBizService("getProcessList", userId, procLabel);
    }

    public static List<Map<String, String>> getProcessParms(String procCode, String procVer) {
        List paramMap = (List)RpaServiceHelper.invokeBizService("getProcessParms", procCode, procVer);
        logger.info("paramMap = " + JSON.toJSONString((Object)paramMap));
        return paramMap;
    }

    public static String addTask(String procCode, String robotId, String procVer, List<Map<String, String>> params) {
        logger.info("params = " + JSON.toJSONString(params));
        return (String)RpaServiceHelper.invokeBizService("addTask", procCode, robotId, procVer, params);
    }

    public static Map<String, Object> getTaskInfo(String taskId) {
        return (Map)RpaServiceHelper.invokeBizService("getTaskInfo", taskId);
    }

    public static String getTaskLogUrl(String taskId) {
        return (String)RpaServiceHelper.invokeBizService("getTaskLogUrl", taskId);
    }

    private static Object invokeBizService(String method, Object ... param) {
        logger.info("method = " + method + "; param = " + JSON.toJSONString((Object)param));
        String cloudId = "rpac";
        String appId = "rpacp";
        if (RpaServiceHelper.isUnitTest()) {
            cloudId = "tmc";
            appId = "bcr";
        }
        Object result = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)SERVICE, (String)method, (Object[])param);
        logger.info(JSON.toJSONString((Object)result));
        return result;
    }

    private static boolean isUnitTest() {
        String property = System.getProperty("unit_test");
        if (property != null && "tmc".equals(property)) {
            logger.info("\u83b7\u53d6\u5230\u5355\u5143\u6d4b\u8bd5\u7cfb\u7edf\u53c2\u6570");
            return true;
        }
        return false;
    }
}

