/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    protected static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public static Timestamp getCurrentTime() {
        return new Timestamp(new Date().getTime());
    }

    public static Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i);
        return cal.getTime();
    }

    public static Date getLastYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) - i);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff + 1;
        return days;
    }

    public static int getDiffHours(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endTime.getTime() - beginTime.getTime()) / 3600000L;
        int hours = (int)diff;
        return hours;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String formatString(Date date, String forPattern) {
        return new DateTime((Object)date).toString(DateTimeFormat.forPattern((String)forPattern));
    }

    public static int getDay(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(8));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(5, 7));
    }

    public static int getYear(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 4));
    }

    public static Map<String, Date> getWeekDate() {
        return DateUtils.getWeekDate(new Date());
    }

    public static int getCurrWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static Map<String, Date> getWeekDate(Date date) {
        HashMap<String, Date> weekDate = new HashMap<String, Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        weekDate.put("beginDate", cal.getTime());
        cal.add(7, 6);
        weekDate.put("endDate", cal.getTime());
        return weekDate;
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static Date stringToDate(String s, String format) {
        Date date = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            date = formater.parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = DateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 3);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = DateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getFirstDayOfWeek(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getAppointDay(int year, int month, int day) {
        Calendar instance = Calendar.getInstance();
        instance.set(year, month - 1, day);
        return DateUtils.getDataFormat(instance.getTime(), true);
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static boolean isSameYear(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        return year1 == year2;
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        return month1 == month2;
    }

    public static Date getNextWeek(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(4, cal.get(4) + i);
        return cal.getTime();
    }

    public static List<Date> getMonthCycList(Date startDate, Date endDate, int MonthCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dateNum = cal.get(5);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.add(2, MonthCycle);
            int actualMaximum = cal.getActualMaximum(5);
            if (actualMaximum < dateNum) {
                cal.set(5, actualMaximum);
            } else {
                cal.set(5, dateNum);
            }
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    public static List<Date> getWeekCycList(Date startDate, Date endDate, int weekCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.set(4, cal.get(4) + weekCycle);
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    public static String getDiff_ymd(Date startDate, Date endDate) {
        startDate = DateUtils.truncateDate(startDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startY = cal.get(1);
        int startM = cal.get(2);
        int startD = cal.get(5);
        int startDayOfMonth = cal.getActualMaximum(5);
        cal.setTime(endDate);
        int endY = cal.get(1);
        int endM = cal.get(2);
        int endD = cal.get(5);
        int endDayOfMonth = cal.getActualMaximum(5);
        StringBuilder sBuilder = new StringBuilder();
        int lday = endD - startD;
        if (lday < 0) {
            --endM;
            lday = startDayOfMonth + lday;
        }
        if (lday == endDayOfMonth) {
            ++endM;
            lday = 0;
        }
        int mos = (endY - startY) * 12 + (endM - startM);
        int lyear = mos / 12;
        int lmonth = mos % 12;
        if (lyear > 0) {
            sBuilder.append(lyear).append("y");
        }
        if (lmonth > 0) {
            sBuilder.append(lmonth).append("m");
        }
        if (lday > 0) {
            sBuilder.append(lday).append("d");
        }
        return sBuilder.toString();
    }

    public static void main(String[] args) {
        System.out.println(new LocalDate().toString(DATE_FORMATTER));
        System.out.println(DateUtils.getDataFormat(new Date(), true));
        System.out.println(DateUtils.getDataFormat(new Date(), false));
        System.out.println(DateUtils.getNextDay(new Date(), -1));
    }
}

