/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.formplugin.chart;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.plugin.AbstractFormPlugin;

public abstract class AbstractLineChartEdit
extends AbstractFormPlugin {
    protected static String AxisColor = "#999999";
    protected static String splitColor = "#E2E2E2";
    protected static String LineColor = "#3f007f";
    protected static String PointColor = "#FF0000";

    protected void drawChart() {
        this.clearData();
        Chart chart = (Chart)this.getControl(this.getChartCtlName());
        chart.clearData();
        if (this.isSwitchXY()) {
            this.drawXAxis(chart, this.getYTitleName());
            this.drawYAxis(chart, this.getXTitleName());
        } else {
            this.drawXAxis(chart, this.getXTitleName());
            this.drawYAxis(chart, this.getYTitleName());
        }
        List<Object> ys = this.getSeriesValue();
        for (int index = 0; index < ys.size(); ++index) {
            Object y = ys.get(index);
            this.drawSeries(index, chart, this.getSeriesTitleName(index), y);
        }
        this.getPageCache().put("index", String.valueOf(ys.size()));
        List<Object> point = this.getPointValue();
        if (point != null) {
            this.drawPoint(999, chart, this.getSeriesTitleName(999), point);
        }
        chart.refresh();
    }

    protected boolean isSwitchXY() {
        return false;
    }

    private void drawXAxis(Chart chart, String name) {
        Axis axis = null;
        if (this.getXValue() != null) {
            axis = this.isSwitchXY() ? chart.createYAxis(name, AxisType.category) : chart.createXAxis(name, AxisType.category);
            axis.setCategorys(this.getXValue());
        } else {
            Number[] X = this.getXValueRange();
            if (X != null && X.length == 2 && X[0] != null && X[1] != null) {
                axis = chart.createXAxis(name, AxisType.value);
                axis.setMin(X[0]);
                axis.setMax(X[1]);
                axis.setInterval((Number)new BigDecimal(X[1].toString()).divide(new BigDecimal("10"), 4, 4));
            }
            this.getPageCache().put("X", JSON.toJSONString((Object)X));
        }
        if (axis == null) {
            axis = chart.createXAxis(name, AxisType.value);
        }
        this.initXStyle(axis);
    }

    private void drawYAxis(Chart chart, String name) {
        Axis axis = null;
        Number[] Y = this.getYValueRange();
        axis = this.isSwitchXY() ? chart.createXAxis(name, AxisType.value) : chart.createYAxis(name, AxisType.value);
        if (Y != null && Y.length == 2) {
            axis.setMin(Y[0]);
            axis.setMax(Y[1]);
            axis.setInterval((Number)new BigDecimal(Y[1].toString()).divide(new BigDecimal("10"), 4, 4));
        }
        this.initYStyle(axis);
        this.getPageCache().put("Y", JSON.toJSONString((Object)Y));
    }

    protected void drawSeries(int index, Chart chart, String name, Object Val) {
        Series series = this.createSeries(chart, name);
        series.setPropValue("id", (Object)index);
        series.setPropValue("data", Val);
        this.initSeriesStyle(index, chart, series, LineColor);
    }

    protected Series createSeries(Chart chart, String name) {
        if (chart instanceof PointLineChart) {
            return ((PointLineChart)chart).createSeries(name);
        }
        if (chart instanceof BarChart) {
            return ((BarChart)chart).createSeries(name);
        }
        if (chart instanceof HistogramChart) {
            return ((HistogramChart)chart).createSeries(name);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u56fe\u5f62", (String)"AbstractLineChartEdit_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
    }

    private void drawPoint(int index, Chart chart, String name, Object Val) {
        Series series = this.createSeries(chart, name);
        series.setPropValue("id", (Object)index);
        series.setPropValue("data", Val);
        series.setAnimationDuration(2000);
        series.setItemColor(PointColor);
        chart.setShowTooltip(true);
        series.setPropValue("symbolSize", (Object)10);
        series.setPropValue("symbol", (Object)"circle");
    }

    protected void initXStyle(Axis axis) {
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>();
        splitLine.put("show", Boolean.FALSE);
        axis.setPropValue("splitLine", splitLine);
        this.setAxisStyle(axis, AxisColor);
    }

    protected void initYStyle(Axis axis) {
        this.setLineStyle(axis, splitColor, "dotted");
        this.setAxisStyle(axis, AxisColor);
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        chart.setMargin(Position.left, "80px");
        chart.setMargin(Position.right, "100px");
        chart.setMargin(Position.top, "50px");
        series.setAnimationDuration(2000);
        series.setItemColor(color);
        chart.setShowTooltip(true);
    }

    private void setLineStyle(Axis axis, String color, String type) {
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        if (type != null) {
            lineStyle.put("type", "dotted");
        }
        lineStyle.put("color", color);
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
    }

    private void setAxisStyle(Axis axis, String color) {
        HashMap axisLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", color);
        axisLine.put("lineStyle", lineStyle);
        axis.setPropValue("axisLine", axisLine);
    }

    protected Number[] getXValueRange() {
        return null;
    }

    protected Number[] getYValueRange() {
        return null;
    }

    protected String[] getXValue() {
        return null;
    }

    protected List<Object> getPointValue() {
        return null;
    }

    protected String getSeriesTitleName(int index) {
        return null;
    }

    protected void clearData() {
        Chart chart = (Chart)this.getControl(this.getChartCtlName());
        chart.clearData();
    }

    protected boolean isDreawPoint() {
        return false;
    }

    protected abstract String getXTitleName();

    protected abstract String getYTitleName();

    protected abstract String getChartCtlName();

    protected abstract List<Object> getSeriesValue();
}

