/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.formplugin.home;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bcr.common.enums.ExeStatusEnum;
import kd.tmc.bcr.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class RobotLogCardPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"failedcount", "successcount", "runningcount", "pendingcount", "btn_refresh", "execdaterange"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"customdate"});
        this.loadExecutLogNumber();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "failedcount": {
                this.getRobotLogList(ExeStatusEnum.FAILED.getValue());
                break;
            }
            case "successcount": {
                this.getRobotLogList(ExeStatusEnum.SUCCESS.getValue());
                break;
            }
            case "runningcount": {
                this.getRobotLogList(ExeStatusEnum.RUNNING.getValue());
                break;
            }
            case "pendingcount": {
                this.getRobotLogList(ExeStatusEnum.PENDING.getValue());
                break;
            }
            case "btn_refresh": {
                this.loadExecutLogNumber();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("execdaterange".equals(key)) {
            String value = (String)this.getModel().getValue("execdaterange");
            if ("custom".equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"customdate"});
                this.getModel().setValue("execstartdate", null);
                this.getModel().setValue("execenddate", null);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"customdate"});
                this.loadExecutLogNumber();
            }
        }
    }

    private void getRobotLogList(String status) {
        ListShowParameter showList = new ListShowParameter();
        showList.setBillFormId("bcr_robotscheme_log");
        showList.setFormId("bos_list");
        showList.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showList.getOpenStyle().setTargetKey("_submaintab_");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("createtime", this.getDateMap());
        params.put("exestatus", status);
        showList.setCustomParams(params);
        this.getView().showForm((FormShowParameter)showList);
    }

    private void loadExecutLogNumber() {
        int failed = 0;
        int success = 0;
        int running = 0;
        int pending = 0;
        Label failedLable = (Label)this.getView().getControl("failedcount");
        Label succeessLable = (Label)this.getView().getControl("successcount");
        Label runningLable = (Label)this.getView().getControl("runningcount");
        Label pendingLable = (Label)this.getView().getControl("pendingcount");
        Map<String, Object> dateMap = this.getDateMap();
        QFilter[] dateFilters = new QFilter[]{new QFilter("createtime", ">=", dateMap.get("execstartdate")), new QFilter("createtime", "<=", dateMap.get("execenddate"))};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadExecutLogNumber()", (String)"bcr_robotscheme_log", (String)"exestatus", (QFilter[])dateFilters, null);){
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"exestatus"});
            groupbyDataSet.count();
            DataSet finishSet = groupbyDataSet.finish();
            for (Row row : finishSet) {
                int newCount;
                String status = row.getString("exestatus");
                int n = newCount = null == row.getInteger("count") ? 0 : row.getInteger("count");
                if (StringUtils.equals((CharSequence)ExeStatusEnum.FAILED.getValue(), (CharSequence)status)) {
                    failed = newCount;
                    continue;
                }
                if (StringUtils.equals((CharSequence)ExeStatusEnum.SUCCESS.getValue(), (CharSequence)status)) {
                    success = newCount;
                    continue;
                }
                if (StringUtils.equals((CharSequence)ExeStatusEnum.RUNNING.getValue(), (CharSequence)status)) {
                    running = newCount;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)ExeStatusEnum.PENDING.getValue(), (CharSequence)status)) continue;
                pending = newCount;
            }
            finishSet.close();
        }
        failedLable.setText(String.valueOf(failed));
        succeessLable.setText(String.valueOf(success));
        runningLable.setText(String.valueOf(running));
        pendingLable.setText(String.valueOf(pending));
    }

    private Map<String, Object> getDateMap() {
        String daterange;
        Date curtime = new Date();
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        switch (daterange = (String)this.getModel().getValue("execdaterange")) {
            case "today": {
                dateMap.put("execdaterange", "today");
                dateMap.put("execstartdate", DateUtils.truncateDate((Date)curtime));
                dateMap.put("execenddate", curtime);
                break;
            }
            case "thisweek": {
                dateMap.put("execdaterange", "thisweek");
                dateMap.put("execstartdate", DateUtils.getFirstDayOfWeek((Date)curtime));
                dateMap.put("execenddate", curtime);
                break;
            }
            case "thismonth": {
                dateMap.put("execdaterange", "thismonth");
                dateMap.put("execstartdate", DateUtils.getFirstDayOfMonth((Date)curtime));
                dateMap.put("execenddate", curtime);
                break;
            }
            case "threemonth": {
                dateMap.put("execdaterange", "threemonth");
                dateMap.put("execstartdate", DateUtils.getLastMonth((Date)curtime, (int)3));
                dateMap.put("execenddate", curtime);
                break;
            }
            case "custom": {
                dateMap.put("execdaterange", "custom");
                dateMap.put("execstartdate", this.getModel().getValue("execstartdate"));
                dateMap.put("execenddate", this.getModel().getValue("execenddate"));
            }
        }
        return dateMap;
    }
}

