/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bcr.common.enums.ExeStatusEnum;
import kd.tmc.bcr.common.util.DateUtils;
import kd.tmc.bcr.formplugin.chart.AbstractLineChartEdit;

public class RobotLogLineChartPlugin
extends AbstractLineChartEdit
implements ClickListener {
    private List<String> bankNameList = new ArrayList<String>(10);
    private String[] lineColor = new String[]{"#ff96ad", "#fb2323", "#ff991c", "#3dccc0", "#1ba854", "#ffe45c", "#45cdff", "#276ff5", "#9a4dff"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.drawChart();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_refresh".equals(key)) {
            super.drawChart();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("choosebank".equals(formOperate.getOperateKey())) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("bcr_homeset");
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"bcr_homeset", (String)"id", (QFilter[])new QFilter[0]);
            if (baseData != null) {
                showParameter.setPkId(baseData.getPkValue());
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcr_homeset"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        super.drawChart();
    }

    @Override
    protected String getXTitleName() {
        return ResManager.loadKDString((String)"\u65e5\u671f", (String)"RobotLogLineChartPlugin_0", (String)"tmc-bcr-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected String getYTitleName() {
        return ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u7387(%)", (String)"RobotLogLineChartPlugin_1", (String)"tmc-bcr-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected String getChartCtlName() {
        return "pointlinechartap";
    }

    @Override
    protected List<Object> getSeriesValue() {
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"bcr_homeset", (String)"id,bank", (QFilter[])new QFilter[0]);
        ArrayList<Object> allLine = new ArrayList<Object>(10);
        if (baseData != null) {
            DynamicObjectCollection banks = baseData.getDynamicObjectCollection("bank");
            List bankIdList = banks.stream().map(b -> b.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
            this.bankNameList = banks.stream().map(b -> b.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
            List<String> xDateList = this.getXDateList();
            int startyear = Integer.parseInt(xDateList.get(0).split("-")[0]);
            int startmonth = Integer.parseInt(xDateList.get(0).split("-")[1]);
            Date startDate = this.getMonthFirst(startyear, startmonth);
            Date endDate = new Date();
            String[] exestatus = new String[]{ExeStatusEnum.FAILED.getValue(), ExeStatusEnum.SUCCESS.getValue()};
            QFilter qFilter = new QFilter("createtime", ">=", (Object)startDate);
            qFilter.and("createtime", "<", (Object)endDate);
            qFilter.and("exestatus", "in", (Object)exestatus);
            qFilter.and("bank", "in", bankIdList);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"oneYearRobotLog", (String)"bcr_robotscheme_log", (String)"id,createtime,exestatus,bank", (QFilter[])qFilter.toArray(), (String)"createtime");
            for (Object bank : bankIdList) {
                DataSet bankDataSet = dataSet.copy().filter("bank = " + bank);
                ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(12);
                for (String xDate : xDateList) {
                    int year = Integer.parseInt(xDate.split("-")[0]);
                    int month = Integer.parseInt(xDate.split("-")[1]);
                    String monthFirstDate = DateUtils.formatString((Date)this.getMonthFirst(year, month), (String)"yyyyMMdd");
                    String monthLastDate = DateUtils.formatString((Date)this.getMonthLast(year, month), (String)"yyyyMMdd");
                    DataSet tempDataSet = bankDataSet.copy().filter("to_char(createtime,'yyyyMMdd') >= " + monthFirstDate + " and to_char(createtime,'yyyyMMdd') <= " + monthLastDate);
                    DataSet successDataSet = tempDataSet.copy().filter("exestatus = 'success'");
                    BigDecimal successCount = BigDecimal.valueOf(successDataSet.count("id", false));
                    BigDecimal allCount = BigDecimal.valueOf(tempDataSet.count("id", false));
                    BigDecimal successRate = allCount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : successCount.divide(allCount, 4, 4).movePointRight(2);
                    result.add(successRate);
                }
                allLine.add(result);
            }
        }
        return allLine;
    }

    @Override
    protected String getSeriesTitleName(int index) {
        return this.bankNameList.get(index);
    }

    @Override
    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        chart.setMargin(Position.left, "40px");
        chart.setMargin(Position.right, "60px");
        chart.setMargin(Position.top, "60px");
        LineSeries line = (LineSeries)series;
        line.setItemColor(this.lineColor[index]);
    }

    private Date getMonthFirst(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int firstDay = calendar.getActualMinimum(5);
        calendar.set(5, firstDay);
        return calendar.getTime();
    }

    private Date getMonthLast(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        int lastDay = calendar.getActualMinimum(5);
        calendar.set(5, lastDay);
        calendar.add(13, -1);
        return calendar.getTime();
    }

    @Override
    protected String[] getXValue() {
        List<String> xDateList = this.getXDateList();
        String[] xValue = new String[12];
        for (int i = 0; i < xDateList.size(); ++i) {
            xValue[i] = xDateList.get(i);
        }
        return xValue;
    }

    private List<String> getXDateList() {
        ArrayList<String> monthList = new ArrayList<String>(20);
        Calendar calendar = Calendar.getInstance();
        int num = 1;
        if (this.isFirstDayOfMonth(calendar)) {
            num = 0;
        }
        calendar.set(2, calendar.get(2) + num);
        for (int i = 0; i < 12; ++i) {
            calendar.add(2, -1);
            String month = calendar.get(1) + "-" + this.fillZero(calendar.get(2) + 1);
            monthList.add(month);
        }
        Collections.reverse(monthList);
        return monthList;
    }

    private boolean isFirstDayOfMonth(Calendar calendar) {
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + 1);
        return calendar.get(5) == 2;
    }

    private String fillZero(int i) {
        String month = i < 10 ? "0" + i : String.valueOf(i);
        return month;
    }
}

