/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bcr.formplugin.process;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bcr.common.helper.RpaServiceHelper;
import kd.tmc.bcr.common.helper.ViewInputHelper;

public class ProcessPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ProcessPlugin.class);

    public void afterBindData(EventObject e) {
        this.loanProcessDetail();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("ok".equals(args.getOperateKey())) {
            int[] index = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
            if (index == null || index.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761RPA\u6d41\u7a0b\u6570\u636e\u3002", (String)"ProcessPlugin_0", (String)"tmc-bcr-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("procname", this.getModel().getValue("procname", index[0]));
            returnData.put("proccode", this.getModel().getValue("proccode", index[0]));
            returnData.put("procid", this.getModel().getValue("procid", index[0]));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void loanProcessDetail() {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        List result = RpaServiceHelper.getProcessList((String)userId, null);
        if (result == null || result.isEmpty()) {
            logger.info("RPA getProcessList result is null, userId " + RequestContext.get().getCurrUserId());
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(result.size());
        for (int i = 0; i < result.size(); ++i) {
            Map data = (Map)result.get(i);
            if (result == null || result.isEmpty()) continue;
            dataMap.add(this.assembleRow(data));
        }
        ViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entryentity");
    }

    private Map<String, Object> assembleRow(Map<String, Object> dataMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("procid", dataMap.get("id"));
        data.put("proccode", dataMap.get("procCode"));
        data.put("procname", dataMap.get("procName"));
        data.put("procver", dataMap.get("procVer"));
        data.put("proclabel", dataMap.get("procLabel"));
        data.put("procdesc", dataMap.get("procDesc"));
        data.put("publishtime", dataMap.get("publishTime"));
        return data;
    }
}

